/*
 * Decompiled with CFR 0.152.
 */
package javax.time.i18n;

import java.io.Serializable;
import javax.time.calendar.Calendrical;
import javax.time.calendar.Chronology;
import javax.time.calendar.DateTimeFieldRule;
import javax.time.calendar.LocalDate;
import javax.time.calendar.LocalTime;
import javax.time.i18n.CopticDate;
import javax.time.period.PeriodUnits;

public final class CopticChronology
extends Chronology
implements Serializable {
    public static final CopticChronology INSTANCE = new CopticChronology();
    private static final long serialVersionUID = 24275872L;

    private CopticChronology() {
    }

    private Object readResolve() {
        return INSTANCE;
    }

    public static boolean isLeapYear(int n) {
        return n % 4 == 3;
    }

    @Override
    public String getName() {
        return "Coptic";
    }

    @Override
    public DateTimeFieldRule year() {
        return YearRule.INSTANCE;
    }

    @Override
    public DateTimeFieldRule monthOfYear() {
        return MonthOfYearRule.INSTANCE;
    }

    @Override
    public DateTimeFieldRule dayOfMonth() {
        return DayOfMonthRule.INSTANCE;
    }

    @Override
    public DateTimeFieldRule dayOfYear() {
        return DayOfYearRule.INSTANCE;
    }

    @Override
    public DateTimeFieldRule dayOfWeek() {
        return DayOfWeekRule.INSTANCE;
    }

    @Override
    public DateTimeFieldRule hourOfDay() {
        throw new UnsupportedOperationException("CopticChronology does not support the hour of day field");
    }

    @Override
    public DateTimeFieldRule minuteOfHour() {
        throw new UnsupportedOperationException("CopticChronology does not support the minute of hour field");
    }

    @Override
    public DateTimeFieldRule secondOfMinute() {
        throw new UnsupportedOperationException("CopticChronology does not support the second of minute field");
    }

    @Override
    public DateTimeFieldRule nanoOfSecond() {
        throw new UnsupportedOperationException("CopticChronology does not support the nano of second field");
    }

    private static final class DayOfWeekRule
    extends DateTimeFieldRule
    implements Serializable {
        private static final DateTimeFieldRule INSTANCE = new DayOfWeekRule();
        private static final long serialVersionUID = 1L;

        private DayOfWeekRule() {
            super(INSTANCE, "DayOfWeek", PeriodUnits.DAYS, PeriodUnits.WEEKS, 1, 7);
        }

        private Object readResolve() {
            return INSTANCE;
        }

        @Override
        public Integer getValueQuiet(LocalDate localDate, LocalTime localTime) {
            return localDate == null ? null : Integer.valueOf(CopticDate.copticDate(localDate).getDayOfWeek());
        }
    }

    private static final class DayOfYearRule
    extends DateTimeFieldRule
    implements Serializable {
        private static final DateTimeFieldRule INSTANCE = new DayOfYearRule();
        private static final long serialVersionUID = 1L;

        private DayOfYearRule() {
            super(INSTANCE, "DayOfYear", PeriodUnits.DAYS, PeriodUnits.YEARS, 1, 366);
        }

        private Object readResolve() {
            return INSTANCE;
        }

        @Override
        public int getSmallestMaximumValue() {
            return 365;
        }

        @Override
        public int getMaximumValue(Calendrical calendrical) {
            Integer n = calendrical.deriveValueQuiet(INSTANCE.year());
            if (n != null) {
                return CopticChronology.isLeapYear(n) ? 366 : 365;
            }
            return this.getMaximumValue();
        }

        @Override
        public Integer getValueQuiet(LocalDate localDate, LocalTime localTime) {
            return localDate == null ? null : Integer.valueOf(CopticDate.copticDate(localDate).getDayOfYear());
        }

        @Override
        protected void mergeDateTime(Calendrical.Merger merger) {
            Integer n = merger.getValueQuiet(INSTANCE.year());
            if (n != null) {
                int n2 = merger.getValue(this);
                CopticDate copticDate = merger.isStrict() ? CopticDate.copticDate(n, 1, 1).withDayOfYear(n2) : CopticDate.copticDate(n, 1, 1).plusDays(n2).plusDays(-1);
                merger.storeMergedDate(copticDate.toLocalDate());
                merger.markFieldAsProcessed(this);
                merger.markFieldAsProcessed(INSTANCE.year());
            }
        }
    }

    private static final class DayOfMonthRule
    extends DateTimeFieldRule
    implements Serializable {
        private static final DateTimeFieldRule INSTANCE = new DayOfMonthRule();
        private static final long serialVersionUID = 1L;

        private DayOfMonthRule() {
            super(INSTANCE, "DayOfMonth", PeriodUnits.DAYS, PeriodUnits.MONTHS, 1, 30);
        }

        private Object readResolve() {
            return INSTANCE;
        }

        @Override
        public int getSmallestMaximumValue() {
            return 5;
        }

        @Override
        public int getMaximumValue(Calendrical calendrical) {
            Integer n = calendrical.deriveValueQuiet(INSTANCE.year());
            Integer n2 = calendrical.deriveValueQuiet(INSTANCE.monthOfYear());
            if (n != null && n2 != null) {
                if (n2 == 13) {
                    return CopticChronology.isLeapYear(n) ? 6 : 5;
                }
                return 30;
            }
            return this.getMaximumValue();
        }

        @Override
        public Integer getValueQuiet(LocalDate localDate, LocalTime localTime) {
            return localDate == null ? null : Integer.valueOf(CopticDate.copticDate(localDate).getDayOfMonth());
        }
    }

    private static final class MonthOfYearRule
    extends DateTimeFieldRule
    implements Serializable {
        private static final DateTimeFieldRule INSTANCE = new MonthOfYearRule();
        private static final long serialVersionUID = 1L;

        private MonthOfYearRule() {
            super(INSTANCE, "MonthOfYear", PeriodUnits.MONTHS, PeriodUnits.YEARS, 1, 13);
        }

        private Object readResolve() {
            return INSTANCE;
        }

        @Override
        public Integer getValueQuiet(LocalDate localDate, LocalTime localTime) {
            return localDate == null ? null : Integer.valueOf(CopticDate.copticDate(localDate).getMonthOfYear());
        }
    }

    private static final class YearRule
    extends DateTimeFieldRule
    implements Serializable {
        private static final DateTimeFieldRule INSTANCE = new YearRule();
        private static final long serialVersionUID = 1L;

        private YearRule() {
            super(INSTANCE, "Year", PeriodUnits.YEARS, null, 1, 9999);
        }

        private Object readResolve() {
            return INSTANCE;
        }

        @Override
        public Integer getValueQuiet(LocalDate localDate, LocalTime localTime) {
            return localDate == null ? null : Integer.valueOf(CopticDate.copticDate(localDate).getYear());
        }

        @Override
        protected void mergeDateTime(Calendrical.Merger merger) {
            Integer n = merger.getValueQuiet(INSTANCE.monthOfYear());
            Integer n2 = merger.getValueQuiet(INSTANCE.dayOfMonth());
            if (n != null && n2 != null) {
                int n3 = merger.getValue(this);
                CopticDate copticDate = merger.isStrict() ? CopticDate.copticDate(n3, n, n2) : CopticDate.copticDate(n3, 1, 1).plusMonths(n).plusMonths(-1).plusDays(n2).plusDays(-1);
                merger.storeMergedDate(copticDate.toLocalDate());
                merger.markFieldAsProcessed(this);
                merger.markFieldAsProcessed(INSTANCE.monthOfYear());
                merger.markFieldAsProcessed(INSTANCE.dayOfMonth());
            }
        }
    }
}

