/*
 * Decompiled with CFR 0.152.
 */
package javax.time.period;

import java.io.Serializable;
import javax.time.CalendricalException;
import javax.time.Duration;
import javax.time.MathUtils;
import javax.time.period.PeriodFields;
import javax.time.period.PeriodParser;
import javax.time.period.PeriodProvider;

public final class Period
implements PeriodProvider,
Serializable {
    public static final Period ZERO = new Period(0, 0, 0, 0, 0, 0, 0L);
    private static final long serialVersionUID = 1L;
    private final int years;
    private final int months;
    private final int days;
    private final int hours;
    private final int minutes;
    private final int seconds;
    private final long nanos;
    private volatile transient String string;

    public static Period period(PeriodProvider periodProvider) {
        if (periodProvider == null) {
            throw new NullPointerException("Period provider must not be null");
        }
        Period period = periodProvider.toPeriod();
        if (period == null) {
            throw new NullPointerException("The implementation of PeriodProvider must not return null");
        }
        return period;
    }

    public static Period period(int n, int n2, int n3, int n4, int n5, int n6) {
        if ((n | n2 | n3 | n4 | n5 | n6) == 0) {
            return ZERO;
        }
        return new Period(n, n2, n3, n4, n5, n6, 0L);
    }

    public static Period period(int n, int n2, int n3, int n4, int n5, int n6, long l) {
        if (((long)(n | n2 | n3 | n4 | n5 | n6) | l) == 0L) {
            return ZERO;
        }
        return new Period(n, n2, n3, n4, n5, n6, l);
    }

    public static Period yearsMonths(int n, int n2) {
        if ((n | n2) == 0) {
            return ZERO;
        }
        return new Period(n, n2, 0, 0, 0, 0, 0L);
    }

    public static Period yearsMonthsDays(int n, int n2, int n3) {
        if ((n | n2 | n3) == 0) {
            return ZERO;
        }
        return new Period(n, n2, n3, 0, 0, 0, 0L);
    }

    public static Period hoursMinutesSeconds(int n, int n2, int n3) {
        if ((n | n2 | n3) == 0) {
            return ZERO;
        }
        return new Period(0, 0, 0, n, n2, n3, 0L);
    }

    public static Period years(int n) {
        if (n == 0) {
            return ZERO;
        }
        return new Period(n, 0, 0, 0, 0, 0, 0L);
    }

    public static Period months(int n) {
        if (n == 0) {
            return ZERO;
        }
        return new Period(0, n, 0, 0, 0, 0, 0L);
    }

    public static Period days(int n) {
        if (n == 0) {
            return ZERO;
        }
        return new Period(0, 0, n, 0, 0, 0, 0L);
    }

    public static Period hours(int n) {
        if (n == 0) {
            return ZERO;
        }
        return new Period(0, 0, 0, n, 0, 0, 0L);
    }

    public static Period minutes(int n) {
        if (n == 0) {
            return ZERO;
        }
        return new Period(0, 0, 0, 0, n, 0, 0L);
    }

    public static Period seconds(int n) {
        if (n == 0) {
            return ZERO;
        }
        return new Period(0, 0, 0, 0, 0, n, 0L);
    }

    public static Period nanos(long l) {
        if (l == 0L) {
            return ZERO;
        }
        return new Period(0, 0, 0, 0, 0, 0, l);
    }

    public static Period parse(String string) {
        PeriodFields.checkNotNull(string, "Text to parse must not be null");
        return PeriodParser.getInstance().parse(string);
    }

    private Period(int n, int n2, int n3, int n4, int n5, int n6, long l) {
        this.years = n;
        this.months = n2;
        this.days = n3;
        this.hours = n4;
        this.minutes = n5;
        this.seconds = n6;
        this.nanos = l;
    }

    private Object readResolve() {
        if (((long)(this.years | this.months | this.days | this.hours | this.minutes | this.seconds) | this.nanos) == 0L) {
            return ZERO;
        }
        return this;
    }

    public boolean isZero() {
        return this == ZERO;
    }

    public int getYears() {
        return this.years;
    }

    public int getMonths() {
        return this.months;
    }

    public int getDays() {
        return this.days;
    }

    public int getHours() {
        return this.hours;
    }

    public int getMinutes() {
        return this.minutes;
    }

    public int getSeconds() {
        return this.seconds;
    }

    public long getNanos() {
        return this.nanos;
    }

    public int getNanosInt() {
        return MathUtils.safeToInt(this.nanos);
    }

    public Period withYears(int n) {
        if (n == this.years) {
            return this;
        }
        return Period.period(n, this.months, this.days, this.hours, this.minutes, this.seconds, this.nanos);
    }

    public Period withMonths(int n) {
        if (n == this.months) {
            return this;
        }
        return Period.period(this.years, n, this.days, this.hours, this.minutes, this.seconds, this.nanos);
    }

    public Period withDays(int n) {
        if (n == this.days) {
            return this;
        }
        return Period.period(this.years, this.months, n, this.hours, this.minutes, this.seconds, this.nanos);
    }

    public Period withHours(int n) {
        if (n == this.hours) {
            return this;
        }
        return Period.period(this.years, this.months, this.days, n, this.minutes, this.seconds, this.nanos);
    }

    public Period withMinutes(int n) {
        if (n == this.minutes) {
            return this;
        }
        return Period.period(this.years, this.months, this.days, this.hours, n, this.seconds, this.nanos);
    }

    public Period withSeconds(int n) {
        if (n == this.seconds) {
            return this;
        }
        return Period.period(this.years, this.months, this.days, this.hours, this.minutes, n, this.nanos);
    }

    public Period withNanos(long l) {
        if (l == this.nanos) {
            return this;
        }
        return Period.period(this.years, this.months, this.days, this.hours, this.minutes, this.seconds, l);
    }

    public Period plus(PeriodProvider periodProvider) {
        Period period = Period.period(periodProvider);
        return Period.period(MathUtils.safeAdd(this.years, period.years), MathUtils.safeAdd(this.months, period.months), MathUtils.safeAdd(this.days, period.days), MathUtils.safeAdd(this.hours, period.hours), MathUtils.safeAdd(this.minutes, period.minutes), MathUtils.safeAdd(this.seconds, period.seconds), MathUtils.safeAdd(this.nanos, period.nanos));
    }

    public Period plusYears(int n) {
        return this.withYears(MathUtils.safeAdd(this.years, n));
    }

    public Period plusMonths(int n) {
        return this.withMonths(MathUtils.safeAdd(this.months, n));
    }

    public Period plusDays(int n) {
        return this.withDays(MathUtils.safeAdd(this.days, n));
    }

    public Period plusHours(int n) {
        return this.withHours(MathUtils.safeAdd(this.hours, n));
    }

    public Period plusMinutes(int n) {
        return this.withMinutes(MathUtils.safeAdd(this.minutes, n));
    }

    public Period plusSeconds(int n) {
        return this.withSeconds(MathUtils.safeAdd(this.seconds, n));
    }

    public Period plusNanos(long l) {
        return this.withNanos(MathUtils.safeAdd(this.nanos, l));
    }

    public Period minus(PeriodProvider periodProvider) {
        Period period = Period.period(periodProvider);
        return Period.period(MathUtils.safeSubtract(this.years, period.years), MathUtils.safeSubtract(this.months, period.months), MathUtils.safeSubtract(this.days, period.days), MathUtils.safeSubtract(this.hours, period.hours), MathUtils.safeSubtract(this.minutes, period.minutes), MathUtils.safeSubtract(this.seconds, period.seconds), MathUtils.safeSubtract(this.nanos, period.nanos));
    }

    public Period minusYears(int n) {
        return this.withYears(MathUtils.safeSubtract(this.years, n));
    }

    public Period minusMonths(int n) {
        return this.withMonths(MathUtils.safeSubtract(this.months, n));
    }

    public Period minusDays(int n) {
        return this.withDays(MathUtils.safeSubtract(this.days, n));
    }

    public Period minusHours(int n) {
        return this.withHours(MathUtils.safeSubtract(this.hours, n));
    }

    public Period minusMinutes(int n) {
        return this.withMinutes(MathUtils.safeSubtract(this.minutes, n));
    }

    public Period minusSeconds(int n) {
        return this.withSeconds(MathUtils.safeSubtract(this.seconds, n));
    }

    public Period minusNanos(long l) {
        return this.withNanos(MathUtils.safeSubtract(this.nanos, l));
    }

    public Period multipliedBy(int n) {
        if (this == ZERO || n == 1) {
            return this;
        }
        return Period.period(MathUtils.safeMultiply(this.years, n), MathUtils.safeMultiply(this.months, n), MathUtils.safeMultiply(this.days, n), MathUtils.safeMultiply(this.hours, n), MathUtils.safeMultiply(this.minutes, n), MathUtils.safeMultiply(this.seconds, n), MathUtils.safeMultiply(this.nanos, n));
    }

    public Period dividedBy(int n) {
        if (n == 0) {
            throw new ArithmeticException("Cannot divide by zero");
        }
        if (this == ZERO || n == 1) {
            return this;
        }
        return Period.period(this.years / n, this.months / n, this.days / n, this.hours / n, this.minutes / n, this.seconds / n, this.nanos / (long)n);
    }

    public Period negated() {
        return this.multipliedBy(-1);
    }

    public Period normalized() {
        if (this == ZERO) {
            return ZERO;
        }
        int n = this.years;
        int n2 = this.months;
        if (n2 >= 12) {
            n = MathUtils.safeAdd(n, n2 / 12);
            n2 %= 12;
        }
        long l = (long)this.hours * 60L * 60L + (long)this.minutes * 60L + (long)this.seconds;
        l = MathUtils.safeMultiply(l, 1000000000);
        l = MathUtils.safeAdd(l, this.nanos);
        long l2 = l % 1000000000L;
        int n3 = (int)((l /= 1000000000L) % 60L);
        int n4 = (int)((l /= 60L) % 60L);
        int n5 = MathUtils.safeToInt(l /= 60L);
        return Period.period(n, n2, this.days, n5, n4, n3, l2);
    }

    public Period normalizedWith24HourDays() {
        if (this == ZERO) {
            return ZERO;
        }
        int n = this.years;
        int n2 = this.months;
        if (n2 >= 12) {
            n = MathUtils.safeAdd(n, n2 / 12);
            n2 %= 12;
        }
        long l = (long)this.days * 24L * 60L * 60L + (long)this.hours * 60L * 60L + (long)this.minutes * 60L + (long)this.seconds;
        l = MathUtils.safeMultiply(l, 1000000000);
        l = MathUtils.safeAdd(l, this.nanos);
        long l2 = l % 1000000000L;
        int n3 = (int)((l /= 1000000000L) % 60L);
        int n4 = (int)((l /= 60L) % 60L);
        int n5 = (int)((l /= 60L) % 24L);
        int n6 = MathUtils.safeToInt(l /= 24L);
        return Period.period(n, n2, n6, n5, n4, n3, l2);
    }

    public long totalYears() {
        return (long)this.years + (long)this.months / 12L;
    }

    public long totalMonths() {
        return (long)this.years * 12L + (long)this.months;
    }

    public long totalDaysWith24HourDays() {
        if (this == ZERO) {
            return 0L;
        }
        return (long)this.days + ((long)this.hours + ((long)this.minutes + ((long)this.seconds + this.nanos / 1000000000L) / 60L) / 60L) / 24L;
    }

    public long totalHours() {
        if (this == ZERO) {
            return 0L;
        }
        return (long)this.hours + ((long)this.minutes + ((long)this.seconds + this.nanos / 1000000000L) / 60L) / 60L;
    }

    public long totalHoursWith24HourDays() {
        if (this == ZERO) {
            return 0L;
        }
        return (long)this.days * 24L + (long)this.hours + ((long)this.minutes + ((long)this.seconds + this.nanos / 1000000000L) / 60L) / 60L;
    }

    public long totalMinutes() {
        if (this == ZERO) {
            return 0L;
        }
        return (long)this.hours * 60L + (long)this.minutes + ((long)this.seconds + this.nanos / 1000000000L) / 60L;
    }

    public long totalMinutesWith24HourDays() {
        if (this == ZERO) {
            return 0L;
        }
        return ((long)this.days * 24L + (long)this.hours) * 60L + (long)this.minutes + ((long)this.seconds + this.nanos / 1000000000L) / 60L;
    }

    public long totalSeconds() {
        if (this == ZERO) {
            return 0L;
        }
        return ((long)this.hours * 60L + (long)this.minutes) * 60L + (long)this.seconds + this.nanos / 1000000000L;
    }

    public long totalSecondsWith24HourDays() {
        if (this == ZERO) {
            return 0L;
        }
        return (((long)this.days * 24L + (long)this.hours) * 60L + (long)this.minutes) * 60L + (long)this.seconds + this.nanos / 1000000000L;
    }

    public long totalNanos() {
        if (this == ZERO) {
            return 0L;
        }
        long l = ((long)this.hours * 60L + (long)this.minutes) * 60L + (long)this.seconds;
        long l2 = MathUtils.safeMultiply(l, 1000000000L);
        return MathUtils.safeAdd(l2, this.nanos);
    }

    public long totalNanosWith24HourDays() {
        if (this == ZERO) {
            return 0L;
        }
        long l = (((long)this.days * 24L + (long)this.hours) * 60L + (long)this.minutes) * 60L + (long)this.seconds;
        long l2 = MathUtils.safeMultiply(l, 1000000000L);
        return MathUtils.safeAdd(l2, this.nanos);
    }

    @Override
    public Period toPeriod() {
        return this;
    }

    public PeriodFields toPeriodFields() {
        return PeriodFields.periodFields(this);
    }

    public Duration toDuration() {
        if ((this.years | this.months | this.days) > 0) {
            throw new CalendricalException("Unable to convert period to duration as years/months/days are present: " + this);
        }
        long l = ((long)this.hours * 60L + (long)this.minutes) * 60L + (long)this.seconds;
        return Duration.seconds(l, this.nanos);
    }

    public Duration toDurationWith24HourDays() {
        if ((this.years | this.months) > 0) {
            throw new CalendricalException("Unable to convert period to duration as years/months are present: " + this);
        }
        long l = (((long)this.days * 24L + (long)this.hours) * 60L + (long)this.minutes) * 60L + (long)this.seconds;
        return Duration.seconds(l, this.nanos);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Period) {
            Period period = (Period)object;
            return this.years == period.years && this.months == period.months && this.days == period.days & this.hours == period.hours && this.minutes == period.minutes && this.seconds == period.seconds && this.nanos == period.nanos;
        }
        return false;
    }

    public int hashCode() {
        return (this.years << 27 | this.years >>> 5) ^ (this.hours << 22 | this.hours >>> 10) ^ (this.months << 18 | this.months >>> 14) ^ (this.minutes << 12 | this.minutes >>> 20) ^ (this.days << 6 | this.days >>> 26) ^ this.seconds ^ (int)this.nanos + 37;
    }

    public String toString() {
        String string = this.string;
        if (string == null) {
            if (this == ZERO) {
                string = "PT0S";
            } else {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append('P');
                if (this.years != 0) {
                    stringBuilder.append(this.years).append('Y');
                }
                if (this.months != 0) {
                    stringBuilder.append(this.months).append('M');
                }
                if (this.days != 0) {
                    stringBuilder.append(this.days).append('D');
                }
                if ((this.hours | this.minutes | this.seconds) != 0 || this.nanos != 0L) {
                    stringBuilder.append('T');
                    if (this.hours != 0) {
                        stringBuilder.append(this.hours).append('H');
                    }
                    if (this.minutes != 0) {
                        stringBuilder.append(this.minutes).append('M');
                    }
                    if (this.seconds != 0 || this.nanos != 0L) {
                        if (this.nanos == 0L) {
                            stringBuilder.append(this.seconds).append('S');
                        } else {
                            long l = (long)this.seconds + this.nanos / 1000000000L;
                            long l2 = this.nanos % 1000000000L;
                            if (l < 0L && l2 > 0L) {
                                l2 -= 1000000000L;
                                ++l;
                            } else if (l > 0L && l2 < 0L) {
                                l2 += 1000000000L;
                                --l;
                            }
                            if (l2 < 0L) {
                                l2 = -l2;
                                if (l == 0L) {
                                    stringBuilder.append('-');
                                }
                            }
                            stringBuilder.append(l).append('.').append(l2);
                            while (stringBuilder.charAt(stringBuilder.length() - 1) == '0') {
                                stringBuilder.setLength(stringBuilder.length() - 1);
                            }
                            stringBuilder.append('S');
                        }
                    }
                }
                string = stringBuilder.toString();
            }
            this.string = string;
        }
        return string;
    }
}

