/*
 * Decompiled with CFR 0.152.
 */
package javax.time.period;

import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.time.CalendricalException;
import javax.time.MathUtils;
import javax.time.calendar.CalendarConversionException;
import javax.time.period.Period;
import javax.time.period.PeriodProvider;
import javax.time.period.PeriodUnit;
import javax.time.period.PeriodUnits;

public final class PeriodFields
implements PeriodProvider,
Iterable<PeriodUnit>,
Serializable {
    public static final PeriodFields ZERO = new PeriodFields(new TreeMap<PeriodUnit, Long>());
    private static final long serialVersionUID = 986187548716897689L;
    private final TreeMap<PeriodUnit, Long> unitAmountMap;

    public static PeriodFields periodFields(long l, PeriodUnit periodUnit) {
        PeriodFields.checkNotNull(periodUnit, "PeriodUnit must not be null");
        TreeMap<PeriodUnit, Long> treeMap = PeriodFields.createMap();
        treeMap.put(periodUnit, l);
        return PeriodFields.create(treeMap);
    }

    public static PeriodFields periodFields(Map<PeriodUnit, ? extends Number> map) {
        PeriodFields.checkNotNull(map, "Unit-amount map must not be null");
        if (map.isEmpty()) {
            return ZERO;
        }
        TreeMap<PeriodUnit, Long> treeMap = PeriodFields.createMap();
        for (Map.Entry<PeriodUnit, ? extends Number> entry : map.entrySet()) {
            PeriodUnit periodUnit = entry.getKey();
            Number number = entry.getValue();
            PeriodFields.checkNotNull(periodUnit, "Null keys are not permitted in unit-amount map");
            PeriodFields.checkNotNull(number, "Null values are not permitted in unit-amount map");
            treeMap.put(periodUnit, number instanceof Long ? ((Long)number).longValue() : number.longValue());
        }
        return PeriodFields.create(treeMap);
    }

    public static PeriodFields periodFields(PeriodProvider periodProvider) {
        Period period = Period.period(periodProvider);
        if (period.isZero()) {
            return ZERO;
        }
        TreeMap<PeriodUnit, Long> treeMap = PeriodFields.createMap();
        if (period.getYears() != 0) {
            treeMap.put(PeriodUnits.YEARS, Long.valueOf(period.getYears()));
        }
        if (period.getMonths() != 0) {
            treeMap.put(PeriodUnits.MONTHS, Long.valueOf(period.getMonths()));
        }
        if (period.getDays() != 0) {
            treeMap.put(PeriodUnits.DAYS, Long.valueOf(period.getDays()));
        }
        if (period.getHours() != 0) {
            treeMap.put(PeriodUnits.HOURS, Long.valueOf(period.getHours()));
        }
        if (period.getMinutes() != 0) {
            treeMap.put(PeriodUnits.MINUTES, Long.valueOf(period.getMinutes()));
        }
        if (period.getSeconds() != 0) {
            treeMap.put(PeriodUnits.SECONDS, Long.valueOf(period.getSeconds()));
        }
        if (period.getNanos() != 0L) {
            treeMap.put(PeriodUnits.NANOS, period.getNanos());
        }
        return PeriodFields.create(treeMap);
    }

    private static TreeMap<PeriodUnit, Long> createMap() {
        return new TreeMap<PeriodUnit, Long>(Collections.reverseOrder());
    }

    private static PeriodFields create(TreeMap<PeriodUnit, Long> treeMap) {
        if (treeMap.isEmpty()) {
            return ZERO;
        }
        return new PeriodFields(treeMap);
    }

    static void checkNotNull(Object object, String string) {
        if (object == null) {
            throw new NullPointerException(string);
        }
    }

    private PeriodFields(TreeMap<PeriodUnit, Long> treeMap) {
        this.unitAmountMap = treeMap;
    }

    private Object readResolve() {
        if (this.unitAmountMap.size() == 0) {
            return ZERO;
        }
        return this;
    }

    public boolean isZero() {
        if (this == ZERO) {
            return true;
        }
        for (Long l : this.unitAmountMap.values()) {
            if (l == 0L) continue;
            return false;
        }
        return true;
    }

    public int size() {
        return this.unitAmountMap.size();
    }

    @Override
    public Iterator<PeriodUnit> iterator() {
        return this.unitAmountMap.keySet().iterator();
    }

    public boolean contains(PeriodUnit periodUnit) {
        return this.unitAmountMap.containsKey(periodUnit);
    }

    public long get(PeriodUnit periodUnit) {
        PeriodFields.checkNotNull(periodUnit, "PeriodUnit must not be null");
        Long l = this.unitAmountMap.get(periodUnit);
        if (l == null) {
            throw new CalendricalException("No amount for unit: " + periodUnit);
        }
        return l;
    }

    public int getInt(PeriodUnit periodUnit) {
        return MathUtils.safeToInt(this.get(periodUnit));
    }

    public long get(PeriodUnit periodUnit, long l) {
        PeriodFields.checkNotNull(periodUnit, "PeriodUnit must not be null");
        Long l2 = this.unitAmountMap.get(periodUnit);
        return l2 == null ? l : l2;
    }

    public int getInt(PeriodUnit periodUnit, int n) {
        return MathUtils.safeToInt(this.get(periodUnit, n));
    }

    public Long getQuiet(PeriodUnit periodUnit) {
        return periodUnit == null ? null : this.unitAmountMap.get(periodUnit);
    }

    public PeriodFields withZeroesRemoved() {
        if (this.isZero()) {
            return ZERO;
        }
        TreeMap<PeriodUnit, Long> treeMap = this.clonedMap();
        treeMap.values().removeAll(Collections.singleton(0L));
        return PeriodFields.create(treeMap);
    }

    public PeriodFields with(long l, PeriodUnit periodUnit) {
        Long l2 = this.getQuiet(periodUnit);
        if (l2 != null && l2 == l) {
            return this;
        }
        TreeMap<PeriodUnit, Long> treeMap = this.clonedMap();
        treeMap.put(periodUnit, l);
        return PeriodFields.create(treeMap);
    }

    public PeriodFields with(PeriodFields periodFields) {
        if (this == ZERO) {
            return periodFields;
        }
        if (periodFields == ZERO) {
            return this;
        }
        TreeMap<PeriodUnit, Long> treeMap = this.clonedMap();
        treeMap.putAll(periodFields.unitAmountMap);
        return PeriodFields.create(treeMap);
    }

    public PeriodFields withUnitRemoved(PeriodUnit periodUnit) {
        PeriodFields.checkNotNull(periodUnit, "PeriodUnit must not be null");
        if (!this.unitAmountMap.containsKey(periodUnit)) {
            return this;
        }
        TreeMap<PeriodUnit, Long> treeMap = this.clonedMap();
        treeMap.remove(periodUnit);
        return PeriodFields.create(treeMap);
    }

    public PeriodFields plus(PeriodFields periodFields) {
        PeriodFields.checkNotNull(periodFields, "PeriodFields must not be null");
        if (this == ZERO) {
            return periodFields;
        }
        if (periodFields.isZero()) {
            return this;
        }
        TreeMap<PeriodUnit, Long> treeMap = this.clonedMap();
        for (PeriodUnit periodUnit : periodFields) {
            long l = periodFields.unitAmountMap.get(periodUnit);
            long l2 = this.get(periodUnit, 0L);
            treeMap.put(periodUnit, MathUtils.safeAdd(l2, l));
        }
        return PeriodFields.create(treeMap);
    }

    public PeriodFields minus(PeriodFields periodFields) {
        PeriodFields.checkNotNull(periodFields, "PeriodFields must not be null");
        if (this == ZERO) {
            return periodFields;
        }
        if (periodFields.isZero()) {
            return this;
        }
        TreeMap<PeriodUnit, Long> treeMap = this.clonedMap();
        for (PeriodUnit periodUnit : periodFields) {
            long l = periodFields.unitAmountMap.get(periodUnit);
            long l2 = this.get(periodUnit, 0L);
            treeMap.put(periodUnit, MathUtils.safeSubtract(l2, l));
        }
        return PeriodFields.create(treeMap);
    }

    public PeriodFields multipliedBy(int n) {
        if (n == 1 || this.isZero()) {
            return this;
        }
        TreeMap<PeriodUnit, Long> treeMap = this.clonedMap();
        for (PeriodUnit periodUnit : this) {
            long l = this.unitAmountMap.get(periodUnit);
            treeMap.put(periodUnit, MathUtils.safeMultiply(l, n));
        }
        return PeriodFields.create(treeMap);
    }

    public PeriodFields dividedBy(int n) {
        if (n == 0) {
            throw new ArithmeticException("Cannot divide by zero");
        }
        if (n == 1 || this.isZero()) {
            return this;
        }
        TreeMap<PeriodUnit, Long> treeMap = this.clonedMap();
        for (PeriodUnit periodUnit : this) {
            long l = this.unitAmountMap.get(periodUnit);
            treeMap.put(periodUnit, l / (long)n);
        }
        return PeriodFields.create(treeMap);
    }

    public PeriodFields negated() {
        return this.multipliedBy(-1);
    }

    private TreeMap<PeriodUnit, Long> clonedMap() {
        return (TreeMap)this.unitAmountMap.clone();
    }

    public SortedMap<PeriodUnit, Long> toUnitAmountMap() {
        return this.clonedMap();
    }

    @Override
    public Period toPeriod() {
        if (this.isZero()) {
            return Period.ZERO;
        }
        TreeMap<PeriodUnit, Long> treeMap = this.clonedMap();
        Long l = (Long)treeMap.remove(PeriodUnits.YEARS);
        Long l2 = (Long)treeMap.remove(PeriodUnits.MONTHS);
        Long l3 = (Long)treeMap.remove(PeriodUnits.DAYS);
        Long l4 = (Long)treeMap.remove(PeriodUnits.HOURS);
        Long l5 = (Long)treeMap.remove(PeriodUnits.MINUTES);
        Long l6 = (Long)treeMap.remove(PeriodUnits.SECONDS);
        Long l7 = (Long)treeMap.remove(PeriodUnits.NANOS);
        if (treeMap.size() > 0) {
            throw new CalendarConversionException("Unable to convert to a Period as the following fields are incompatible: " + treeMap.keySet());
        }
        return Period.period(l == null ? 0 : MathUtils.safeToInt(l), l2 == null ? 0 : MathUtils.safeToInt(l2), l3 == null ? 0 : MathUtils.safeToInt(l3), l4 == null ? 0 : MathUtils.safeToInt(l4), l5 == null ? 0 : MathUtils.safeToInt(l5), l6 == null ? 0 : MathUtils.safeToInt(l6), l7 == null ? 0L : l7);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof PeriodFields) {
            PeriodFields periodFields = (PeriodFields)object;
            return this.unitAmountMap.equals(periodFields.unitAmountMap);
        }
        return false;
    }

    public int hashCode() {
        return this.unitAmountMap.hashCode();
    }

    public String toString() {
        return this.unitAmountMap.toString();
    }
}

