/*
 * Decompiled with CFR 0.152.
 */
package javax.time.period;

import javax.time.calendar.format.CalendricalParseException;
import javax.time.period.Period;

class PeriodParser {
    private static final PeriodParser INSTANCE = new PeriodParser();
    private static final String TOKEN_SEQUENCE = "PYMDTHMS";
    private static final String ZERO = "PT0S";

    private PeriodParser() {
    }

    static PeriodParser getInstance() {
        return INSTANCE;
    }

    Period parse(String string) {
        String string2 = string.toUpperCase().replace(',', '.');
        if (ZERO.equals(string2)) {
            return Period.ZERO;
        }
        if (string2.length() < 3 || string2.charAt(0) != 'P') {
            throw new CalendricalParseException("Period could not be parsed: " + string, string, 0);
        }
        this.validateCharactersAndOrdering(string2, string);
        ParseValues parseValues = new ParseValues(string);
        String[] stringArray = string2.substring(1).split("T");
        switch (stringArray.length) {
            case 2: {
                this.parseDate(parseValues, stringArray[0], 1);
                this.parseTime(parseValues, stringArray[1], stringArray[0].length() + 2);
                break;
            }
            case 1: {
                this.parseDate(parseValues, stringArray[0], 1);
            }
        }
        return parseValues.toPeriod();
    }

    private void parseDate(ParseValues parseValues, String string, int n) {
        parseValues.index = 0;
        while (parseValues.index < string.length()) {
            String string2 = this.parseNumber(parseValues, string);
            if (parseValues.index >= string.length()) continue;
            char c = string.charAt(parseValues.index);
            switch (c) {
                case 'Y': {
                    parseValues.years = this.parseInt(parseValues, string2, n);
                    break;
                }
                case 'M': {
                    parseValues.months = this.parseInt(parseValues, string2, n);
                    break;
                }
                case 'D': {
                    parseValues.days = this.parseInt(parseValues, string2, n);
                    break;
                }
                default: {
                    throw new CalendricalParseException("Period could not be parsed, unrecognized letter '" + c + ": " + parseValues.text, parseValues.text, n + parseValues.index);
                }
            }
            parseValues.index++;
        }
    }

    private void parseTime(ParseValues parseValues, String string, int n) {
        parseValues.index = 0;
        string = this.prepareTime(parseValues, string, n);
        while (parseValues.index < string.length()) {
            String string2 = this.parseNumber(parseValues, string);
            if (parseValues.index >= string.length()) continue;
            char c = string.charAt(parseValues.index);
            switch (c) {
                case 'H': {
                    parseValues.hours = this.parseInt(parseValues, string2, n);
                    break;
                }
                case 'M': {
                    parseValues.minutes = this.parseInt(parseValues, string2, n);
                    break;
                }
                case 'S': {
                    parseValues.seconds = this.parseInt(parseValues, string2, n);
                    break;
                }
                case 'N': {
                    parseValues.nanos = this.parseNanos(parseValues, string2, n);
                    break;
                }
                default: {
                    throw new CalendricalParseException("Period could not be parsed, unrecognized letter '" + c + "': " + parseValues.text, parseValues.text, n + parseValues.index);
                }
            }
            parseValues.index++;
        }
    }

    private long parseNanos(ParseValues parseValues, String string, int n) {
        if (string.length() > 9) {
            throw new CalendricalParseException("Period could not be parsed, nanosecond range exceeded: " + parseValues.text, parseValues.text, n + parseValues.index - string.length());
        }
        return Long.parseLong((string + "000000000").substring(0, 9));
    }

    private String prepareTime(ParseValues parseValues, String string, int n) {
        if (string.contains(".")) {
            int n2 = string.indexOf(".") + 1;
            if (Character.isDigit(string.charAt(n2))) {
                ++n2;
            } else {
                throw new CalendricalParseException("Period could not be parsed, invalid decimal number: " + parseValues.text, parseValues.text, n + parseValues.index);
            }
            while (n2 < string.length()) {
                char c = string.charAt(n2);
                if (Character.isDigit(c) || c == 'S') {
                    ++n2;
                    continue;
                }
                throw new CalendricalParseException("Period could not be parsed, invalid decimal number: " + parseValues.text, parseValues.text, n + parseValues.index);
            }
            if ((string = string.replace('S', 'N').replace('.', 'S')).contains("-0S")) {
                parseValues.negativeSecs = true;
                string = string.replace("-0S", "0S");
            }
        }
        return string;
    }

    private int parseInt(ParseValues parseValues, String string, int n) {
        try {
            int n2 = Integer.parseInt(string);
            if (string.charAt(0) == '-' && n2 == 0) {
                throw new CalendricalParseException("Period could not be parsed, invalid number '" + string + "': " + parseValues.text, parseValues.text, n + parseValues.index - string.length());
            }
            return n2;
        }
        catch (NumberFormatException numberFormatException) {
            throw new CalendricalParseException("Period could not be parsed, invalid number '" + string + "': " + parseValues.text, parseValues.text, n + parseValues.index - string.length());
        }
    }

    private String parseNumber(ParseValues parseValues, String string) {
        char c;
        int n = parseValues.index;
        while (parseValues.index < string.length() && ((c = string.charAt(parseValues.index)) >= '0' && c <= '9' || c == '-')) {
            parseValues.index++;
        }
        return string.substring(n, parseValues.index);
    }

    private void validateCharactersAndOrdering(String string, String string2) {
        char[] cArray = string.toCharArray();
        int n = 0;
        boolean bl = false;
        for (int i = 0; i < cArray.length; ++i) {
            if (n >= TOKEN_SEQUENCE.length()) {
                throw new CalendricalParseException("Period could not be parsed, characters after last 'S': " + string2, string2, i);
            }
            char c = cArray[i];
            if ((c < '0' || c > '9') && c != '-' && c != '.') {
                if ((n = TOKEN_SEQUENCE.indexOf(c, n)) < 0) {
                    throw new CalendricalParseException("Period could not be parsed, invalid character '" + c + "': " + string2, string2, i);
                }
                ++n;
                bl = true;
                continue;
            }
            bl = false;
        }
        if (!bl) {
            throw new CalendricalParseException("Period could not be parsed, invalid last character: " + string2, string2, string.length() - 1);
        }
    }

    private class ParseValues {
        private int years;
        private int months;
        private int days;
        private int hours;
        private int minutes;
        private int seconds;
        private long nanos;
        private boolean negativeSecs;
        private int index;
        private String text;

        ParseValues(String string) {
            this.text = string;
        }

        Period toPeriod() {
            return Period.period(this.years, this.months, this.days, this.hours, this.minutes, this.seconds, this.negativeSecs || this.seconds < 0 ? -this.nanos : this.nanos);
        }
    }
}

