/*
 * Decompiled with CFR 0.152.
 */
package javax.time.period.field;

import java.io.Serializable;
import javax.time.period.PeriodUnit;
import javax.time.period.PeriodUnits;
import javax.time.period.field.PeriodField;

public final class Days
extends PeriodField
implements Comparable<Days>,
Serializable {
    public static final Days ZERO = new Days(0);
    private static final long serialVersionUID = 1L;
    private final int days;

    public static Days days(int n) {
        if (n == 0) {
            return ZERO;
        }
        return new Days(n);
    }

    private Days(int n) {
        this.days = n;
    }

    private Object readResolve() {
        return Days.days(this.days);
    }

    @Override
    public int getAmount() {
        return this.days;
    }

    @Override
    public Days withAmount(int n) {
        return Days.days(n);
    }

    @Override
    public PeriodUnit getUnit() {
        return PeriodUnits.DAYS;
    }

    @Override
    public Days plus(int n) {
        return (Days)super.plus(n);
    }

    public Days plus(Days days) {
        return this.plus(days.getAmount());
    }

    @Override
    public Days minus(int n) {
        return (Days)super.minus(n);
    }

    public Days minus(Days days) {
        return this.minus(days.getAmount());
    }

    @Override
    public Days multipliedBy(int n) {
        return (Days)super.multipliedBy(n);
    }

    @Override
    public Days dividedBy(int n) {
        return (Days)super.dividedBy(n);
    }

    @Override
    public Days negated() {
        return (Days)super.negated();
    }

    @Override
    public int compareTo(Days days) {
        int n = this.days;
        int n2 = days.days;
        return n < n2 ? -1 : (n == n2 ? 0 : 1);
    }

    public boolean isGreaterThan(Days days) {
        return this.compareTo(days) > 0;
    }

    public boolean isLessThan(Days days) {
        return this.compareTo(days) < 0;
    }

    @Override
    public String toString() {
        return "P" + this.days + "D";
    }
}

