/*
 * Decompiled with CFR 0.152.
 */
package javax.time.period.field;

import java.io.Serializable;
import javax.time.period.PeriodUnit;
import javax.time.period.PeriodUnits;
import javax.time.period.field.PeriodField;

public final class Minutes
extends PeriodField
implements Comparable<Minutes>,
Serializable {
    public static final Minutes ZERO = new Minutes(0);
    private static final long serialVersionUID = 1L;
    private final int minutes;

    public static Minutes minutes(int n) {
        if (n == 0) {
            return ZERO;
        }
        return new Minutes(n);
    }

    private Minutes(int n) {
        this.minutes = n;
    }

    private Object readResolve() {
        return Minutes.minutes(this.minutes);
    }

    @Override
    public int getAmount() {
        return this.minutes;
    }

    @Override
    public Minutes withAmount(int n) {
        return Minutes.minutes(n);
    }

    @Override
    public PeriodUnit getUnit() {
        return PeriodUnits.MINUTES;
    }

    @Override
    public Minutes plus(int n) {
        return (Minutes)super.plus(n);
    }

    public Minutes plus(Minutes minutes) {
        return this.plus(minutes.getAmount());
    }

    @Override
    public Minutes minus(int n) {
        return (Minutes)super.minus(n);
    }

    public Minutes minus(Minutes minutes) {
        return this.minus(minutes.getAmount());
    }

    @Override
    public Minutes multipliedBy(int n) {
        return (Minutes)super.multipliedBy(n);
    }

    @Override
    public Minutes dividedBy(int n) {
        return (Minutes)super.dividedBy(n);
    }

    @Override
    public Minutes negated() {
        return (Minutes)super.negated();
    }

    @Override
    public int compareTo(Minutes minutes) {
        int n = this.minutes;
        int n2 = minutes.minutes;
        return n < n2 ? -1 : (n == n2 ? 0 : 1);
    }

    public boolean isGreaterThan(Minutes minutes) {
        return this.compareTo(minutes) > 0;
    }

    public boolean isLessThan(Minutes minutes) {
        return this.compareTo(minutes) < 0;
    }

    @Override
    public String toString() {
        return "PT" + this.minutes + "M";
    }
}

