/*
 * Decompiled with CFR 0.152.
 */
package javax.time.period.field;

import java.io.Serializable;
import javax.time.period.PeriodUnit;
import javax.time.period.PeriodUnits;
import javax.time.period.field.PeriodField;

public final class Months
extends PeriodField
implements Comparable<Months>,
Serializable {
    public static final Months ZERO = new Months(0);
    private static final long serialVersionUID = 1L;
    private final int months;

    public static Months months(int n) {
        if (n == 0) {
            return ZERO;
        }
        return new Months(n);
    }

    private Months(int n) {
        this.months = n;
    }

    private Object readResolve() {
        return Months.months(this.months);
    }

    @Override
    public int getAmount() {
        return this.months;
    }

    @Override
    public Months withAmount(int n) {
        return Months.months(n);
    }

    @Override
    public PeriodUnit getUnit() {
        return PeriodUnits.MONTHS;
    }

    @Override
    public Months plus(int n) {
        return (Months)super.plus(n);
    }

    public Months plus(Months months) {
        return this.plus(months.getAmount());
    }

    @Override
    public Months minus(int n) {
        return (Months)super.minus(n);
    }

    public Months minus(Months months) {
        return this.minus(months.getAmount());
    }

    @Override
    public Months multipliedBy(int n) {
        return (Months)super.multipliedBy(n);
    }

    @Override
    public Months dividedBy(int n) {
        return (Months)super.dividedBy(n);
    }

    @Override
    public Months negated() {
        return (Months)super.negated();
    }

    @Override
    public int compareTo(Months months) {
        int n = this.months;
        int n2 = months.months;
        return n < n2 ? -1 : (n == n2 ? 0 : 1);
    }

    public boolean isGreaterThan(Months months) {
        return this.compareTo(months) > 0;
    }

    public boolean isLessThan(Months months) {
        return this.compareTo(months) < 0;
    }

    @Override
    public String toString() {
        return "P" + this.months + "M";
    }
}

