/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jsfunit.facade;

import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.SubmitButton;
import com.meterware.httpunit.WebConversation;
import com.meterware.httpunit.WebForm;
import com.meterware.httpunit.WebLink;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import java.io.IOException;
import java.net.MalformedURLException;
import org.jboss.jsfunit.facade.ClientIDs;
import org.jboss.jsfunit.facade.ComponentIDNotFoundException;
import org.jboss.jsfunit.facade.FormNotFoundException;
import org.jboss.jsfunit.framework.WebConversationFactory;
import org.xml.sax.SAXException;

public class ClientFacade {
    private WebConversation webConversation = WebConversationFactory.makeWebConversation();
    private WebResponse webResponse;
    private ClientIDs clientIDs;

    public ClientFacade(String initialPage) throws MalformedURLException, IOException, SAXException {
        GetMethodWebRequest req = new GetMethodWebRequest(WebConversationFactory.getWARURL() + initialPage);
        this.webResponse = this.webConversation.getResponse((WebRequest)req);
        this.clientIDs = new ClientIDs();
    }

    public ClientFacade(String initialPage, String username, String password) throws MalformedURLException, IOException, SAXException {
        GetMethodWebRequest req = new GetMethodWebRequest(WebConversationFactory.getWARURL() + initialPage);
        this.webConversation.setAuthorization(username, password);
        this.webResponse = this.webConversation.getResponse((WebRequest)req);
        this.clientIDs = new ClientIDs();
    }

    protected ClientIDs getClientIDs() {
        return this.clientIDs;
    }

    public WebResponse getWebResponse() {
        return this.webResponse;
    }

    public WebForm getForm(String componentID) throws SAXException {
        String clientID = this.clientIDs.findClientID(componentID);
        WebForm[] forms = this.getWebResponse().getForms();
        if (forms.length == 0) {
            throw new FormNotFoundException(componentID);
        }
        for (int i = 0; i < forms.length; ++i) {
            if (!clientID.startsWith(forms[i].getID())) continue;
            return forms[i];
        }
        throw new FormNotFoundException(componentID);
    }

    public void setParameter(String componentID, String ... value) throws SAXException {
        String clientID = this.clientIDs.findClientID(componentID);
        this.getForm(clientID).setParameter(clientID, value);
    }

    public void setCheckbox(String componentID, boolean state) throws SAXException {
        String clientID = this.clientIDs.findClientID(componentID);
        this.getForm(clientID).setCheckbox(clientID, state);
    }

    public void submit() throws SAXException, IOException {
        WebForm[] forms = this.getWebResponse().getForms();
        if (forms.length != 1) {
            throw new IllegalStateException("For this method, page must contain only one form.  Use another version of the submit() method.");
        }
        this.webResponse = forms[0].submit();
        this.clientIDs = new ClientIDs();
    }

    public void submit(String componentID) throws SAXException, IOException {
        String clientID = this.clientIDs.findClientID(componentID);
        WebForm form = this.getForm(clientID);
        SubmitButton button = form.getSubmitButtonWithID(clientID);
        this.webResponse = form.submit(button);
        this.clientIDs = new ClientIDs();
    }

    public void clickLink(String componentID) throws SAXException, IOException {
        String clientID = this.clientIDs.findClientID(componentID);
        WebLink link = this.webResponse.getLinkWithID(clientID);
        if (link == null) {
            throw new ComponentIDNotFoundException(componentID);
        }
        this.webResponse = link.click();
        this.clientIDs = new ClientIDs();
    }

    public void ajaxRequest(WebRequest request) throws SAXException, IOException {
        this.webResponse = this.webConversation.getResponse(request);
        String url = this.webResponse.getURL().toString();
        this.webResponse = this.webConversation.getResponse((WebRequest)new GetMethodWebRequest(url));
        this.clientIDs = new ClientIDs();
    }
}

