/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jsfunit.facade;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import org.jboss.jsfunit.facade.ComponentIDNotFoundException;
import org.jboss.jsfunit.facade.DuplicateClientIDException;
import org.jboss.jsfunit.framework.FacesContextBridge;

public class ClientIDs {
    private List<String> allClientIDs = new ArrayList<String>();
    private Map<String, UIComponent> allComponents = new HashMap<String, UIComponent>();

    public ClientIDs() {
        FacesContext facesContext = FacesContextBridge.getCurrentInstance();
        UIViewRoot component = facesContext.getViewRoot();
        this.addAllIDs((UIComponent)component, facesContext);
    }

    private void addAllIDs(UIComponent component, FacesContext facesContext) {
        if (component == null) {
            return;
        }
        this.addClientID(component, facesContext);
        if (component instanceof UIData) {
            this.addUIData((UIData)component, facesContext);
            return;
        }
        Iterator facetsAndChildren = component.getFacetsAndChildren();
        while (facetsAndChildren.hasNext()) {
            this.addAllIDs((UIComponent)facetsAndChildren.next(), facesContext);
        }
    }

    private void addUIData(UIData component, FacesContext facesContext) {
        for (int i = 0; i < component.getRowCount(); ++i) {
            component.setRowIndex(i);
            Iterator facetsAndChildren = component.getFacetsAndChildren();
            while (facetsAndChildren.hasNext()) {
                this.addAllIDs((UIComponent)facetsAndChildren.next(), facesContext);
            }
        }
        component.setRowIndex(-1);
    }

    private void addClientID(UIComponent component, FacesContext facesContext) {
        if (component instanceof UIViewRoot) {
            return;
        }
        String clientId = component.getClientId(facesContext);
        if (clientId == null) {
            return;
        }
        this.allClientIDs.add(clientId);
        this.allComponents.put(clientId, component);
    }

    public String findClientID(String suffix) {
        if (suffix == null) {
            throw new NullPointerException();
        }
        ArrayList<String> matches = new ArrayList<String>();
        for (String id : this.allClientIDs) {
            if (!id.endsWith(suffix)) continue;
            matches.add(id);
        }
        if (matches.size() == 1) {
            return (String)matches.get(0);
        }
        if (matches.isEmpty()) {
            throw new ComponentIDNotFoundException(suffix);
        }
        throw new DuplicateClientIDException(suffix, matches);
    }

    public UIComponent findComponent(String suffix) {
        return this.allComponents.get(this.findClientID(suffix));
    }
}

