/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jsfunit.framework;

import com.meterware.httpunit.HttpUnitOptions;
import com.meterware.httpunit.WebConversation;
import com.meterware.httpunit.parsing.HTMLParserFactory;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class WebConversationFactory {
    public static String JSF_UNIT_CONVERSATION_FLAG = WebConversationFactory.class.getName() + ".testing_flag";
    private static ThreadLocal tlsession = new ThreadLocal(){

        protected Object initialValue() {
            return null;
        }
    };
    private static ThreadLocal warURL = new ThreadLocal(){

        protected Object initialValue() {
            return null;
        }
    };

    public static void setThreadLocals(HttpServletRequest req) {
        tlsession.set(req.getSession());
        warURL.set(WebConversationFactory.makeWARURL(req));
    }

    protected static HttpSession getSessionFromThreadLocal() {
        return (HttpSession)tlsession.get();
    }

    private static String makeWARURL(HttpServletRequest req) {
        return req.getScheme() + "://" + req.getServerName() + ":" + req.getServerPort() + req.getContextPath();
    }

    public static void removeThreadLocals() {
        tlsession.remove();
        warURL.remove();
    }

    private WebConversationFactory() {
    }

    public static WebConversation makeWebConversation() {
        HTMLParserFactory.useJTidyParser();
        HttpUnitOptions.setScriptingEnabled((boolean)false);
        WebConversation wc = new WebConversation();
        HttpSession session = WebConversationFactory.getSessionFromThreadLocal();
        if (session == null) {
            throw new IllegalStateException("Can not find HttpSession.  Perhaps JSFUnitFilter has not run?");
        }
        WebConversationFactory.clearSession(session);
        wc.putCookie("JSESSIONID", session.getId());
        wc.putCookie(JSF_UNIT_CONVERSATION_FLAG, JSF_UNIT_CONVERSATION_FLAG);
        return wc;
    }

    protected static void clearSession(HttpSession session) {
        Enumeration e = session.getAttributeNames();
        while (e.hasMoreElements()) {
            session.removeAttribute((String)e.nextElement());
        }
    }

    public static String getWARURL() {
        return (String)warURL.get();
    }
}

