/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting;

import java.util.Map;
import org.jboss.remoting.ConnectionNotifier;
import org.jboss.util.TimerQueue;
import org.jboss.util.TimerTask;

public class Lease {
    public static long TIMER_DELAY = 5000L;
    private ConnectionNotifier notifier = null;
    private String clientSessionId = null;
    private long leasePeriod = -1L;
    private String locatorURL = null;
    private Map requestPayload = null;
    private TimerQueue leaseTimer = null;
    private LeaseTimerTask leaseTimerTask = null;
    private long leaseWindow = -1L;
    private long pingStart = -1L;
    private boolean leaseUpdated = false;

    public Lease(String clientSessionId, long leasePeriod, String locatorurl, Map requestPayload, ConnectionNotifier notifier) {
        this.clientSessionId = clientSessionId;
        this.leasePeriod = leasePeriod;
        this.notifier = notifier;
        this.locatorURL = locatorurl;
        this.requestPayload = requestPayload;
        this.leaseWindow = leasePeriod;
        this.leaseTimer = new TimerQueue("Lease-" + clientSessionId);
    }

    public void startLease() {
        this.leaseTimer.start();
        this.leaseTimerTask = new LeaseTimerTask();
        this.leaseTimer.schedule((TimerTask)this.leaseTimerTask, this.leasePeriod + TIMER_DELAY);
        this.pingStart = System.currentTimeMillis();
    }

    public void updateLease(long leasePeriod) {
        this.leaseUpdated = true;
        if (leasePeriod != this.leasePeriod) {
            this.leasePeriod = leasePeriod;
            this.leaseWindow = leasePeriod;
            this.stopLease();
            this.startLease();
        } else {
            long pingDuration = System.currentTimeMillis() - this.pingStart;
            if (pingDuration > this.leaseWindow / 2L) {
                this.leaseWindow = pingDuration * 2L;
            }
            this.leaseTimer.schedule((TimerTask)this.leaseTimerTask, this.leaseWindow);
            this.pingStart = System.currentTimeMillis();
        }
    }

    public void terminateLease(long leasePeriod) {
        this.stopLease();
        this.notifier.connectionTerminated(this.locatorURL, this.clientSessionId, this.requestPayload);
    }

    private void stopLease() {
        this.leaseTimerTask.running = false;
        this.leaseTimer.stop();
    }

    private class LeaseTimerTask
    extends TimerTask {
        protected boolean running = true;

        private LeaseTimerTask() {
        }

        public void execute() {
            if (this.running) {
                if (Lease.this.leaseUpdated) {
                    Lease.this.leaseUpdated = false;
                    Lease.this.leaseTimer.schedule((TimerTask)this, Lease.this.leaseWindow);
                } else {
                    Lease.this.stopLease();
                    Lease.this.notifier.connectionLost(Lease.this.locatorURL, Lease.this.clientSessionId, Lease.this.requestPayload);
                }
            }
        }
    }
}

