/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.multiplex;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.jboss.logging.Logger;
import org.jboss.remoting.transport.multiplex.MultiplexingManager;
import org.jboss.remoting.transport.multiplex.SocketId;
import org.jboss.remoting.transport.multiplex.utility.StoppableThread;

public class OutputMultiplexor {
    protected static final Logger log = Logger.getLogger((Class)(class$org$jboss$remoting$transport$multiplex$OutputMultiplexor == null ? (class$org$jboss$remoting$transport$multiplex$OutputMultiplexor = OutputMultiplexor.class$("org.jboss.remoting.transport.multiplex.OutputMultiplexor")) : class$org$jboss$remoting$transport$multiplex$OutputMultiplexor));
    protected static final int MARKER = 255;
    protected static final int MAX_CHUNK_LENGTH = 2048;
    static final int BRACKETS_ALL = -1;
    static final int BRACKETS_NONE = -2;
    private List writeQueue = Collections.synchronizedList(new LinkedList());
    private SocketId previousDestinationId = SocketId.INITIAL_OUTPUT_SOCKET_ID;
    private MultiplexingManager manager;
    private OutputStream os;
    private Message pendingMessage;
    private byte[] outputBytes = new byte[4096];
    private boolean tracing;
    static /* synthetic */ Class class$org$jboss$remoting$transport$multiplex$OutputMultiplexor;
    static /* synthetic */ Class class$org$jboss$remoting$transport$multiplex$OutputMultiplexor$OutputThread;

    protected OutputMultiplexor(MultiplexingManager manager, Socket socket) throws IOException {
        this.manager = manager;
        this.os = socket.getOutputStream();
        this.tracing = log.isTraceEnabled();
    }

    public OutputThread getAnOutputThread() {
        return new OutputThread();
    }

    public void write(SocketId socketId, byte[] content) throws IOException {
        this.write(socketId, content, -2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void write(SocketId socketId, byte[] content, int brackets) throws IOException {
        Object messageEnd;
        if (this.tracing) {
            messageEnd = "";
            if (content.length > 0) {
                messageEnd = ": [" + (0xFF & content[0]) + "]";
            }
            log.trace((Object)("OutputMultiplexor.write(): queueing " + content.length + " bytes for socket " + socketId.getPort() + (String)messageEnd));
        }
        messageEnd = this.writeQueue;
        synchronized (messageEnd) {
            Message message;
            if (!this.writeQueue.isEmpty() && (message = (Message)this.writeQueue.get(this.writeQueue.size() - 1)).getDestination().equals(socketId) && message.hasCompatibleBrackets(brackets)) {
                message.addContent(content);
                return;
            }
            this.writeQueue.add(new Message(socketId, content, brackets));
            this.writeQueue.notifyAll();
        }
        if (this.tracing) {
            messageEnd = "";
            if (content.length > 0) {
                messageEnd = ": [" + (0xFF & content[0]) + "]";
            }
            log.trace((Object)("OutputMultiplexor.write(): queued " + content.length + " bytes for socket " + socketId.getPort() + (String)messageEnd));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Message {
        private SocketId socketId;
        private ByteArrayOutputStream baos = new ByteArrayOutputStream();
        private int start;
        private int length;
        private int brackets;

        public Message(SocketId socketId, byte[] content, int brackets) throws IOException {
            this.socketId = socketId;
            this.brackets = brackets;
            this.baos.write(content);
            this.length = content.length;
        }

        public SocketId getDestination() {
            return this.socketId;
        }

        public byte[] getContent() {
            return this.baos.toByteArray();
        }

        public void addContent(byte[] bytes) throws IOException {
            this.baos.write(bytes);
            this.length += bytes.length;
        }

        public void addContent(byte[] bytes, int start, int length) {
            this.baos.write(bytes, start, length);
            this.length += length;
        }

        public int getStart() {
            return this.start;
        }

        public int getLength() {
            return this.length;
        }

        public int getBrackets() {
            return this.brackets;
        }

        public void markUsed(int used) {
            this.length -= used;
            if (this.length <= 0) {
                this.start = 0;
                this.length = 0;
                this.baos.reset();
            } else {
                this.start += used;
            }
        }

        public boolean brackets(int b) {
            if (this.brackets == -1) {
                return true;
            }
            if (this.brackets == -2) {
                return false;
            }
            return this.brackets == b;
        }

        public boolean hasCompatibleBrackets(int b) {
            if (this.brackets == -1 || b == -2) {
                return true;
            }
            return this.brackets == b;
        }
    }

    class OutputThread
    extends StoppableThread {
        private final Logger log = Logger.getLogger((Class)(class$org$jboss$remoting$transport$multiplex$OutputMultiplexor$OutputThread == null ? (class$org$jboss$remoting$transport$multiplex$OutputMultiplexor$OutputThread = OutputMultiplexor.class$("org.jboss.remoting.transport.multiplex.OutputMultiplexor$OutputThread")) : class$org$jboss$remoting$transport$multiplex$OutputMultiplexor$OutputThread));
        private int dataOutCount = 0;
        private boolean socketIsOpen = true;
        private boolean threadTracing = this.log.isTraceEnabled();

        public void shutdown() {
            super.shutdown();
            this.interrupt();
        }

        protected void doInit() {
            this.log.debug((Object)"output thread starting");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void doRun() {
            while (this.socketIsOpen && (!OutputMultiplexor.this.writeQueue.isEmpty() || this.isRunning())) {
                try {
                    List list = OutputMultiplexor.this.writeQueue;
                    synchronized (list) {
                        if (OutputMultiplexor.this.writeQueue.isEmpty()) {
                            OutputMultiplexor.this.writeQueue.wait();
                        }
                        OutputMultiplexor.this.pendingMessage = (Message)OutputMultiplexor.this.writeQueue.remove(0);
                    }
                    SocketId remoteSocketId = OutputMultiplexor.this.pendingMessage.getDestination();
                    int start = OutputMultiplexor.this.pendingMessage.getStart();
                    int length = Math.min(OutputMultiplexor.this.pendingMessage.getLength(), 2048);
                    this.encode(remoteSocketId, OutputMultiplexor.this.pendingMessage.getContent(), start, length, OutputMultiplexor.this.os);
                    if (this.threadTracing) {
                        this.log.trace((Object)("output thread wrote: " + length + " bytes to socket " + remoteSocketId.getPort()));
                    }
                    this.dataOutCount += length;
                    if (length < OutputMultiplexor.this.pendingMessage.getLength()) {
                        OutputMultiplexor.this.pendingMessage.markUsed(length);
                        List list2 = OutputMultiplexor.this.writeQueue;
                        synchronized (list2) {
                            if (!OutputMultiplexor.this.writeQueue.isEmpty()) {
                                ListIterator<Message> it = OutputMultiplexor.this.writeQueue.listIterator();
                                boolean processed = false;
                                int remotePort = remoteSocketId.getPort();
                                int brackets = OutputMultiplexor.this.pendingMessage.getBrackets();
                                while (it.hasNext()) {
                                    Message message = (Message)it.next();
                                    if (message.brackets(remotePort)) {
                                        it.previous();
                                        it.add(OutputMultiplexor.this.pendingMessage);
                                        processed = true;
                                        break;
                                    }
                                    if (!message.getDestination().equals(remoteSocketId) || -2 != message.getBrackets() && brackets != message.getBrackets()) continue;
                                    OutputMultiplexor.this.pendingMessage.addContent(message.getContent(), message.getStart(), message.getLength());
                                    it.set(OutputMultiplexor.this.pendingMessage);
                                    processed = true;
                                    break;
                                }
                                if (!processed) {
                                    OutputMultiplexor.this.writeQueue.add(OutputMultiplexor.this.pendingMessage);
                                }
                            } else {
                                OutputMultiplexor.this.writeQueue.add(OutputMultiplexor.this.pendingMessage);
                            }
                        }
                    }
                    OutputMultiplexor.this.pendingMessage = null;
                    if (!OutputThread.interrupted()) continue;
                    throw new InterruptedException();
                }
                catch (InterruptedException e) {
                    this.handleError("output thread: interrupted", e);
                }
                catch (SocketException e) {
                    this.handleError("output thread: socket exception", e);
                }
                catch (IOException e) {
                    this.handleError("output thread: i/o error", e);
                }
            }
            this.log.debug((Object)("output thread: socketIsConnected: " + this.socketIsOpen));
            this.log.debug((Object)("output thread: writeQueue.isEmpty(): " + OutputMultiplexor.this.writeQueue.isEmpty()));
            this.log.debug((Object)("output thread: running: " + this.running));
            this.log.debug((Object)("output thread: pendingMessage ==  " + OutputMultiplexor.this.pendingMessage));
        }

        protected void doShutDown() {
            this.log.debug((Object)("output thread: data bytes out: " + this.dataOutCount));
            this.log.debug((Object)"output thread shutting down");
            try {
                while (OutputMultiplexor.this.pendingMessage != null) {
                    this.log.debug((Object)"waiting for encode() to write final message");
                    Thread.sleep(1000L);
                }
            }
            catch (InterruptedException ignored) {
                this.log.debug((Object)ignored);
            }
        }

        protected void encode(SocketId destinationId, byte[] bytes, int start, int length, OutputStream os) throws IOException {
            if (this.threadTracing) {
                String messageEnd = "";
                if (length > 0) {
                    messageEnd = " [" + bytes[start] + "]: " + destinationId.getPort();
                }
                this.log.trace((Object)("encode(): writing " + length + " bytes" + messageEnd));
            }
            int position = 0;
            if (!destinationId.equals(OutputMultiplexor.this.previousDestinationId)) {
                if (this.threadTracing) {
                    this.log.trace((Object)"encode(): writing: MARKER");
                    byte[] byteArray = destinationId.toByteArray();
                    for (int i = 0; i < byteArray.length; ++i) {
                        this.log.trace((Object)("encode(): writing: " + byteArray[i]));
                    }
                    this.log.trace((Object)"encode(): writing: MARKER");
                }
                OutputMultiplexor.this.previousDestinationId = destinationId;
                ((OutputMultiplexor)OutputMultiplexor.this).outputBytes[0] = -1;
                int len = destinationId.toByteArray().length;
                System.arraycopy(destinationId.toByteArray(), 0, OutputMultiplexor.this.outputBytes, 1, len);
                position = len + 1;
                ((OutputMultiplexor)OutputMultiplexor.this).outputBytes[position++] = -1;
            }
            if (this.threadTracing) {
                this.log.trace((Object)("encode(): writing " + length + " bytes to socketId " + destinationId.getPort()));
            }
            for (int i = start; i < start + length; ++i) {
                if (this.threadTracing) {
                    this.log.info((Object)("" + bytes[i]));
                }
                ((OutputMultiplexor)OutputMultiplexor.this).outputBytes[position++] = bytes[i];
                if (bytes[i] != -1) continue;
                ((OutputMultiplexor)OutputMultiplexor.this).outputBytes[position++] = -1;
            }
            os.write(OutputMultiplexor.this.outputBytes, 0, position);
            os.flush();
            if (this.threadTracing) {
                String messageEnd = "";
                if (length > 0) {
                    messageEnd = ": [" + bytes[start] + "]";
                }
                this.log.trace((Object)("encode(): wrote " + length + " bytes" + messageEnd));
            }
        }

        protected void handleError(String message, Throwable e) {
            if (e instanceof SocketException) {
                this.socketIsOpen = false;
                super.shutdown();
                return;
            }
            if (this.log != null) {
                if (e instanceof InterruptedException || e instanceof IOException) {
                    if (OutputMultiplexor.this.tracing) {
                        this.log.trace((Object)message, e);
                    }
                } else {
                    this.log.debug((Object)message, e);
                }
            }
        }
    }
}

