/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jrunit;

import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.lang.reflect.Constructor;
import org.jboss.jrunit.controller.reporters.BenchmarkReporter;
import org.jboss.jrunit.data.Benchmark;

public class OfflineProcessor {
    static /* synthetic */ Class class$java$lang$String;

    public static void main(String[] args) {
        if (args.length < 2) {
            OfflineProcessor.usage();
        } else {
            new OfflineProcessor(args);
        }
    }

    private static void usage() {
        System.out.println("JRunit Offline Processor");
        System.out.println("------------------------");
        System.out.println("Purpose: to be able to gather results on one environment and process them (e.g., graphically) on another.");
        System.out.println();
        System.out.println("Usage: ");
        System.out.println("  java org.jboss.jrunit.OfflineProcessor <path to .dat file> <fully qualified name of processor> <processor patameter (optional)>");
        System.out.println();
        System.out.println("E.g.: ");
        System.out.println("  $ java -cp jrunit.jar org.jboss.jrunit.OfflineProcessor /tmp/myDownloadedResults.dat org.jboss.jrunit.controller.reporters.XrefReporter myparam");
        System.out.println();
    }

    private OfflineProcessor(String[] args) {
        try {
            String fname = args[0];
            String reporterClass = args[1];
            String param = args.length > 2 ? args[2] : null;
            Benchmark serializedData = this.getSerializedBenchmark(fname);
            BenchmarkReporter reporter = this.constructReporter(reporterClass, param);
            System.out.println();
            System.out.println("Processing data... ");
            reporter.writeBenchmarkResults(serializedData);
            System.out.println();
            System.out.println("Done!");
        }
        catch (Exception e) {
            System.out.println("Problems:");
            e.printStackTrace();
        }
    }

    private Benchmark getSerializedBenchmark(String fname) throws Exception {
        ObjectInputStream in = new ObjectInputStream(new FileInputStream(fname));
        Benchmark b = (Benchmark)in.readObject();
        in.close();
        return b;
    }

    private BenchmarkReporter constructReporter(String classname, String param) throws Exception {
        Class<?> reporterClass = this.getClass().getClassLoader().loadClass(classname);
        BenchmarkReporter reporter = null;
        if (param != null) {
            Constructor<?> ctor = reporterClass.getConstructor(class$java$lang$String == null ? (class$java$lang$String = OfflineProcessor.class$("java.lang.String")) : class$java$lang$String);
            reporter = (BenchmarkReporter)ctor.newInstance(param);
        } else {
            Constructor<?> ctor = reporterClass.getConstructor(new Class[0]);
            reporter = (BenchmarkReporter)ctor.newInstance(new Object[0]);
        }
        return reporter;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

