/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jrunit.communication;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jboss.jrunit.communication.MessageBusListener;
import org.jboss.jrunit.communication.RemoteMemberListener;
import org.jboss.jrunit.communication.message.RemoteTestMessage;
import org.jgroups.Address;
import org.jgroups.blocks.NotificationBus;

public class MessageBus
implements NotificationBus.Consumer {
    private List listeners = new ArrayList();
    private List members = new ArrayList();
    private NotificationBus bus = null;
    private RemoteMemberListener memberListener = null;
    private String busName = "BusDemo";
    private String props;
    private static Logger log = Logger.getLogger((Class)(class$org$jboss$jrunit$communication$MessageBus == null ? (class$org$jboss$jrunit$communication$MessageBus = MessageBus.class$("org.jboss.jrunit.communication.MessageBus")) : class$org$jboss$jrunit$communication$MessageBus));
    static /* synthetic */ Class class$org$jboss$jrunit$communication$MessageBus;

    public MessageBus() throws Exception {
        String bind_address = System.getProperty("jrunit.bind_addr", "127.0.0.1");
        System.out.println("jrunit using bind_address: " + bind_address);
        String mcast_address = System.getProperty("jrunit.mcast_addr", "228.15.2.3");
        System.out.println("jrunit using mcast_addr: " + mcast_address);
        String mcast_port = System.getProperty("jrunit.mcast_port", "45565");
        System.out.println("jrunit using mcast_port: " + mcast_port);
        String receiveOnAllInterfaces = System.getProperty("jrunit.receive_on_all_interfaces", "false");
        System.out.println("jrunit using receive_on_all_interfaces=" + receiveOnAllInterfaces);
        String sendOnAllInterfaces = System.getProperty("jrunit.send_on_all_interfaces", "false");
        System.out.println("jrunit using send_on_all_interfaces=" + sendOnAllInterfaces);
        String sendInterfaces = System.getProperty("jrunit.send_interfaces", "none");
        if (!sendInterfaces.equals("none")) {
            System.out.println("jrunit using send_interfaces=" + sendInterfaces);
        }
        this.props = "UDP(mcast_addr=" + mcast_address + ";" + "mcast_port=" + mcast_port + ";" + "bind_addr=" + bind_address + ";" + "tos=8;" + "ucast_recv_buf_size=80000;" + "ucast_send_buf_size=150000;" + "mcast_send_buf_size=150000;" + "mcast_recv_buf_size=80000;" + "loopback=false;" + "discard_incompatible_packets=true;" + "max_bundle_size=64000;" + "max_bundle_timeout=30;" + "use_incoming_packet_handler=true;" + "use_outgoing_packet_handler=false;" + "ip_ttl=2;" + "down_thread=false;" + "up_thread=false;" + "enable_bundling=false;" + "receive_on_all_interfaces=" + receiveOnAllInterfaces + ";" + "send_on_all_interfaces=" + sendOnAllInterfaces + ";" + (!sendInterfaces.equals("none") ? "send_interfaces=" + sendInterfaces : "") + ";" + "):" + "PING(timeout=2000;num_initial_members=3;up_thread=false;down_thread=false):" + "MERGE2(min_interval=10000;max_interval=20000;up_thread=false;down_thread=false):" + "FD_SOCK(up_thread=false;down_thread=false):" + "FD(timeout=10000;max_tries=5;shun=true;up_thread=false;down_thread=false):" + "VERIFY_SUSPECT(timeout=1500;up_thread=false;down_thread=false):" + "pbcast.NAKACK(max_xmit_size=8192;use_mcast_xmit=false;gc_lag=0;retransmit_timeout=300,600,1200,2400,4800;up_thread=false;down_thread=false):" + "UNICAST(timeout=300,600,1200,2400;up_thread=false;down_thread=false):" + "pbcast.STABLE(stability_delay=1000;desired_avg_gossip=50000;max_bytes=400000;up_thread=false;down_thread=false):" + "VIEW_SYNC(avg_send_interval=60000;up_thread=false;down_thread=false):" + "pbcast.GMS(join_timeout=3000;join_retry_timeout=2000;shun=false;view_bundling=false;print_local_addr=true;up_thread=false;down_thread=false):" + "FC(max_credits=2000000;min_threshold=0.10;up_thread=false;down_thread=false):" + "FRAG2(frag_size=60000;down_thread=false;up_thread=false):" + "pbcast.STATE_TRANSFER(up_thread=false;down_thread=false)";
        System.out.println("props: " + this.props);
        this.bus = new NotificationBus(this.busName, this.props);
    }

    public void start() throws Exception {
        this.bus.setConsumer((NotificationBus.Consumer)this);
        this.bus.start();
    }

    public void stop() {
        log.debug((Object)"Stop on bus");
        this.bus.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addReceiver(MessageBusListener listener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeReceiver(MessageBusListener listener) {
        MessageBusListener messageBusListener = listener;
        synchronized (messageBusListener) {
            return this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleNotification(Serializable n) {
        log.debug((Object)("MessageBus received: " + n));
        List list = this.listeners;
        synchronized (list) {
            for (int x = 0; x < this.listeners.size(); ++x) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Sending message " + n + " to receiver"));
                }
                MessageBusListener l = (MessageBusListener)this.listeners.get(x);
                if (n instanceof RemoteTestMessage) {
                    l.handleRemoteTestMessage((RemoteTestMessage)n);
                    log.debug((Object)("sent message " + n + " to receiver " + l));
                    continue;
                }
                l.handleRemoteDataMessage(n);
                log.debug((Object)("sent data message " + n + " to receiver " + l));
            }
        }
    }

    public Serializable getCache() {
        return null;
    }

    public void memberJoined(Address mbr) {
        this.members.add(mbr);
        log.debug((Object)("Member joined.  List is now " + this.members.size()));
        if (this.memberListener != null) {
            this.memberListener.memberChange(this.members.size());
        }
    }

    public void memberLeft(Address mbr) {
        this.members.remove(mbr);
        log.debug((Object)("Member left.  List is now " + this.members.size()));
        if (this.memberListener != null) {
            this.memberListener.memberChange(this.members.size());
        }
    }

    public int getNumberOfMembers() {
        return this.members.size();
    }

    public void sendMessage(Serializable msg) {
        log.debug((Object)("MessageBus - sending " + msg));
        this.bus.sendNotification(msg);
        log.debug((Object)("MessageBus - sent " + msg));
    }

    public void setMememberChangeListener(RemoteMemberListener listener) {
        this.memberListener = listener;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

