/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jrunit.controller;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.jboss.jrunit.controller.IBenchmark;
import org.jboss.jrunit.data.Benchmark;

public class BenchmarkController
implements IBenchmark {
    HashMap hashBenchmarks = new HashMap();
    private static final HashMap emptyHash = new HashMap();
    Stack benchStack = new Stack();
    Benchmark currentBench = null;

    public void clear() {
        this.hashBenchmarks.clear();
        this.benchStack.clear();
        this.currentBench = null;
    }

    public void addMeasure(String measureName, Number value) {
        this.currentBench.getDefaultExecution().getMeasure(measureName).addValue(value);
    }

    public Collection getBenchmarks() {
        return this.hashBenchmarks.values();
    }

    public void addBench(Benchmark benchmark) {
        Benchmark thisBenchmark = (Benchmark)this.hashBenchmarks.get(benchmark);
        if (thisBenchmark == null) {
            this.hashBenchmarks.put(benchmark, benchmark);
        } else {
            thisBenchmark.addBenchmark(benchmark);
        }
    }

    public void openBench(String benchmarkName) {
        this.openBench(benchmarkName, emptyHash);
    }

    public Benchmark findBenchmark(String name) {
        return this.findBenchmark(name, emptyHash);
    }

    public Benchmark findBenchmark(String name, Map metaData) {
        return BenchmarkController.findBenchmark(this.hashBenchmarks, name, metaData);
    }

    public static Benchmark findBenchmark(Map benchmarks, String name, Map metaData) {
        Benchmark key = new Benchmark(name, metaData);
        return BenchmarkController.findBenchmark(benchmarks, key);
    }

    public static Benchmark findBenchmark(Map benchmarks, Benchmark key) {
        return (Benchmark)benchmarks.get(key);
    }

    public void closeBench(String benchmarkName) {
        if (this.benchStack.empty()) {
            throw new RuntimeException("Failing closing benchmark " + benchmarkName + " as is already closed");
        }
        if (!this.currentBench.getName().equals(benchmarkName)) {
            throw new RuntimeException("Benchmark " + benchmarkName + " didn't match stack of benchmarks (" + this.currentBench.getName() + ")");
        }
        this.currentBench.close();
        this.benchStack.pop();
        this.currentBench = this.benchStack.empty() ? null : (Benchmark)this.benchStack.peek();
    }

    public void openBench(String benchmarkName, Map metadata) {
        HashMap copy = new HashMap();
        copy.putAll(metadata);
        metadata = copy;
        if (this.benchStack.empty()) {
            Benchmark benchmark = null;
            benchmark = this.findBenchmark(benchmarkName, metadata);
            if (benchmark == null) {
                benchmark = new Benchmark(benchmarkName, metadata);
                this.hashBenchmarks.put(benchmark, benchmark);
            }
            this.benchStack.add(benchmark);
            this.currentBench = benchmark;
        } else {
            Benchmark subBench = BenchmarkController.findBenchmark(this.currentBench.getSubBenchmarks(), benchmarkName, metadata);
            if (subBench == null) {
                subBench = new Benchmark(benchmarkName, metadata);
                this.currentBench.getSubBenchmarks().put(subBench, subBench);
            }
            this.benchStack.add(subBench);
            this.currentBench = subBench;
        }
        this.currentBench.open();
    }
}

