/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jrunit.controller.persistence;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jboss.jrunit.controller.persistence.BenchmarkPersistence;
import org.jboss.jrunit.data.Benchmark;
import org.jboss.jrunit.data.BenchmarkExecution;
import org.jboss.jrunit.data.BenchmarkMeasure;

public class BenchmarkDatabaseBenchmarkPersistence
extends BenchmarkPersistence {
    private static final String SQL_BENCHMARK = "SELECT ID,NAME,PARENT_ID FROM BENCH_MARK WHERE PARENT_ID=?";
    private static final String SQL_EXECUTION = "SELECT EXECUTION_ID, EXECUTION_TS, ELAPSED_TIME , EXECUTIONS_NUMBER FROM BENCHMARK_EXECUTION WHERE BENCHMARK_ID=?";
    private static final String SQL_METADATA = "SELECT METADATA_KEY,METADATA_VALUE FROM BENCHMARK_METADATA WHERE BENCHMARK_ID=?";
    private static Logger log = Logger.getLogger((Class)(class$org$jboss$jrunit$controller$persistence$BenchmarkDatabaseBenchmarkPersistence == null ? (class$org$jboss$jrunit$controller$persistence$BenchmarkDatabaseBenchmarkPersistence = BenchmarkDatabaseBenchmarkPersistence.class$("org.jboss.jrunit.controller.persistence.BenchmarkDatabaseBenchmarkPersistence")) : class$org$jboss$jrunit$controller$persistence$BenchmarkDatabaseBenchmarkPersistence));
    Connection conn;
    PreparedStatement selectBenchmarkStatement;
    PreparedStatement insertBenchmarkStatement;
    PreparedStatement updateBenchmarkStatement;
    PreparedStatement insertExecutionStatement;
    PreparedStatement insertMeasureStatement;
    PreparedStatement insertMetadataStatement;
    PreparedStatement viewBenchmarksStatement;
    PreparedStatement viewBenchmarkExecutionsStatement;
    PreparedStatement viewBenchmarkMetatdataStatement;
    boolean verified = false;
    static /* synthetic */ Class class$org$jboss$jrunit$controller$persistence$BenchmarkDatabaseBenchmarkPersistence;

    public BenchmarkDatabaseBenchmarkPersistence(Connection conn) {
        this.conn = conn;
    }

    public void close() throws SQLException {
        this.closeStatements();
    }

    public void persist(Benchmark benchmark) throws SQLException {
        this.verifyTables();
        this.prepareStatements();
        this.saveBenchmark(benchmark, 0);
        this.close();
    }

    public Collection readBenchmarks(int parentId, boolean recursiveOnSubBenchmarks) throws SQLException {
        return this.readBenchmarks(parentId, recursiveOnSubBenchmarks, true);
    }

    public Collection readBenchmarks(int parentId, boolean recursiveOnSubBenchmarks, boolean readExecutions) throws SQLException {
        this.prepareViews();
        this.viewBenchmarksStatement.setInt(1, parentId);
        ResultSet rset = this.viewBenchmarksStatement.executeQuery();
        ArrayList<Benchmark> benchmarkList = new ArrayList<Benchmark>();
        while (rset.next()) {
            Benchmark benchmark = this.readBenchmark(rset, readExecutions);
            benchmarkList.add(benchmark);
        }
        rset.close();
        if (recursiveOnSubBenchmarks) {
            Iterator iter = benchmarkList.iterator();
            while (iter.hasNext()) {
                Benchmark benchmark = (Benchmark)iter.next();
                Collection subBenchmarks = this.readBenchmarks(benchmark.getId(), recursiveOnSubBenchmarks);
                Iterator iterSubs = subBenchmarks.iterator();
                while (iterSubs.hasNext()) {
                    benchmark.addSubBenchmark((Benchmark)iterSubs.next());
                }
            }
        }
        return benchmarkList;
    }

    public Benchmark readBenchmark(ResultSet rset, boolean readExecutions) throws SQLException {
        Benchmark benchmark = new Benchmark();
        benchmark.setId(rset.getInt(1));
        benchmark.setName(rset.getString(2));
        Map metadata = benchmark.getMetadata();
        if (metadata != null) {
            metadata.putAll(this.readMetadata(benchmark.getId()));
        }
        if (readExecutions) {
            this.readExecutions(benchmark);
        }
        return benchmark;
    }

    public void readExecutions(Benchmark benchmark) throws SQLException {
        this.prepareViews();
        this.viewBenchmarkExecutionsStatement.setInt(1, benchmark.getId());
        ResultSet rset = this.viewBenchmarkExecutionsStatement.executeQuery();
        this.readExecutions(benchmark, rset);
    }

    public void readExecutions(Benchmark benchmark, ResultSet rset) throws SQLException {
        ArrayList<BenchmarkExecution> executions = new ArrayList<BenchmarkExecution>();
        while (rset.next()) {
            BenchmarkExecution execution = new BenchmarkExecution();
            execution.setExecutionId(rset.getInt(1));
            execution.setExecutionDate(rset.getTime(2));
            execution.setElapsedTime(rset.getLong(3));
            execution.setExecutions(rset.getInt(4));
            executions.add(execution);
        }
        if (executions.size() != 0) {
            benchmark.setExecution(executions.toArray(new BenchmarkExecution[executions.size()]));
        } else {
            benchmark.setExecution(new BenchmarkExecution[0]);
        }
    }

    private void prepareViews() throws SQLException {
        if (this.viewBenchmarksStatement == null) {
            this.viewBenchmarksStatement = this.conn.prepareStatement(SQL_BENCHMARK);
        }
        if (this.viewBenchmarkExecutionsStatement == null) {
            this.viewBenchmarkExecutionsStatement = this.conn.prepareStatement(SQL_EXECUTION);
        }
        this.prepareViewMetada();
    }

    private void prepareViewMetada() throws SQLException {
        if (this.viewBenchmarkMetatdataStatement == null) {
            this.viewBenchmarkMetatdataStatement = this.conn.prepareStatement(SQL_METADATA);
        }
    }

    private void closeStatements() throws SQLException {
        if (this.insertBenchmarkStatement != null) {
            this.insertBenchmarkStatement.close();
            this.insertBenchmarkStatement = null;
        }
        if (this.selectBenchmarkStatement != null) {
            this.selectBenchmarkStatement.close();
            this.selectBenchmarkStatement = null;
        }
        if (this.updateBenchmarkStatement != null) {
            this.updateBenchmarkStatement.close();
            this.updateBenchmarkStatement = null;
        }
        if (this.insertExecutionStatement != null) {
            this.insertExecutionStatement.close();
            this.insertExecutionStatement = null;
        }
        if (this.insertMeasureStatement != null) {
            this.insertMeasureStatement.close();
            this.insertMeasureStatement = null;
        }
        if (this.viewBenchmarksStatement != null) {
            this.viewBenchmarksStatement.close();
            this.viewBenchmarksStatement = null;
        }
        if (this.viewBenchmarkExecutionsStatement != null) {
            this.viewBenchmarkExecutionsStatement.close();
            this.viewBenchmarkExecutionsStatement = null;
        }
        if (this.viewBenchmarkMetatdataStatement != null) {
            this.viewBenchmarkMetatdataStatement.close();
            this.viewBenchmarkMetatdataStatement = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeIntSelect(String sql) throws SQLException {
        Statement statement = this.conn.createStatement();
        ResultSet rset = statement.executeQuery(sql);
        try {
            if (!rset.next()) {
                int n = 0;
                return n;
            }
            int n = rset.getInt(1);
            return n;
        }
        finally {
            try {
                statement.close();
                if (rset != null) {
                    rset.close();
                }
            }
            catch (Exception ignored) {}
        }
    }

    private void saveBenchmark(Benchmark benchmark, int parentId) throws SQLException {
        this.locateBenchmarkId(benchmark, parentId);
        if (parentId != 0) {
            this.saveExecutions(benchmark);
        }
        this.saveSubBenchmarks(benchmark);
    }

    protected Map readMetadata(int benchmarkId) throws SQLException {
        this.prepareViewMetada();
        this.viewBenchmarkMetatdataStatement.setInt(1, benchmarkId);
        ResultSet rset = this.viewBenchmarkMetatdataStatement.executeQuery();
        HashMap<String, String> returnValue = new HashMap<String, String>();
        while (rset.next()) {
            returnValue.put(rset.getString(1), rset.getString(2));
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void locateBenchmarkId(Benchmark benchmark, int parentId) throws SQLException {
        this.selectBenchmarkStatement.setString(1, benchmark.getName());
        int currentId = 0;
        boolean found = false;
        ResultSet rset = null;
        try {
            rset = this.selectBenchmarkStatement.executeQuery();
            while (rset.next()) {
                currentId = rset.getInt(1);
                Map checkMetaData = this.readMetadata(currentId);
                if (!((Object)benchmark.getMetadata()).equals(checkMetaData)) continue;
                found = true;
                break;
            }
        }
        finally {
            try {
                rset.close();
            }
            catch (Exception e) {}
        }
        if (!found) {
            currentId = this.executeIntSelect("SELECT MAX(ID) FROM BENCH_MARK") + 1;
        }
        benchmark.setId(currentId);
        rset.close();
        if (!found) {
            this.insertBenchmarkStatement.setInt(1, benchmark.getId());
            this.insertBenchmarkStatement.setString(2, benchmark.getName());
            if (parentId == 0) {
                this.insertBenchmarkStatement.setNull(3, 4);
            } else {
                this.insertBenchmarkStatement.setInt(3, parentId);
            }
            this.insertBenchmarkStatement.execute();
            this.addBenchmarkMetadata(benchmark);
        } else {
            this.updateBenchmarkStatement.setInt(1, parentId);
            this.updateBenchmarkStatement.setInt(2, currentId);
            this.updateBenchmarkStatement.execute();
        }
    }

    private void addBenchmarkMetadata(Benchmark benchmark) throws SQLException {
        if (benchmark != null && benchmark.getMetadata() != null) {
            int benchId = benchmark.getId();
            Map metadata = benchmark.getMetadata();
            Iterator iter = metadata.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry obj;
                Map.Entry entry = obj = iter.next();
                this.insertMetadataStatement.setInt(1, benchId);
                this.insertMetadataStatement.setString(2, entry.getKey().toString());
                this.insertMetadataStatement.setString(3, entry.getValue().toString());
                this.insertMetadataStatement.execute();
            }
        }
    }

    private void saveExecutions(Benchmark benchmark) throws SQLException {
        BenchmarkExecution[] executions = benchmark.getExecution();
        int executionId = this.executeIntSelect("SELECT MAX(EXECUTION_ID) FROM BENCHMARK_EXECUTION WHERE BENCHMARK_ID=" + benchmark.getId()) + 1;
        for (int i = 0; i < executions.length; ++i) {
            BenchmarkExecution execution = executions[i];
            execution.setExecutionId(executionId++);
            this.insertExecutionStatement.setInt(1, benchmark.getId());
            this.insertExecutionStatement.setInt(2, execution.getExecutionId());
            this.insertExecutionStatement.setTimestamp(3, new Timestamp(execution.getExecutionDate().getTime()));
            this.insertExecutionStatement.setLong(4, execution.getElapsedTime());
            this.insertExecutionStatement.setInt(5, execution.getExecutions());
            this.insertExecutionStatement.execute();
            this.saveMeasures(benchmark, execution);
        }
    }

    private void saveMeasures(Benchmark benchmark, BenchmarkExecution execution) throws SQLException {
        int measureId = this.executeIntSelect("SELECT MAX(MEASURE_ID) FROM BENCHMARK_EXECUTION_MEASURE WHERE BENCHMARK_ID=" + benchmark.getId() + " AND EXECUTION_ID=" + execution.getExecutionId()) + 1;
        Iterator iter = execution.getAllMeasures().iterator();
        while (iter.hasNext()) {
            log.debug((Object)"Saving measure");
            BenchmarkMeasure measure = (BenchmarkMeasure)iter.next();
            measure.setMeasureId(measureId++);
            this.insertMeasureStatement.setInt(1, benchmark.getId());
            this.insertMeasureStatement.setInt(2, execution.getExecutionId());
            this.insertMeasureStatement.setInt(3, measure.getMeasureId());
            this.insertMeasureStatement.setString(4, measure.getName());
            this.insertMeasureStatement.setDouble(5, measure.getValue().doubleValue());
            this.insertMeasureStatement.execute();
        }
    }

    private void saveSubBenchmarks(Benchmark benchmark) throws SQLException {
        Iterator iter = benchmark.getSubBenchmarks().values().iterator();
        while (iter.hasNext()) {
            Benchmark child = (Benchmark)iter.next();
            this.saveBenchmark(child, benchmark.getId());
        }
    }

    private void prepareStatements() throws SQLException {
        if (this.insertBenchmarkStatement == null) {
            this.insertBenchmarkStatement = this.conn.prepareStatement("INSERT INTO BENCH_MARK (ID,NAME,PARENT_ID) VALUES (?,?,?)");
        }
        if (this.selectBenchmarkStatement == null) {
            this.selectBenchmarkStatement = this.conn.prepareStatement("SELECT ID FROM BENCH_MARK WHERE NAME=?");
        }
        if (this.updateBenchmarkStatement == null) {
            this.updateBenchmarkStatement = this.conn.prepareStatement("UPDATE BENCH_MARK SET PARENT_ID=? WHERE ID=?");
        }
        if (this.insertExecutionStatement == null) {
            this.insertExecutionStatement = this.conn.prepareStatement("INSERT INTO BENCHMARK_EXECUTION (BENCHMARK_ID,EXECUTION_ID,EXECUTION_TS,ELAPSED_TIME,EXECUTIONS_NUMBER) VALUES (?,?,?,?,?)");
        }
        if (this.insertMeasureStatement == null) {
            this.insertMeasureStatement = this.conn.prepareStatement("INSERT INTO BENCHMARK_EXECUTION_MEASURE (BENCHMARK_ID,EXECUTION_ID,MEASURE_ID,NAME,VALUE) VALUES (?,?,?,?,?)");
        }
        if (this.insertMetadataStatement == null) {
            this.insertMetadataStatement = this.conn.prepareStatement("INSERT INTO BENCHMARK_METADATA (BENCHMARK_ID,METADATA_KEY,METADATA_VALUE) VALUES (?,?,?)");
        }
        this.prepareViewMetada();
    }

    private void verifyTables() throws SQLException {
        if (!this.verified) {
            this.verified = true;
            Statement statement = this.conn.createStatement();
            if (!this.tableExists("BENCH_MARK")) {
                statement.execute("CREATE TABLE BENCH_MARK (ID INTEGER,NAME VARCHAR(255),PARENT_ID INTEGER)");
            }
            if (!this.tableExists("BENCHMARK_EXECUTION")) {
                statement.execute("CREATE TABLE BENCHMARK_EXECUTION (BENCHMARK_ID INTEGER, EXECUTION_ID INTEGER, EXECUTION_TS DATETIME, ELAPSED_TIME BIGINT, EXECUTIONS_NUMBER INTEGER)");
            }
            if (!this.tableExists("BENCHMARK_EXECUTION_MEASURE")) {
                statement.execute("CREATE TABLE BENCHMARK_EXECUTION_MEASURE (BENCHMARK_ID INTEGER, EXECUTION_ID INTEGER, MEASURE_ID INTEGER, NAME VARCHAR(255), VALUE DECIMAL)");
            }
            if (!this.tableExists("BENCHMARK_METADATA")) {
                statement.execute("CREATE TABLE BENCHMARK_METADATA (BENCHMARK_ID INTEGER, METADATA_KEY VARCHAR(255), METADATA_VALUE VARCHAR(255))");
            }
        }
    }

    private boolean tableExists(String tableName) {
        ResultSet rs = null;
        try {
            DatabaseMetaData dmd = this.conn.getMetaData();
            String catalog = this.conn.getCatalog();
            String schema = null;
            String quote = dmd.getIdentifierQuoteString();
            if (tableName.startsWith(quote)) {
                if (!tableName.endsWith(quote)) {
                    throw new IllegalStateException("Mismatched quote in table name: " + tableName);
                }
                int quoteLength = quote.length();
                tableName = tableName.substring(quoteLength, tableName.length() - quoteLength);
                if (dmd.storesLowerCaseQuotedIdentifiers()) {
                    tableName = tableName.toLowerCase();
                } else if (dmd.storesUpperCaseQuotedIdentifiers()) {
                    tableName = tableName.toUpperCase();
                }
            } else if (dmd.storesLowerCaseIdentifiers()) {
                tableName = tableName.toLowerCase();
            } else if (dmd.storesUpperCaseIdentifiers()) {
                tableName = tableName.toUpperCase();
            }
            int dotIndex = tableName.indexOf(46);
            if (dotIndex != -1) {
                schema = tableName.substring(0, dotIndex);
                tableName = tableName.substring(dotIndex + 1);
            }
            rs = dmd.getTables(catalog, schema, tableName, null);
            boolean bl = rs.next();
            return bl;
        }
        catch (SQLException e) {
            throw new IllegalStateException("Error while checking if table aleady exists " + tableName + ": " + e.getMessage());
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception ignored) {}
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

