/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jrunit.controller.receiver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.jboss.jrunit.communication.BenchmarkQuitListener;
import org.jboss.jrunit.communication.MessageBus;
import org.jboss.jrunit.communication.MessageBusListener;
import org.jboss.jrunit.communication.message.QuitMessage;
import org.jboss.jrunit.communication.message.RemoteTestMessage;
import org.jboss.jrunit.controller.reporters.BenchmarkReporter;
import org.jboss.jrunit.controller.reporters.ConsoleBenchmarkReporter;
import org.jboss.jrunit.data.Benchmark;

public class JGroupsBenchmarkReceiver
implements MessageBusListener {
    private static Logger log = Logger.getLogger((Class)(class$org$jboss$jrunit$controller$receiver$JGroupsBenchmarkReceiver == null ? (class$org$jboss$jrunit$controller$receiver$JGroupsBenchmarkReceiver = JGroupsBenchmarkReceiver.class$("org.jboss.jrunit.controller.receiver.JGroupsBenchmarkReceiver")) : class$org$jboss$jrunit$controller$receiver$JGroupsBenchmarkReceiver));
    Benchmark root = new Benchmark("root");
    private List reporters = new ArrayList();
    protected MessageBus bus;
    BenchmarkQuitListener quitListener;
    boolean keepRunning;
    boolean startThread;
    static /* synthetic */ Class class$org$jboss$jrunit$controller$receiver$JGroupsBenchmarkReceiver;

    public JGroupsBenchmarkReceiver(boolean startThread) throws Exception {
        this.startThread = startThread;
        this.start();
    }

    public void start() throws Exception {
        this.bus = new MessageBus();
        this.bus.addReceiver(this);
        this.bus.start();
        this.addReporter(new ConsoleBenchmarkReporter());
        if (this.startThread) {
            this.initServerThread();
        }
    }

    public JGroupsBenchmarkReceiver(BenchmarkQuitListener listener, boolean startThread) throws Exception {
        this(startThread);
        this.quitListener = listener;
    }

    private void initServerThread() {
        this.keepRunning = true;
        Thread svrThread = new Thread(){

            public void run() {
                while (JGroupsBenchmarkReceiver.this.keepRunning) {
                    try {
                        1.currentThread();
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        log.debug((Object)"Server thread interrupted.");
                    }
                    log.debug((Object)"Tick");
                }
                log.debug((Object)"Quit message");
            }
        };
        svrThread.setDaemon(false);
        svrThread.start();
    }

    private void onQuit(QuitMessage quitMessage) throws Exception {
        if (this.quitListener != null) {
            if (this.quitListener.onQuit(quitMessage)) {
                this.doQuit();
            }
        } else {
            this.doQuit();
        }
    }

    private void doQuit() throws Exception {
        System.out.println("Quit on Receiver");
        this.keepRunning = false;
        this.bus.stop();
        this.firelReporters();
    }

    public void handleRemoteTestMessage(RemoteTestMessage message) {
        if (message instanceof QuitMessage) {
            try {
                this.onQuit((QuitMessage)message);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void firelReporters() throws Exception {
        Iterator iterReporter = this.reporters.iterator();
        while (iterReporter.hasNext()) {
            BenchmarkReporter reporter = (BenchmarkReporter)iterReporter.next();
            reporter.writeBenchmarkResults(this.getRoot());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRemoteDataMessage(Object message) {
        if (message instanceof Collection) {
            Collection benchmarkList = (Collection)message;
            Iterator iterColl = benchmarkList.iterator();
            Benchmark benchmark = this.root;
            synchronized (benchmark) {
                while (iterColl.hasNext()) {
                    Benchmark receivedBenchmark = (Benchmark)iterColl.next();
                    this.root.addSubBenchmark(receivedBenchmark);
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Received Benchmark=" + receivedBenchmark));
                }
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Message is " + message.getClass().getName()));
        }
    }

    public Benchmark getRoot() {
        return this.root;
    }

    public void addReporter(BenchmarkReporter reporter) {
        this.reporters.add(reporter);
    }

    public void removeReporter(BenchmarkReporter reporter) {
        this.reporters.remove(reporter);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

