/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jrunit.data;

import java.io.PrintStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jboss.jrunit.controller.BenchmarkController;
import org.jboss.jrunit.data.BenchmarkExecution;
import org.jboss.jrunit.data.BenchmarkMeasure;

public class Benchmark
implements Serializable {
    BenchmarkExecution[] execution;
    int id;
    String name;
    Map metadata;
    long timeOpen;
    long timeClose;
    HashMap subBenchmarks = new HashMap();

    public Benchmark() {
        this.metadata = new HashMap();
    }

    public Benchmark(String benchmarkName) {
        this(benchmarkName, new HashMap());
    }

    public Benchmark(String benchmarkName, Map metadata) {
        this.setName(benchmarkName);
        this.metadata = metadata;
    }

    public HashMap getSubBenchmarks() {
        return this.subBenchmarks;
    }

    public Benchmark findBenchmark(String name) {
        return this.findBenchmark(name, new HashMap());
    }

    public Benchmark findBenchmark(String name, Map metadata) {
        return BenchmarkController.findBenchmark(this.subBenchmarks, name, metadata);
    }

    public void open() {
        this.timeOpen = System.currentTimeMillis();
    }

    public BenchmarkExecution getDefaultExecution() {
        if (this.execution == null) {
            this.execution = new BenchmarkExecution[]{new BenchmarkExecution()};
        }
        return this.execution[0];
    }

    public void close() {
        this.timeClose = System.currentTimeMillis();
        BenchmarkExecution defaultExecution = this.getDefaultExecution();
        ++defaultExecution.executions;
        defaultExecution.elapsedTime += this.timeClose - this.timeOpen;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void addSubBenchmark(Benchmark benchmark) {
        Benchmark thisSub = (Benchmark)this.subBenchmarks.get(benchmark);
        if (thisSub == null) {
            this.subBenchmarks.put(benchmark, benchmark);
        } else {
            thisSub.addBenchmark(benchmark);
        }
    }

    public void addBenchmark(Benchmark benchmark) {
        BenchmarkExecution defaultExecution = this.getDefaultExecution();
        if (!this.equals(benchmark)) {
            throw new RuntimeException("Cannot add " + benchmark.getName() + " to " + this.name);
        }
        defaultExecution.elapsedTime += benchmark.getDefaultExecution().getElapsedTime();
        defaultExecution.executions += benchmark.getDefaultExecution().getExecutions();
        Collection allMeasures = benchmark.getDefaultExecution().getAllMeasures();
        Iterator iterMeasures = allMeasures.iterator();
        while (iterMeasures.hasNext()) {
            BenchmarkMeasure otherBenchmarkMeasure = (BenchmarkMeasure)iterMeasures.next();
            BenchmarkMeasure thisBenchmarkMeasure = (BenchmarkMeasure)defaultExecution.getMeasuresHashMap().get(otherBenchmarkMeasure.getName());
            if (thisBenchmarkMeasure == null) {
                defaultExecution.getMeasuresHashMap().put(otherBenchmarkMeasure.getName(), otherBenchmarkMeasure);
                continue;
            }
            thisBenchmarkMeasure.addMeasure(otherBenchmarkMeasure);
        }
        Collection allBenchmarks = benchmark.getSubBenchmarks().values();
        Iterator iterBenchmarks = allBenchmarks.iterator();
        while (iterBenchmarks.hasNext()) {
            Benchmark otherBenchmark = (Benchmark)iterBenchmarks.next();
            Benchmark thisBenchmark = (Benchmark)this.subBenchmarks.get(otherBenchmark);
            if (thisBenchmark == null) {
                this.subBenchmarks.put(otherBenchmark, otherBenchmark);
                continue;
            }
            thisBenchmark.addBenchmark(otherBenchmark);
        }
    }

    public void print(PrintStream stream) {
        this.print(0, stream);
    }

    protected void print(int level, PrintStream stream) {
        StringBuffer bufferLevel = new StringBuffer();
        for (int i = 0; i < level; ++i) {
            bufferLevel.append("  ");
        }
        String levelString = bufferLevel.toString();
        int numberOfExecutions = this.getDefaultExecution().getExecutions();
        long totalElapsedTime = this.getDefaultExecution().getElapsedTime();
        stream.println(levelString + "Benchmark:" + this.getName());
        stream.println(levelString + "Executions:" + numberOfExecutions);
        stream.println(levelString + "Time:" + totalElapsedTime);
        if (numberOfExecutions > 1) {
            long avg = totalElapsedTime / (long)numberOfExecutions;
            stream.println(levelString + "Avg:" + avg);
        }
        if (this.metadata != null && !this.metadata.isEmpty()) {
            stream.println(levelString + "Metadata:");
            String metadataLevelString = levelString + "  ";
            Set entries = this.metadata.entrySet();
            Iterator itr = entries.iterator();
            while (itr.hasNext()) {
                Map.Entry entry = itr.next();
                stream.println(metadataLevelString + entry.getKey() + ":" + entry.getValue());
            }
        }
        Iterator iterMeasures = this.getDefaultExecution().getAllMeasures().iterator();
        while (iterMeasures.hasNext()) {
            BenchmarkMeasure benchmarkMeasure = (BenchmarkMeasure)iterMeasures.next();
            stream.println(levelString + benchmarkMeasure.getName() + "=" + benchmarkMeasure.getValue());
        }
        stream.println(levelString + "SubBenchmarks:");
        Iterator iterSubs = this.subBenchmarks.values().iterator();
        while (iterSubs.hasNext()) {
            Benchmark subBench = (Benchmark)iterSubs.next();
            subBench.print(level + 1, stream);
        }
    }

    public BenchmarkExecution[] getExecution() {
        return this.execution;
    }

    public void setExecution(BenchmarkExecution[] execution) {
        this.execution = execution;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String toString() {
        return this.name + " metaData=" + this.metadata;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        Benchmark reference = (Benchmark)obj;
        if (!this.name.equals(reference.getName())) {
            return false;
        }
        if (this.metadata == null && reference.metadata != null) {
            return false;
        }
        if (this.metadata != null && reference.metadata == null) {
            return false;
        }
        if (this.metadata != null && reference.metadata != null) {
            if (this.metadata.size() != reference.metadata.size()) {
                return false;
            }
            Iterator iter = this.metadata.keySet().iterator();
            while (iter.hasNext()) {
                Object key = iter.next();
                Object value1 = this.metadata.get(key);
                Object value2 = reference.metadata.get(key);
                if (value1 == null || value2 == null) {
                    return false;
                }
                if (value1.equals(value2)) continue;
                return false;
            }
        }
        return true;
    }

    public Map getMetadata() {
        return this.metadata;
    }
}

