/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jrunit.decorators;

import java.lang.reflect.Method;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.jboss.jrunit.decorators.ThreadListener;

public class JunitLoopDecorator
implements Test,
Runnable {
    private static final String LOOPTEARDOWN = "loopTearDown";
    private static final String LOOPSETUP = "loopSetup";
    private static final String THREADTEARDOWN = "threadTearDown";
    private static final String THREADSETUP = "threadSetup";
    Test tests;
    TestResult result;
    Method threadSetupMethod;
    Method threadTearDownMethod;
    Method loopSetupMethod;
    Method loopTearDownMethod;
    TestCase testCase = new TestCase(){};
    Class testClazz;
    int loops;
    long timeWait;
    ThreadListener threadSynchronizer;

    public int countTestCases() {
        return this.loops;
    }

    public Test getTestDecorated() {
        return this.tests;
    }

    public JunitLoopDecorator(String loopName, Class testClazz, int loops, long timeWait) {
        this(loopName, testClazz, loops, timeWait, null);
    }

    public JunitLoopDecorator(String loopName, Class testClazz, int loops, long timeWait, ThreadListener threadSynchronizer) {
        this(loopName, testClazz, loops, timeWait, threadSynchronizer, new TestResult());
    }

    public JunitLoopDecorator(String loopName, Class testClazz, int loops, long timeWait, ThreadListener threadSynchronizer, TestResult result) {
        this.testCase.setName(loopName);
        this.loops = loops;
        this.timeWait = timeWait;
        this.testClazz = testClazz;
        this.tests = new TestSuite(testClazz, testClazz.getName() + " loop");
        this.threadSynchronizer = threadSynchronizer;
        this.result = result;
        this.findControlMethods();
    }

    private void findControlMethods() {
        this.threadSetupMethod = this.findMethod(THREADSETUP, false);
        this.threadTearDownMethod = this.findMethod(THREADTEARDOWN, false);
        this.loopSetupMethod = this.findMethod(LOOPSETUP, true);
        this.loopTearDownMethod = this.findMethod(LOOPTEARDOWN, true);
    }

    private Method findMethod(String name, boolean isLoop) {
        Class[] classArray = null;
        classArray = isLoop ? new Class[]{Integer.TYPE} : new Class[]{};
        Method method = null;
        try {
            method = this.testClazz.getDeclaredMethod(name, classArray);
        }
        catch (Exception e) {
            try {
                method = this.testClazz.getMethod(name, classArray);
            }
            catch (Exception e2) {
                // empty catch block
            }
        }
        return method;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(TestResult run) {
        this.result = run;
        this.loopSetup();
        try {
            if (!this.executeStatic(this.threadSetupMethod, -1)) {
                return;
            }
            for (int i = 0; i < this.loops; ++i) {
                if (!this.executeStatic(this.loopSetupMethod, i)) {
                    return;
                }
                this.tests.run(run);
                if (!this.executeStatic(this.loopTearDownMethod, i)) {
                    return;
                }
                Thread.sleep(this.timeWait);
            }
            if (!this.executeStatic(this.threadTearDownMethod, -1)) {
                return;
            }
        }
        catch (InterruptedException interrupted) {
            interrupted.printStackTrace();
        }
        finally {
            this.loopTearDown();
            if (this.threadSynchronizer != null) {
                this.threadSynchronizer.threadFinished((Test)this.getTestCase(), run);
            }
        }
    }

    private boolean executeStatic(Method method, int i) {
        if (method != null) {
            try {
                Object[] parameter = null;
                parameter = i >= 0 ? new Object[]{new Integer(i)} : new Object[]{};
                method.invoke(null, parameter);
            }
            catch (Exception e) {
                this.result.addError(this.tests, (Throwable)e);
                return false;
            }
        }
        return true;
    }

    public void run() {
        this.run(this.result);
    }

    public TestResult getResult() {
        return this.result;
    }

    public TestCase getTestCase() {
        return this.testCase;
    }

    public void loopSetup() {
    }

    public void loopTearDown() {
    }
}

