/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jrunit.decorators;

import java.util.Enumeration;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestFailure;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.jboss.jrunit.decorators.JunitLoopDecorator;
import org.jboss.jrunit.decorators.ThreadListener;
import org.jboss.jrunit.decorators.ThreadLocalJunitLoop;

public class JunitThreadDecorator
extends TestSuite
implements ThreadListener,
Test {
    JunitLoopDecorator[] loopDecorators;
    Class testClazz;
    TestResult result;
    int numberOfThreads;
    int numberOfFinishedThreads;
    Object mutex = new Object();

    public int countTestCases() {
        return this.numberOfThreads;
    }

    public JunitThreadDecorator(Class testClazz, int numberOfThreads, int loops, long timeWait) {
        this(testClazz, numberOfThreads, loops, timeWait, false);
    }

    JunitThreadDecorator(Class testClazz, int numberOfThreads, int loops, long timeWait, boolean useJGroupsSender) {
        super("MultiThreadTest for " + testClazz.getName());
        this.numberOfThreads = numberOfThreads;
        this.testClazz = testClazz;
        this.loopDecorators = new JunitLoopDecorator[numberOfThreads];
        for (int i = 0; i < numberOfThreads; ++i) {
            this.loopDecorators[i] = useJGroupsSender ? new ThreadLocalJunitLoop("Loop " + i + " for " + testClazz.getName(), testClazz, loops, timeWait, this) : new JunitLoopDecorator("Loop " + i + " for " + testClazz.getName(), testClazz, loops, timeWait, this);
        }
    }

    public Test testAt(int index) {
        return this.loopDecorators[index];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void threadFinished(Test test, TestResult result) {
        Object object = this.mutex;
        synchronized (object) {
            ++this.numberOfFinishedThreads;
            this.copyResultsToResult(this.result, result);
            this.result.endTest(test);
            if (this.numberOfFinishedThreads == this.numberOfThreads) {
                this.mutex.notifyAll();
            }
        }
    }

    public void run(TestResult result) {
        int i;
        this.threadsSetup();
        this.result = result;
        Thread[] threads = new Thread[this.numberOfThreads];
        for (i = 0; i < this.numberOfThreads; ++i) {
            threads[i] = new Thread(this.loopDecorators[i]);
        }
        for (i = 0; i < this.numberOfThreads; ++i) {
            result.startTest((Test)this.loopDecorators[i].getTestCase());
            threads[i].start();
        }
        this.waitForFinishedThreads();
    }

    private void copyResultsToResult(TestResult destination, TestResult source) {
        Enumeration errorEnumeraion = source.errors();
        while (errorEnumeraion.hasMoreElements()) {
            TestFailure failure = (TestFailure)errorEnumeraion.nextElement();
            destination.addError(failure.failedTest(), failure.thrownException());
        }
        Enumeration failureEnumeraion = source.failures();
        while (failureEnumeraion.hasMoreElements()) {
            TestFailure failure = (TestFailure)failureEnumeraion.nextElement();
            destination.addFailure(failure.failedTest(), (AssertionFailedError)failure.thrownException());
        }
    }

    public void waitForFinishedThreads() {
        Object object = this.mutex;
        synchronized (object) {
            while (true) {
                if (this.numberOfFinishedThreads == this.numberOfThreads) {
                    this.threadsTearDown();
                    return;
                }
                try {
                    this.mutex.wait();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void threadsSetup() {
    }

    public void threadsTearDown() {
    }
}

