/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jrunit.extensions;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.PrintWriter;
import java.io.StringWriter;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestFailure;
import org.jboss.jrunit.extensions.SerializableTest;

public class SerializableTestFailure
extends TestFailure
implements Externalizable {
    SerializableTest test = null;
    Throwable thr = null;

    public SerializableTestFailure() {
        super(null, null);
    }

    public SerializableTestFailure(Test failedTest, Throwable throwableException, String testClass) {
        super(null, null);
        this.test = new SerializableTest(failedTest, testClass);
        this.thr = throwableException;
    }

    public Test failedTest() {
        return this.test;
    }

    public Throwable thrownException() {
        return this.thr;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.test + ": " + this.thr.getMessage());
        return buffer.toString();
    }

    public String trace() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        this.thrownException().printStackTrace(writer);
        StringBuffer buffer = stringWriter.getBuffer();
        return buffer.toString();
    }

    public String exceptionMessage() {
        return this.thrownException().getMessage();
    }

    public boolean isFailure() {
        return this.thrownException() instanceof AssertionFailedError;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.test = (SerializableTest)in.readObject();
        this.thr = (Throwable)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.failedTest());
        out.writeObject(this.thrownException());
    }
}

