/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jrunit.harness;

import EDU.oswego.cs.dl.util.concurrent.Latch;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import junit.framework.Test;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Category;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.jboss.jrunit.communication.MessageBus;
import org.jboss.jrunit.communication.MessageBusListener;
import org.jboss.jrunit.communication.message.AbortMessage;
import org.jboss.jrunit.communication.message.ExceptionMessage;
import org.jboss.jrunit.communication.message.OfflineMessage;
import org.jboss.jrunit.communication.message.OnlineMessage;
import org.jboss.jrunit.communication.message.RemoteTestMessage;
import org.jboss.jrunit.communication.message.ResultMessage;
import org.jboss.jrunit.communication.message.RunTestMessage;
import org.jboss.jrunit.communication.message.ServerResultMessage;
import org.jboss.jrunit.communication.message.StartupMessage;
import org.jboss.jrunit.communication.message.TearDownMessage;
import org.jboss.jrunit.communication.message.TornDownMessage;
import org.jboss.jrunit.exception.TearDownTimeOutException;
import org.jboss.jrunit.exception.TestCleanupException;
import org.jboss.jrunit.exception.TestCreationException;
import org.jboss.jrunit.exception.TestInitializationException;
import org.jboss.jrunit.exception.TestRunException;
import org.jboss.jrunit.exception.TestRunLockTimeOutException;
import org.jboss.jrunit.extensions.ServerTestCase;
import org.jboss.logging.XLevel;

public class ServerTestHarness
implements MessageBusListener {
    public static final int NO_TEST_CLASS = 10;
    public static final int ERROR_STARTING_HARNESS = 11;
    public static final int ERROR_CREATING_TEST = 12;
    public static final int ERROR_RUNNING_TEST = 13;
    public static final int ERROR_INITIALIZING_TEST = 14;
    public static final int ERROR_CLEANING_TEST = 15;
    public static final int ABORTING_TEST = 16;
    private String testClass;
    private MessageBus bus = null;
    private static Latch runTestsLock = new Latch();
    private long runTestsTimeout = 30000L;
    private static Latch tearDownLock = new Latch();
    private long tearDownTimeout = 300000L;
    private static Latch resultsLock = new Latch();
    private long resultsTimeout = 5000L;
    private String resultId = null;
    private int instanceNumber = 1;
    private static Logger log = Logger.getLogger((Class)(class$org$jboss$jrunit$harness$ServerTestHarness == null ? (class$org$jboss$jrunit$harness$ServerTestHarness = ServerTestHarness.class$("org.jboss.jrunit.harness.ServerTestHarness")) : class$org$jboss$jrunit$harness$ServerTestHarness));
    static /* synthetic */ Class class$org$jboss$jrunit$harness$ServerTestHarness;
    static /* synthetic */ Class class$org$jboss$jrunit$extensions$ServerTestCase;

    public ServerTestHarness(String testClass, int number) throws Exception {
        this.initCommChannel();
        this.testClass = testClass;
        this.instanceNumber = number;
        this.sendOnlineMessage(testClass + "_" + this.instanceNumber);
    }

    private void sendOnlineMessage(String testName) {
        OnlineMessage onlineMsg = new OnlineMessage(testName);
        this.sendMessage(onlineMsg);
    }

    public void shutdown() {
        if (this.bus != null) {
            this.bus.stop();
        }
    }

    private void setTearDownTimeout(long tearDownTimeout) {
        this.tearDownTimeout = tearDownTimeout;
    }

    private void setRunTestTimeout(long runTestTimeout) {
        this.runTestsTimeout = runTestTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTests() throws TestCreationException, TestRunException, TestInitializationException, TestCleanupException {
        block27: {
            boolean isServerTest = false;
            boolean areServerTests = false;
            ServerTestCase serverTest = null;
            Class<?> test = null;
            try {
                ServerTestCase svrTest;
                TestSuite suite;
                try {
                    test = Class.forName(this.testClass);
                    TestSuite tempSuite = null;
                    try {
                        Method suiteMethod = test.getMethod("suite", null);
                        Object obj = suiteMethod.invoke(null, null);
                        tempSuite = (TestSuite)obj;
                    }
                    catch (NoSuchMethodException e) {
                        log.debug((Object)("No suite method on class " + this.testClass));
                    }
                    catch (SecurityException e) {
                        log.warn((Object)"Could not check for suite method within test class due to security exception.", (Throwable)e);
                    }
                    if (tempSuite == null) {
                        tempSuite = new TestSuite(test, this.testClass);
                        log.debug((Object)("Created test suite for " + this.testClass));
                    }
                    suite = tempSuite;
                }
                catch (Throwable thr) {
                    log.error((Object)("Error creating test suite for " + this.testClass), thr);
                    this.sendErrorMessage(thr);
                    throw new TestCreationException();
                }
                try {
                    if (suite.testCount() > 0 && suite.testAt(0) instanceof ServerTestCase) {
                        isServerTest = true;
                        Test t = suite.testAt(0);
                        if (t != null && t instanceof ServerTestCase) {
                            svrTest = (ServerTestCase)t;
                            areServerTests = svrTest.countTestCases() > 0;
                            log.debug((Object)("Found ServerTestCase " + svrTest.getName() + ".  Has test methods: " + areServerTests));
                            log.debug((Object)"Calling ServerTestCase setUp()");
                            svrTest.initialize();
                        }
                        log.debug((Object)"Done initializing server test case.  Sending startup message.");
                        this.sendStartupMessage(areServerTests);
                    } else if ((class$org$jboss$jrunit$extensions$ServerTestCase == null ? (class$org$jboss$jrunit$extensions$ServerTestCase = ServerTestHarness.class$("org.jboss.jrunit.extensions.ServerTestCase")) : class$org$jboss$jrunit$extensions$ServerTestCase).isAssignableFrom(test)) {
                        isServerTest = true;
                        serverTest = (ServerTestCase)((Object)test.newInstance());
                        serverTest.initialize();
                        log.debug((Object)"Done initializing server test case.  Sending startup message.");
                        this.sendStartupMessage(areServerTests);
                    }
                }
                catch (Throwable e) {
                    log.error((Object)"Error initializing server test case.", e);
                    this.sendErrorMessage(e);
                    throw new TestInitializationException();
                }
                Thread serverTestThread = null;
                try {
                    log.debug((Object)"Waiting for run message.");
                    this.waitForRunMessage();
                    log.debug((Object)"Start of test run.");
                    if (isServerTest) {
                        if (areServerTests) {
                            log.debug((Object)"Starting server tests on new thread.");
                            serverTestThread = new Thread(){

                                public void run() {
                                    TestResult result = ServerTestHarness.this.executeTestSuite(suite);
                                    log.debug((Object)("Sending server result message.  Result = " + result));
                                    ServerTestHarness.this.sendServerResultMessage(result);
                                }
                            };
                            serverTestThread.start();
                        }
                    } else {
                        Thread clientTestThread = new Thread(){

                            public void run() {
                                log.debug((Object)"Executing client test case.");
                                TestResult result = ServerTestHarness.this.executeTestSuite(suite);
                                log.debug((Object)("Sending result message.  Result = " + result));
                                ServerTestHarness.this.sendResultMessage(result);
                            }
                        };
                        clientTestThread.start();
                        clientTestThread.join(this.tearDownTimeout);
                    }
                }
                catch (Throwable thr) {
                    log.error((Object)"Error running test suite.", thr);
                    this.sendErrorMessage(thr);
                    throw new TestRunException();
                }
                if (!isServerTest) break block27;
                try {
                    log.debug((Object)"Waiting for tear down message.");
                    this.waitForTearDownMessage();
                    try {
                        if (serverTest == null) {
                            svrTest = (ServerTestCase)suite.testAt(0);
                            log.debug((Object)"Calling tearDown() on ServerTestCase.");
                            svrTest.shutdown();
                        } else {
                            serverTest.shutdown();
                        }
                        if (serverTestThread != null) {
                            serverTestThread.join(30000L);
                        }
                        log.debug((Object)"Sending torn down message.");
                        this.sendTowrnDownMessage();
                    }
                    catch (Throwable e) {
                        log.error((Object)"Error tearing down server test case.", e);
                        this.sendErrorMessage(e);
                        throw new TestCleanupException();
                    }
                }
                catch (Throwable thr) {
                    log.error((Object)"Error waiting for tear down message.", thr);
                    this.sendErrorMessage(thr);
                    throw new TestCleanupException();
                }
            }
            finally {
                this.sendOfflineMessage(this.testClass + "_" + this.instanceNumber);
            }
        }
    }

    private void sendOfflineMessage(String testName) {
        OfflineMessage offlineMsg = new OfflineMessage(testName);
        this.sendMessage(offlineMsg);
    }

    private TestResult executeTestSuite(TestSuite suite) {
        log.debug((Object)"About to run test runner on test suite.");
        TestResult result = TestRunner.run((Test)suite);
        log.debug((Object)("Ran tests.  Result = " + result + ".  Result failure count = " + result.failureCount()));
        return result;
    }

    private void sendTowrnDownMessage() {
        TornDownMessage tornDownMsg = new TornDownMessage(this.getTestClassName());
        this.sendMessage(tornDownMsg);
    }

    private String getTestClassName() {
        return this.testClass + "_" + this.instanceNumber;
    }

    private void waitForRunMessage() throws TestRunLockTimeOutException {
        boolean gotRunTests = false;
        try {
            gotRunTests = runTestsLock.attempt(this.runTestsTimeout);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        log.debug((Object)("Got run test message: " + gotRunTests));
        if (!gotRunTests) {
            throw new TestRunLockTimeOutException();
        }
    }

    private void waitForTearDownMessage() throws TearDownTimeOutException {
        boolean gotTearDown = false;
        try {
            gotTearDown = tearDownLock.attempt(this.tearDownTimeout);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        log.debug((Object)("Got tear down message: " + gotTearDown));
        if (!gotTearDown) {
            throw new TearDownTimeOutException();
        }
    }

    private void sendStartupMessage(boolean areServerTests) {
        StartupMessage startupMsg = new StartupMessage(this.getTestClassName(), areServerTests);
        this.sendMessage(startupMsg);
    }

    private void sendResultMessage(TestResult result) {
        ResultMessage resultMsg = new ResultMessage(this.getTestClassName(), result);
        log.debug((Object)("Sending result message - " + resultMsg));
        this.resultId = resultMsg.getId();
        this.sendMessage(resultMsg);
        log.debug((Object)("Sent result message - " + resultMsg));
        log.debug((Object)"Wait to receive result");
        boolean gotResult = false;
        try {
            resultsLock.attempt(this.resultsTimeout);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        log.debug((Object)(gotResult ? "Got" : "Did NOT get  result message for id " + this.resultId));
    }

    private void sendServerResultMessage(TestResult result) {
        ServerResultMessage resultMsg = new ServerResultMessage(this.getTestClassName(), result);
        log.debug((Object)("Sending server result message - " + resultMsg));
        this.resultId = resultMsg.getId();
        this.sendMessage(resultMsg);
        log.debug((Object)("Sent server result message - " + resultMsg));
        log.debug((Object)"Wait to receive result");
        boolean gotResult = false;
        try {
            resultsLock.attempt(this.resultsTimeout);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        log.debug((Object)(gotResult ? "Got" : "Did NOT get  result message for id " + this.resultId));
    }

    private void sendErrorMessage(Throwable thr) {
        ExceptionMessage exMsg = new ExceptionMessage(this.getTestClassName(), thr);
        this.sendMessage(exMsg);
    }

    private void sendMessage(Serializable msg) {
        this.bus.sendMessage(msg);
    }

    private void initCommChannel() throws Exception {
        this.bus = new MessageBus();
        this.bus.addReceiver(this);
        this.bus.start();
        log.debug((Object)"Comm channel started.");
    }

    public void handleRemoteDataMessage(Object message) {
    }

    public void handleRemoteTestMessage(RemoteTestMessage message) {
        if (message instanceof RunTestMessage) {
            log.debug((Object)"Received run test message.");
            runTestsLock.release();
        } else if (message instanceof TearDownMessage) {
            log.debug((Object)"Received tear down message.");
            tearDownLock.release();
        } else if (message instanceof AbortMessage) {
            log.error((Object)"Got abort message.  Killing process.");
            System.exit(16);
        } else if (message instanceof ResultMessage) {
            log.debug((Object)("Received ResultMessage: " + message + " and looking for id that matches " + this.resultId));
            String id = ((ResultMessage)message).getId();
            if (id.equals(this.resultId)) {
                log.debug((Object)"Ids match, releasing results lock.");
                resultsLock.release();
            }
        } else {
            log.debug((Object)("Received message: " + message.getClass().getName()));
        }
    }

    public static void main(String[] args) {
        if (args.length < 4) {
            System.err.println("Must have test class, number of the test, test log level and test harness log level passed as argument to ServerTestHarness.");
            System.err.println("Example argumetns would be: \norg.jboss.jrunit.sample.remote.SimpleClientTest 2 DEBUG ERROR");
            System.exit(10);
        } else {
            String testClass = args[0];
            int num = 0;
            try {
                num = Integer.parseInt(args[1]);
            }
            catch (NumberFormatException nfex) {
                // empty catch block
            }
            String testLogLevel = args[2];
            String testHarnessLogLevel = args[3];
            long tearDownTimeout = 360000L;
            long runTestTimeout = 60000L;
            if (args.length == 6) {
                try {
                    tearDownTimeout = Long.parseLong(args[4]);
                    runTestTimeout = Long.parseLong(args[5]);
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
            BasicConfigurator.configure();
            Category.getRoot().setLevel(XLevel.toLevel((String)testLogLevel));
            Category.getInstance((String)"org.jboss.jrunit").setLevel(Level.toLevel((String)testHarnessLogLevel));
            Category.getInstance((String)"org.jgroups").setLevel(Level.FATAL);
            String pattern = "%d %-5p @%t [%c{1}] %m%n";
            PatternLayout layout = new PatternLayout(pattern);
            ConsoleAppender consoleAppender = new ConsoleAppender((Layout)layout);
            Category.getRoot().addAppender((Appender)consoleAppender);
            try {
                String logDirectory = System.getProperty("jrunit.logdir", ".");
                File logFile = new File(logDirectory + File.separator + "test_logs");
                logFile.mkdir();
                FileAppender fileAppender = new FileAppender((Layout)layout, logFile.getPath() + File.separator + testClass + "_" + num + "_output.log");
                fileAppender.setAppend(false);
                Category.getRoot().addAppender((Appender)fileAppender);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            int finalNum = num;
            try {
                ServerTestHarness testHarness = new ServerTestHarness(testClass, finalNum);
                testHarness.setTearDownTimeout(tearDownTimeout);
                testHarness.setRunTestTimeout(runTestTimeout);
                testHarness.runTests();
                Thread.currentThread();
                Thread.sleep(3000L);
                testHarness.shutdown();
            }
            catch (TestRunException tre) {
                System.exit(13);
            }
            catch (TestCreationException tce) {
                System.exit(12);
            }
            catch (Exception e) {
                System.exit(11);
            }
            catch (TestInitializationException e) {
                System.exit(14);
            }
            catch (TestCleanupException e) {
                System.exit(15);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

