/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.samples.detection.jndi;

import java.net.InetAddress;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.ServerInvocationHandler;
import org.jboss.remoting.ServerInvoker;
import org.jboss.remoting.callback.InvokerCallbackHandler;
import org.jboss.remoting.detection.jndi.JNDIDetector;
import org.jboss.remoting.transport.Connector;

public class SimpleDetectorServer {
    protected static String transport = "socket";
    protected static String host = "localhost";
    protected static int port = 5400;
    private int detectorPort = 1099;
    private String contextFactory = "org.jnp.interfaces.NamingContextFactory";
    private String urlPackage = "org.jboss.naming:org.jnp.interfaces";
    static /* synthetic */ Class class$org$jboss$remoting$samples$detection$jndi$SimpleDetectorServer;

    public void setupDetector() throws Exception {
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        String detectorHost = InetAddress.getLocalHost().getHostName();
        JNDIDetector detector = new JNDIDetector(this.getConfiguration());
        detector.setPort(this.detectorPort);
        detector.setHost(detectorHost);
        detector.setContextFactory(this.contextFactory);
        detector.setURLPackage(this.urlPackage);
        server.registerMBean(detector, new ObjectName("remoting:type=JNDIDetector"));
        detector.start();
        SimpleDetectorServer.println("JNDIDetector has been created and is listening for new NetworkRegistries to come online");
    }

    public void setupServer(String locatorURI) throws Exception {
        InvokerLocator locator = new InvokerLocator(locatorURI);
        SimpleDetectorServer.println("Starting remoting server with locator uri of: " + locatorURI);
        Connector connector = new Connector(this.getConfiguration());
        connector.setInvokerLocator(locator.getLocatorURI());
        connector.create();
        SampleInvocationHandler invocationHandler = new SampleInvocationHandler();
        connector.addInvocationHandler("sample", invocationHandler);
        SimpleDetectorServer.println("Added our invocation handler; we are now ready to begin accepting messages from clients");
        connector.start();
    }

    public static void main(String[] args) {
        SimpleDetectorServer.println("Starting JBoss/Remoting server... to stop this server, kill it manually via Control-C");
        String locatorURI = SimpleDetectorServer.getLocatorURI(args);
        SimpleDetectorServer.println("This server's endpoint will be: " + locatorURI);
        SimpleDetectorServer server = new SimpleDetectorServer();
        try {
            server.setupDetector();
            server.setupServer(locatorURI);
            while (true) {
                Thread.sleep(1000L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            SimpleDetectorServer.println("Stopping JBoss/Remoting server");
            return;
        }
    }

    public static void println(String msg) {
        System.out.println(new Date() + ": [SERVER]: " + msg);
    }

    protected static String getLocatorURI(String[] args) {
        String prop = System.getProperty("args");
        if (prop != null) {
            try {
                transport = prop.substring(0, prop.indexOf("-"));
                port = Integer.parseInt(prop.substring(prop.indexOf("-") + 1));
            }
            catch (NumberFormatException nfe) {
                SimpleDetectorServer.println("INVALID ARGUMENTS: Bad port from property args: " + prop);
                System.exit(1);
            }
            catch (Exception e) {
                SimpleDetectorServer.println("INVALID ARGUMENTS: -Dargs property must be in the form '{socket|rmi}-{port#}': " + prop);
                System.exit(1);
            }
        }
        if (args != null && args.length != 0) {
            if (args.length == 2) {
                transport = args[0];
                port = Integer.parseInt(args[1]);
            } else {
                SimpleDetectorServer.println("INVALID ARGUMENTS: Usage: " + (class$org$jboss$remoting$samples$detection$jndi$SimpleDetectorServer == null ? (class$org$jboss$remoting$samples$detection$jndi$SimpleDetectorServer = SimpleDetectorServer.class$("org.jboss.remoting.samples.detection.jndi.SimpleDetectorServer")) : class$org$jboss$remoting$samples$detection$jndi$SimpleDetectorServer).getName() + " [rmi|socket <port>]");
                System.exit(1);
            }
        }
        return transport + "://" + host + ":" + port;
    }

    protected Map getConfiguration() {
        return new HashMap();
    }

    protected SimpleDetectorServer getDetectorServer() {
        return new SimpleDetectorServer();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class SampleInvocationHandler
    implements ServerInvocationHandler {
        public Object invoke(InvocationRequest invocation) throws Throwable {
            String msg = invocation.getParameter().toString();
            SimpleDetectorServer.println("RECEIVED A CLIENT MESSAGE: " + msg);
            String response = "Server received your message that said [" + msg + "]";
            if (msg.indexOf("Welcome") > -1) {
                response = "Received your welcome message.  Thank you!";
            }
            SimpleDetectorServer.println("Returning the following message back to the client: " + response);
            return response;
        }

        public void addListener(InvokerCallbackHandler callbackHandler) {
        }

        public void removeListener(InvokerCallbackHandler callbackHandler) {
        }

        public void setMBeanServer(MBeanServer server) {
        }

        public void setInvoker(ServerInvoker invoker) {
        }
    }
}

