/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.jgroups.TimeoutException;
import org.jgroups.util.CondVar;
import org.jgroups.util.Util;

public class CondVarTest
extends TestCase {
    CondVar cond = new CondVar("blocking", Boolean.FALSE);

    public CondVarTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp();
    }

    public void tearDown() throws Exception {
        super.tearDown();
    }

    public void testConditionTrue() {
        try {
            this.cond.waitUntilWithTimeout(Boolean.FALSE, 500L);
        }
        catch (TimeoutException e) {
            CondVarTest.fail((String)"received TimeoutException");
        }
    }

    public void testConditionTrueWaitForever() {
        this.cond.waitUntil(Boolean.FALSE);
    }

    public void testWithTimeoutException() {
        try {
            this.cond.waitUntilWithTimeout(Boolean.TRUE, 500L);
            CondVarTest.fail((String)"expected timeout exception");
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    public void testWithResultSetter() throws TimeoutException {
        new ResultSetter(this.cond, 500L).start();
        this.cond.waitUntilWithTimeout(Boolean.TRUE, 2000L);
    }

    public void testWithResultSetter_ResultSetBeforeAccess() throws TimeoutException {
        new ResultSetter(this.cond, 10L).start();
        Util.sleep(100L);
        this.cond.waitUntilWithTimeout(Boolean.TRUE, 2000L);
    }

    public void testDoubleLocking() throws TimeoutException {
        final HashMap m = new HashMap();
        final CondVar c = new CondVar("bla", Boolean.FALSE, m);
        new Thread(){

            public void run() {
                Util.sleep(1000L);
                CondVarTest.this._setValue(m, c);
            }
        }.start();
        this._enterMonitor(m, c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _setValue(Map m, CondVar c) {
        this.log("acquiring m");
        Map map = m;
        synchronized (map) {
            this.log("acquired m. setting c");
            c.set(Boolean.TRUE);
            this.log("set c. released c");
        }
        this.log("released m");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _enterMonitor(Map m, CondVar c) throws TimeoutException {
        this.log("acquiring m");
        Map map = m;
        synchronized (map) {
            this.log("acquired m. acquiring and waiting on c");
            c.waitUntilWithTimeout(Boolean.TRUE, 10000L);
            this.log("released c");
        }
        this.log("released m");
    }

    private void log(String msg) {
        System.out.println(System.currentTimeMillis() + " " + Thread.currentThread() + " - " + msg);
    }

    public void testStressOnGet() {
        long NUM = 1000000L;
        long start = System.currentTimeMillis();
        int i = 0;
        while ((long)i < NUM) {
            if (this.cond.get().equals(Boolean.TRUE)) {
                // empty if block
            }
            ++i;
        }
        long stop = System.currentTimeMillis();
        long diff = stop - start;
        double microsecs_per_get = (double)(diff *= 1000L) / (double)NUM;
        System.out.println("took " + microsecs_per_get + " microsecs/get for " + NUM + " gets (" + diff + " microsecs)");
    }

    public static void main(String[] args) {
        String[] testCaseName = new String[]{CondVarTest.class.getName()};
        TestRunner.main((String[])testCaseName);
    }

    class ResultSetter
    extends Thread {
        long wait_time = 2000L;
        CondVar target = null;

        ResultSetter(CondVar target, long wait_time) {
            this.target = target;
            this.wait_time = wait_time;
        }

        public void run() {
            Util.sleep(this.wait_time);
            System.out.println("-- [ResultSetter] set result to true");
            this.target.set(Boolean.TRUE);
            System.out.println("-- [ResultSetter] set result to true -- DONE");
        }
    }
}

