/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.jgroups.TimeoutException;
import org.jgroups.View;
import org.jgroups.ViewId;
import org.jgroups.util.Promise;

public class AckCollector {
    private final List missing_acks;
    private final Set received_acks = new HashSet();
    private final Promise all_acks_received = new Promise();
    private ViewId proposed_view;
    private final Set suspected_mbrs = new HashSet();

    public AckCollector() {
        this.missing_acks = new ArrayList();
    }

    public AckCollector(ViewId v, List l) {
        this.missing_acks = new ArrayList(l);
        this.proposed_view = v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String printMissing() {
        AckCollector ackCollector = this;
        synchronized (ackCollector) {
            return this.missing_acks.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String printReceived() {
        AckCollector ackCollector = this;
        synchronized (ackCollector) {
            return this.received_acks.toString();
        }
    }

    public ViewId getViewId() {
        return this.proposed_view;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset(ViewId v, List l) {
        AckCollector ackCollector = this;
        synchronized (ackCollector) {
            this.suspected_mbrs.clear();
            this.proposed_view = v;
            this.missing_acks.clear();
            this.received_acks.clear();
            if (l != null) {
                this.missing_acks.addAll(l);
            }
            this.missing_acks.removeAll(this.suspected_mbrs);
            this.all_acks_received.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        AckCollector ackCollector = this;
        synchronized (ackCollector) {
            return this.missing_acks.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ack(Object member) {
        AckCollector ackCollector = this;
        synchronized (ackCollector) {
            this.missing_acks.remove(member);
            this.received_acks.add(member);
            if (this.missing_acks.size() == 0) {
                this.all_acks_received.setResult(Boolean.TRUE);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspect(Object member) {
        AckCollector ackCollector = this;
        synchronized (ackCollector) {
            this.ack(member);
            this.suspected_mbrs.add(member);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsuspect(Object member) {
        AckCollector ackCollector = this;
        synchronized (ackCollector) {
            this.suspected_mbrs.remove(member);
        }
    }

    public void handleView(View v) {
        if (v == null) {
            return;
        }
        Vector mbrs = v.getMembers();
        this.suspected_mbrs.retainAll(mbrs);
    }

    public boolean waitForAllAcks() {
        if (this.missing_acks.size() == 0) {
            return true;
        }
        Object result = this.all_acks_received.getResult();
        return result != null && result instanceof Boolean && (Boolean)result != false;
    }

    public boolean waitForAllAcks(long timeout) throws TimeoutException {
        if (this.missing_acks.size() == 0) {
            return true;
        }
        Object result = this.all_acks_received.getResultWithTimeout(timeout);
        return result != null && result instanceof Boolean && (Boolean)result != false;
    }

    public String toString() {
        return "missing=" + this.printMissing() + ", received=" + this.printReceived();
    }
}

