/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.quartz;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.Calendar;
import org.quartz.JobDetail;
import org.quartz.JobListener;
import org.quartz.ObjectAlreadyExistsException;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerFactory;
import org.quartz.SchedulerListener;
import org.quartz.Trigger;
import org.quartz.TriggerListener;
import org.quartz.impl.StdSchedulerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.NestedRuntimeException;
import org.springframework.core.io.Resource;
import org.springframework.scheduling.quartz.JobDetailAwareTrigger;
import org.springframework.scheduling.quartz.ResourceJobSchedulingDataProcessor;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.util.ReflectionUtils;

public class SchedulerFactoryBean
implements FactoryBean,
ApplicationContextAware,
InitializingBean,
DisposableBean {
    public static final String PROP_THREAD_COUNT = "org.quartz.threadPool.threadCount";
    public static final int DEFAULT_THREAD_COUNT = 10;
    private static ThreadLocal configTimeDataSourceHolder = new ThreadLocal();
    private static ThreadLocal configTimeNonTransactionalDataSourceHolder = new ThreadLocal();
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Class schedulerFactoryClass = class$org$quartz$impl$StdSchedulerFactory == null ? (class$org$quartz$impl$StdSchedulerFactory = SchedulerFactoryBean.class$("org.quartz.impl.StdSchedulerFactory")) : class$org$quartz$impl$StdSchedulerFactory;
    private String schedulerName;
    private Resource configLocation;
    private Properties quartzProperties;
    private DataSource dataSource;
    private DataSource nonTransactionalDataSource;
    private PlatformTransactionManager transactionManager;
    private Map schedulerContextMap;
    private ApplicationContext applicationContext;
    private String applicationContextSchedulerContextKey;
    private boolean overwriteExistingJobs = false;
    private String[] jobSchedulingDataLocations;
    private List jobDetails;
    private Map calendars;
    private List triggers;
    private SchedulerListener[] schedulerListeners;
    private JobListener[] globalJobListeners;
    private JobListener[] jobListeners;
    private TriggerListener[] globalTriggerListeners;
    private TriggerListener[] triggerListeners;
    private boolean autoStartup = true;
    private int startupDelay = 0;
    private boolean waitForJobsToCompleteOnShutdown = false;
    private Scheduler scheduler;
    static /* synthetic */ Class class$org$quartz$impl$StdSchedulerFactory;
    static /* synthetic */ Class class$org$quartz$SchedulerFactory;
    static /* synthetic */ Class class$org$quartz$simpl$SimpleThreadPool;
    static /* synthetic */ Class class$org$springframework$scheduling$quartz$LocalDataSourceJobStore;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$quartz$Calendar;
    static /* synthetic */ Class class$org$quartz$Scheduler;

    public static DataSource getConfigTimeDataSource() {
        return (DataSource)configTimeDataSourceHolder.get();
    }

    public static DataSource getConfigTimeNonTransactionalDataSource() {
        return (DataSource)configTimeNonTransactionalDataSourceHolder.get();
    }

    public void setSchedulerFactoryClass(Class schedulerFactoryClass) {
        if (schedulerFactoryClass == null || !(class$org$quartz$SchedulerFactory == null ? (class$org$quartz$SchedulerFactory = SchedulerFactoryBean.class$("org.quartz.SchedulerFactory")) : class$org$quartz$SchedulerFactory).isAssignableFrom(schedulerFactoryClass)) {
            throw new IllegalArgumentException("schedulerFactoryClass must implement [org.quartz.SchedulerFactory]");
        }
        this.schedulerFactoryClass = schedulerFactoryClass;
    }

    public void setSchedulerName(String schedulerName) {
        this.schedulerName = schedulerName;
    }

    public void setConfigLocation(Resource configLocation) {
        this.configLocation = configLocation;
    }

    public void setQuartzProperties(Properties quartzProperties) {
        this.quartzProperties = quartzProperties;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setNonTransactionalDataSource(DataSource nonTransactionalDataSource) {
        this.nonTransactionalDataSource = nonTransactionalDataSource;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public void setSchedulerContextAsMap(Map schedulerContextAsMap) {
        this.schedulerContextMap = schedulerContextAsMap;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setApplicationContextSchedulerContextKey(String applicationContextSchedulerContextKey) {
        this.applicationContextSchedulerContextKey = applicationContextSchedulerContextKey;
    }

    public void setOverwriteExistingJobs(boolean overwriteExistingJobs) {
        this.overwriteExistingJobs = overwriteExistingJobs;
    }

    public void setJobSchedulingDataLocation(String jobSchedulingDataLocation) {
        this.jobSchedulingDataLocations = new String[]{jobSchedulingDataLocation};
    }

    public void setJobSchedulingDataLocations(String[] jobSchedulingDataLocations) {
        this.jobSchedulingDataLocations = jobSchedulingDataLocations;
    }

    public void setJobDetails(JobDetail[] jobDetails) {
        this.jobDetails = new ArrayList<JobDetail>(Arrays.asList(jobDetails));
    }

    public void setCalendars(Map calendars) {
        this.calendars = calendars;
    }

    public void setTriggers(Trigger[] triggers) {
        this.triggers = Arrays.asList(triggers);
    }

    public void setSchedulerListeners(SchedulerListener[] schedulerListeners) {
        this.schedulerListeners = schedulerListeners;
    }

    public void setGlobalJobListeners(JobListener[] globalJobListeners) {
        this.globalJobListeners = globalJobListeners;
    }

    public void setJobListeners(JobListener[] jobListeners) {
        this.jobListeners = jobListeners;
    }

    public void setGlobalTriggerListeners(TriggerListener[] globalTriggerListeners) {
        this.globalTriggerListeners = globalTriggerListeners;
    }

    public void setTriggerListeners(TriggerListener[] triggerListeners) {
        this.triggerListeners = triggerListeners;
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public void setStartupDelay(int startupDelay) {
        this.startupDelay = startupDelay;
    }

    public void setWaitForJobsToCompleteOnShutdown(boolean waitForJobsToCompleteOnShutdown) {
        this.waitForJobsToCompleteOnShutdown = waitForJobsToCompleteOnShutdown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterPropertiesSet() throws Exception {
        SchedulerFactory schedulerFactory = (SchedulerFactory)BeanUtils.instantiateClass(this.schedulerFactoryClass);
        this.initSchedulerFactory(schedulerFactory);
        if (this.dataSource != null) {
            configTimeDataSourceHolder.set(this.dataSource);
        }
        if (this.nonTransactionalDataSource != null) {
            configTimeNonTransactionalDataSourceHolder.set(this.nonTransactionalDataSource);
        }
        try {
            this.scheduler = this.createScheduler(schedulerFactory, this.schedulerName);
        }
        finally {
            if (this.dataSource != null) {
                configTimeDataSourceHolder.set(null);
            }
            if (this.nonTransactionalDataSource != null) {
                configTimeNonTransactionalDataSourceHolder.set(null);
            }
        }
        this.populateSchedulerContext();
        this.registerListeners();
        this.registerJobsAndTriggers();
        if (this.autoStartup) {
            this.startScheduler(this.scheduler, this.startupDelay);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initSchedulerFactory(SchedulerFactory schedulerFactory) throws SchedulerException, IOException {
        if (this.configLocation != null || this.quartzProperties != null || this.dataSource != null || this.schedulerName != null) {
            if (!(schedulerFactory instanceof StdSchedulerFactory)) {
                throw new IllegalArgumentException("StdSchedulerFactory required for applying Quartz properties");
            }
            Properties props = new Properties();
            props.setProperty("org.quartz.threadPool.class", (class$org$quartz$simpl$SimpleThreadPool == null ? (class$org$quartz$simpl$SimpleThreadPool = SchedulerFactoryBean.class$("org.quartz.simpl.SimpleThreadPool")) : class$org$quartz$simpl$SimpleThreadPool).getName());
            props.setProperty(PROP_THREAD_COUNT, Integer.toString(10));
            if (this.configLocation != null) {
                InputStream is = this.configLocation.getInputStream();
                try {
                    props.load(is);
                }
                finally {
                    is.close();
                }
            }
            if (this.quartzProperties != null) {
                Enumeration<?> en = this.quartzProperties.propertyNames();
                while (en.hasMoreElements()) {
                    String key = (String)en.nextElement();
                    props.setProperty(key, this.quartzProperties.getProperty(key));
                }
            }
            if (this.dataSource != null) {
                props.put("org.quartz.jobStore.class", (class$org$springframework$scheduling$quartz$LocalDataSourceJobStore == null ? (class$org$springframework$scheduling$quartz$LocalDataSourceJobStore = SchedulerFactoryBean.class$("org.springframework.scheduling.quartz.LocalDataSourceJobStore")) : class$org$springframework$scheduling$quartz$LocalDataSourceJobStore).getName());
            }
            if (this.schedulerName != null) {
                props.put("org.quartz.scheduler.instanceName", this.schedulerName);
            }
            ((StdSchedulerFactory)schedulerFactory).initialize(props);
        }
    }

    protected Scheduler createScheduler(SchedulerFactory schedulerFactory, String schedulerName) throws SchedulerException {
        return schedulerFactory.getScheduler();
    }

    private void populateSchedulerContext() throws SchedulerException {
        if (this.schedulerContextMap != null) {
            this.scheduler.getContext().putAll(this.schedulerContextMap);
        }
        if (this.applicationContextSchedulerContextKey != null) {
            if (this.applicationContext == null) {
                throw new IllegalStateException("SchedulerFactoryBean needs to be set up in an ApplicationContext to be able to handle an 'applicationContextSchedulerContextKey'");
            }
            this.scheduler.getContext().put((Object)this.applicationContextSchedulerContextKey, (Object)this.applicationContext);
        }
    }

    private void registerListeners() throws SchedulerException {
        int i;
        if (this.schedulerListeners != null) {
            for (i = 0; i < this.schedulerListeners.length; ++i) {
                this.scheduler.addSchedulerListener(this.schedulerListeners[i]);
            }
        }
        if (this.globalJobListeners != null) {
            for (i = 0; i < this.globalJobListeners.length; ++i) {
                this.scheduler.addGlobalJobListener(this.globalJobListeners[i]);
            }
        }
        if (this.jobListeners != null) {
            for (i = 0; i < this.jobListeners.length; ++i) {
                this.scheduler.addJobListener(this.jobListeners[i]);
            }
        }
        if (this.globalTriggerListeners != null) {
            for (i = 0; i < this.globalTriggerListeners.length; ++i) {
                this.scheduler.addGlobalTriggerListener(this.globalTriggerListeners[i]);
            }
        }
        if (this.triggerListeners != null) {
            for (i = 0; i < this.triggerListeners.length; ++i) {
                this.scheduler.addTriggerListener(this.triggerListeners[i]);
            }
        }
    }

    private void registerJobsAndTriggers() throws SchedulerException {
        TransactionStatus transactionStatus = null;
        if (this.transactionManager != null) {
            transactionStatus = this.transactionManager.getTransaction(new DefaultTransactionDefinition());
        }
        try {
            Iterator<Object> it;
            if (this.jobSchedulingDataLocations != null) {
                ResourceJobSchedulingDataProcessor dataProcessor = new ResourceJobSchedulingDataProcessor();
                if (this.applicationContext != null) {
                    dataProcessor.setResourceLoader(this.applicationContext);
                }
                for (int i = 0; i < this.jobSchedulingDataLocations.length; ++i) {
                    dataProcessor.processFileAndScheduleJobs(this.jobSchedulingDataLocations[i], this.scheduler, this.overwriteExistingJobs);
                }
            }
            if (this.jobDetails != null) {
                it = this.jobDetails.iterator();
                while (it.hasNext()) {
                    JobDetail jobDetail = (JobDetail)it.next();
                    this.addJobToScheduler(jobDetail);
                }
            } else {
                this.jobDetails = new LinkedList();
            }
            if (this.calendars != null) {
                it = this.calendars.keySet().iterator();
                while (it.hasNext()) {
                    String calendarName = (String)it.next();
                    Calendar calendar = (Calendar)this.calendars.get(calendarName);
                    this.addCalendarToScheduler(calendarName, calendar);
                }
            }
            if (this.triggers != null) {
                it = this.triggers.iterator();
                while (it.hasNext()) {
                    Trigger trigger = (Trigger)it.next();
                    this.addTriggerToScheduler(trigger);
                }
            }
        }
        catch (Throwable ex) {
            if (transactionStatus != null) {
                try {
                    this.transactionManager.rollback(transactionStatus);
                }
                catch (TransactionException tex) {
                    this.logger.error((Object)"Job registration exception overridden by rollback exception", ex);
                    throw tex;
                }
            }
            if (ex instanceof SchedulerException) {
                throw (SchedulerException)ex;
            }
            if (ex instanceof Exception) {
                throw new SchedulerException("Registration of jobs and triggers failed: " + ex.getMessage(), (Exception)ex);
            }
            throw new SchedulerException("Registration of jobs and triggers failed: " + ex.getMessage());
        }
        if (transactionStatus != null) {
            this.transactionManager.commit(transactionStatus);
        }
    }

    private boolean addJobToScheduler(JobDetail jobDetail) throws SchedulerException {
        if (this.overwriteExistingJobs || this.scheduler.getJobDetail(jobDetail.getName(), jobDetail.getGroup()) == null) {
            this.scheduler.addJob(jobDetail, true);
            return true;
        }
        return false;
    }

    private void addCalendarToScheduler(String calendarName, Calendar calendar) throws SchedulerException {
        try {
            try {
                Method addCalendarMethod = this.scheduler.getClass().getMethod("addCalendar", class$java$lang$String == null ? (class$java$lang$String = SchedulerFactoryBean.class$("java.lang.String")) : class$java$lang$String, class$org$quartz$Calendar == null ? (class$org$quartz$Calendar = SchedulerFactoryBean.class$("org.quartz.Calendar")) : class$org$quartz$Calendar, Boolean.TYPE, Boolean.TYPE);
                addCalendarMethod.invoke((Object)this.scheduler, calendarName, calendar, Boolean.TRUE, Boolean.TRUE);
            }
            catch (NoSuchMethodException ex) {
                Method addCalendarMethod = this.scheduler.getClass().getMethod("addCalendar", class$java$lang$String == null ? (class$java$lang$String = SchedulerFactoryBean.class$("java.lang.String")) : class$java$lang$String, class$org$quartz$Calendar == null ? (class$org$quartz$Calendar = SchedulerFactoryBean.class$("org.quartz.Calendar")) : class$org$quartz$Calendar, Boolean.TYPE);
                addCalendarMethod.invoke((Object)this.scheduler, calendarName, calendar, Boolean.TRUE);
            }
        }
        catch (InvocationTargetException ex) {
            if (ex.getTargetException() instanceof SchedulerException) {
                throw (SchedulerException)ex.getTargetException();
            }
            ReflectionUtils.handleInvocationTargetException(ex);
        }
        catch (Exception ex) {
            ReflectionUtils.handleReflectionException(ex);
        }
    }

    private boolean addTriggerToScheduler(Trigger trigger) throws SchedulerException {
        boolean triggerExists;
        boolean bl = triggerExists = this.scheduler.getTrigger(trigger.getName(), trigger.getGroup()) != null;
        if (!triggerExists || this.overwriteExistingJobs) {
            JobDetail jobDetail;
            if (trigger instanceof JobDetailAwareTrigger && !this.jobDetails.contains(jobDetail = ((JobDetailAwareTrigger)trigger).getJobDetail()) && this.addJobToScheduler(jobDetail)) {
                this.jobDetails.add(jobDetail);
            }
            if (!triggerExists) {
                try {
                    this.scheduler.scheduleJob(trigger);
                }
                catch (ObjectAlreadyExistsException ex) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Unexpectedly found existing trigger, assumably due to cluster race condition: " + ex.getMessage() + " - can safely be ignored"));
                    }
                    if (this.overwriteExistingJobs) {
                        this.scheduler.rescheduleJob(trigger.getName(), trigger.getGroup(), trigger);
                    }
                }
            } else {
                this.scheduler.rescheduleJob(trigger.getName(), trigger.getGroup(), trigger);
            }
            return true;
        }
        return false;
    }

    protected void startScheduler(final Scheduler scheduler, final int startupDelay) throws SchedulerException {
        if (startupDelay <= 0) {
            this.logger.info((Object)"Starting Quartz scheduler now");
            scheduler.start();
        } else {
            this.logger.info((Object)("Will start Quartz scheduler in " + startupDelay + " seconds"));
            new Thread(){

                public void run() {
                    try {
                        Thread.sleep(startupDelay * 1000);
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
                    SchedulerFactoryBean.this.logger.info((Object)("Starting Quartz scheduler now, after delay of " + startupDelay + " seconds"));
                    try {
                        scheduler.start();
                    }
                    catch (SchedulerException ex) {
                        throw new DelayedSchedulerStartException(ex);
                    }
                }
            }.start();
        }
    }

    public Object getObject() {
        return this.scheduler;
    }

    public Class getObjectType() {
        return this.scheduler != null ? this.scheduler.getClass() : (class$org$quartz$Scheduler == null ? (class$org$quartz$Scheduler = SchedulerFactoryBean.class$("org.quartz.Scheduler")) : class$org$quartz$Scheduler);
    }

    public boolean isSingleton() {
        return true;
    }

    public void destroy() throws SchedulerException {
        this.logger.info((Object)"Shutting down Quartz scheduler");
        this.scheduler.shutdown(this.waitForJobsToCompleteOnShutdown);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class DelayedSchedulerStartException
    extends NestedRuntimeException {
        private DelayedSchedulerStartException(SchedulerException ex) {
            super("Could not start Quartz scheduler after delay", ex);
        }
    }
}

