/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.io.aelfred;

import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import org.dom4j.io.aelfred.DefaultHandler;
import org.dom4j.io.aelfred.XmlParser;
import org.xml.sax.AttributeList;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.NamespaceSupport;

public final class SAXDriver
implements Locator,
Attributes,
XMLReader,
Parser,
AttributeList {
    private final DefaultHandler base = new DefaultHandler();
    private XmlParser parser;
    private EntityResolver entityResolver = this.base;
    private ContentHandler contentHandler = this.base;
    private DTDHandler dtdHandler = this.base;
    private ErrorHandler errorHandler = this.base;
    private DeclHandler declHandler = this.base;
    private LexicalHandler lexicalHandler = this.base;
    private String elementName = null;
    private ArrayList entityStack = new ArrayList();
    private ArrayList attributeNames = new ArrayList();
    private ArrayList attributeNamespaces = new ArrayList();
    private ArrayList attributeLocalNames = new ArrayList();
    private ArrayList attributeValues = new ArrayList();
    private boolean namespaces = true;
    private boolean xmlNames = false;
    private boolean nspending = false;
    private int attributeCount = 0;
    private String[] nsTemp = new String[3];
    private NamespaceSupport prefixStack = new NamespaceSupport();
    private HashMap features;
    private HashMap properties;
    static final String FEATURE = "http://xml.org/sax/features/";
    static final String HANDLER = "http://xml.org/sax/properties/";

    public void setLocale(Locale locale) throws SAXException {
        if ("en".equals(locale.getLanguage())) {
            return;
        }
        throw new SAXException("AElfred only supports English locales.");
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public void setEntityResolver(EntityResolver resolver) {
        if (resolver == null) {
            resolver = this.base;
        }
        this.entityResolver = resolver;
    }

    public DTDHandler getDTDHandler() {
        return this.dtdHandler;
    }

    public void setDTDHandler(DTDHandler handler) {
        if (handler == null) {
            handler = this.base;
        }
        this.dtdHandler = handler;
    }

    public void setDocumentHandler(DocumentHandler handler) {
        this.contentHandler = new Adapter(handler);
        this.xmlNames = true;
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public void setContentHandler(ContentHandler handler) {
        if (handler == null) {
            handler = this.base;
        }
        this.contentHandler = handler;
    }

    public void setErrorHandler(ErrorHandler handler) {
        if (handler == null) {
            handler = this.base;
        }
        this.errorHandler = handler;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(InputSource source) throws SAXException, IOException {
        DefaultHandler defaultHandler = this.base;
        synchronized (defaultHandler) {
            this.parser = new XmlParser();
            this.parser.setHandler(this);
            try {
                String systemId = source.getSystemId();
                if (systemId != null) {
                    this.entityStack.add(systemId);
                } else {
                    this.entityStack.add("illegal:unknown system ID");
                }
                this.parser.doParse(systemId, source.getPublicId(), source.getCharacterStream(), source.getByteStream(), source.getEncoding());
            }
            catch (SAXException e) {
                throw e;
            }
            catch (IOException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SAXException(e.getMessage(), e);
            }
            finally {
                this.contentHandler.endDocument();
                this.entityStack.clear();
            }
        }
    }

    public void parse(String systemId) throws SAXException, IOException {
        this.parse(new InputSource(systemId));
    }

    public boolean getFeature(String featureId) throws SAXNotRecognizedException {
        if ("http://xml.org/sax/features/validation".equals(featureId)) {
            return false;
        }
        if ("http://xml.org/sax/features/external-general-entities".equals(featureId) || "http://xml.org/sax/features/external-parameter-entities".equals(featureId)) {
            return true;
        }
        if ("http://xml.org/sax/features/namespace-prefixes".equals(featureId)) {
            return this.xmlNames;
        }
        if ("http://xml.org/sax/features/namespaces".equals(featureId)) {
            return this.namespaces;
        }
        if ("http://xml.org/sax/features/string-interning".equals(featureId)) {
            return true;
        }
        if (this.features != null && this.features.containsKey(featureId)) {
            return (Boolean)this.features.get(featureId);
        }
        throw new SAXNotRecognizedException(featureId);
    }

    public Object getProperty(String propertyId) throws SAXNotRecognizedException {
        if ("http://xml.org/sax/properties/declaration-handler".equals(propertyId)) {
            return this.declHandler;
        }
        if ("http://xml.org/sax/properties/lexical-handler".equals(propertyId)) {
            return this.lexicalHandler;
        }
        if (this.properties != null && this.properties.containsKey(propertyId)) {
            return this.properties.get(propertyId);
        }
        throw new SAXNotRecognizedException(propertyId);
    }

    public void setFeature(String featureId, boolean state) throws SAXNotRecognizedException, SAXNotSupportedException {
        block6: {
            try {
                boolean value = this.getFeature(featureId);
                if (state == value) {
                    return;
                }
                if ("http://xml.org/sax/features/namespace-prefixes".equals(featureId)) {
                    this.xmlNames = state;
                    return;
                }
                if ("http://xml.org/sax/features/namespaces".equals(featureId)) {
                    this.namespaces = state;
                    return;
                }
                if (this.features == null || !this.features.containsKey(featureId)) {
                    throw new SAXNotSupportedException(featureId);
                }
            }
            catch (SAXNotRecognizedException e) {
                if (this.features != null) break block6;
                this.features = new HashMap(5);
            }
        }
        this.features.put(featureId, state ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setProperty(String propertyId, Object property) throws SAXNotRecognizedException, SAXNotSupportedException {
        block11: {
            try {
                Object value = this.getProperty(propertyId);
                if ("http://xml.org/sax/properties/declaration-handler".equals(propertyId)) {
                    if (property == null) {
                        this.declHandler = this.base;
                    } else {
                        if (!(property instanceof DeclHandler)) {
                            throw new SAXNotSupportedException(propertyId);
                        }
                        this.declHandler = (DeclHandler)property;
                    }
                    return;
                }
                if ("http://xml.org/sax/properties/lexical-handler".equals(propertyId)) {
                    if (property == null) {
                        this.lexicalHandler = this.base;
                    } else {
                        if (!(property instanceof LexicalHandler)) {
                            throw new SAXNotSupportedException(propertyId);
                        }
                        this.lexicalHandler = (LexicalHandler)property;
                    }
                    return;
                }
                if (this.properties == null || !this.properties.containsKey(propertyId)) {
                    throw new SAXNotSupportedException(propertyId);
                }
            }
            catch (SAXNotRecognizedException e) {
                if (this.properties != null) break block11;
                this.properties = new HashMap(5);
            }
        }
        this.properties.put(propertyId, property);
    }

    void startDocument() throws SAXException {
        this.contentHandler.setDocumentLocator(this);
        this.contentHandler.startDocument();
        this.attributeNames.clear();
        this.attributeValues.clear();
    }

    void endDocument() throws SAXException {
    }

    Object resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        InputSource source = this.entityResolver.resolveEntity(publicId, systemId);
        if (source == null) {
            return null;
        }
        if (source.getCharacterStream() != null) {
            return source.getCharacterStream();
        }
        if (source.getByteStream() != null) {
            if (source.getEncoding() == null) {
                return source.getByteStream();
            }
            try {
                return new InputStreamReader(source.getByteStream(), source.getEncoding());
            }
            catch (IOException e) {
                return source.getByteStream();
            }
        }
        return source.getSystemId();
    }

    void startExternalEntity(String systemId) throws SAXException {
        this.entityStack.add(systemId);
    }

    void endExternalEntity(String systemId) throws SAXException {
        this.entityStack.remove(this.entityStack.size() - 1);
    }

    void doctypeDecl(String name, String publicId, String systemId) throws SAXException {
        this.lexicalHandler.startDTD(name, publicId, systemId);
    }

    void endDoctype() throws SAXException {
        this.deliverDTDEvents();
        this.lexicalHandler.endDTD();
    }

    void attribute(String aname, String value, boolean isSpecified) throws SAXException {
        if (this.attributeCount++ == 0 && this.namespaces) {
            this.prefixStack.pushContext();
        }
        if (value != null) {
            if (this.namespaces) {
                int index = aname.indexOf(58);
                if (index > 0) {
                    if (index == 5 && aname.startsWith("xmlns")) {
                        String prefix = aname.substring(index + 1);
                        if (value.length() == 0) {
                            this.errorHandler.error(new SAXParseException("missing URI in namespace decl attribute: " + aname, this));
                        } else {
                            this.prefixStack.declarePrefix(prefix, value);
                            this.contentHandler.startPrefixMapping(prefix, value);
                        }
                        if (!this.xmlNames) {
                            return;
                        }
                        this.nsTemp[0] = "";
                        this.nsTemp[1] = aname;
                    } else if (this.prefixStack.processName(aname, this.nsTemp, true) == null) {
                        this.nsTemp[0] = "";
                        this.nsTemp[1] = aname;
                        this.nspending = true;
                    }
                } else {
                    if ("xmlns".equals(aname)) {
                        this.prefixStack.declarePrefix("", value);
                        this.contentHandler.startPrefixMapping("", value);
                        if (!this.xmlNames) {
                            return;
                        }
                    }
                    this.nsTemp[0] = "";
                    this.nsTemp[1] = aname;
                }
            } else {
                this.nsTemp[1] = "";
                this.nsTemp[0] = "";
            }
            this.attributeNamespaces.add(this.nsTemp[0]);
            this.attributeLocalNames.add(this.nsTemp[1]);
            this.attributeNames.add(aname);
            this.attributeValues.add(value);
        }
    }

    void startElement(String elname) throws SAXException {
        ContentHandler handler = this.contentHandler;
        if (this.attributeCount == 0) {
            this.prefixStack.pushContext();
        }
        this.elementName = elname;
        if (this.namespaces) {
            if (this.attributeCount > 0 && this.nspending) {
                for (int i = 0; i < this.attributeLocalNames.size(); ++i) {
                    String aname = (String)this.attributeLocalNames.get(i);
                    if (aname.indexOf(58) <= 0) continue;
                    if (this.prefixStack.processName(aname, this.nsTemp, true) == null) {
                        this.errorHandler.error(new SAXParseException("undeclared name prefix in: " + aname, this));
                        continue;
                    }
                    this.attributeNamespaces.set(i, this.nsTemp[0]);
                    this.attributeLocalNames.set(i, this.nsTemp[1]);
                }
            }
            if (this.prefixStack.processName(elname, this.nsTemp, false) == null) {
                this.errorHandler.error(new SAXParseException("undeclared name prefix in: " + elname, this));
                this.nsTemp[1] = "";
                this.nsTemp[0] = "";
            }
            handler.startElement(this.nsTemp[0], this.nsTemp[1], elname, this);
        } else {
            handler.startElement("", "", elname, this);
        }
        if (this.attributeCount != 0) {
            this.attributeNames.clear();
            this.attributeNamespaces.clear();
            this.attributeLocalNames.clear();
            this.attributeValues.clear();
            this.attributeCount = 0;
        }
        this.nspending = false;
    }

    void endElement(String elname) throws SAXException {
        ContentHandler handler = this.contentHandler;
        handler.endElement("", "", elname);
        if (!this.namespaces) {
            return;
        }
        Enumeration prefixes = this.prefixStack.getDeclaredPrefixes();
        while (prefixes.hasMoreElements()) {
            handler.endPrefixMapping((String)prefixes.nextElement());
        }
        this.prefixStack.popContext();
    }

    void startCDATA() throws SAXException {
        this.lexicalHandler.startCDATA();
    }

    void charData(char[] ch, int start, int length) throws SAXException {
        this.contentHandler.characters(ch, start, length);
    }

    void endCDATA() throws SAXException {
        this.lexicalHandler.endCDATA();
    }

    void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.contentHandler.ignorableWhitespace(ch, start, length);
    }

    void processingInstruction(String target, String data) throws SAXException {
        this.contentHandler.processingInstruction(target, data);
    }

    void comment(char[] ch, int start, int length) throws SAXException {
        if (this.lexicalHandler != this.base) {
            this.lexicalHandler.comment(ch, start, length);
        }
    }

    void error(String message, String url, int line, int column) throws SAXException {
        SAXParseException fatal = new SAXParseException(message, null, url, line, column);
        this.errorHandler.fatalError(fatal);
        throw fatal;
    }

    private void deliverDTDEvents() throws SAXException {
        String ename;
        String systemId;
        String publicId;
        String nname;
        if (this.dtdHandler != this.base) {
            Iterator notationNames = this.parser.declaredNotations();
            while (notationNames.hasNext()) {
                nname = (String)notationNames.next();
                publicId = this.parser.getNotationPublicId(nname);
                systemId = this.parser.getNotationSystemId(nname);
                this.dtdHandler.notationDecl(nname, publicId, systemId);
            }
        }
        if (this.dtdHandler != this.base || this.declHandler != this.base) {
            Iterator entityNames = this.parser.declaredEntities();
            while (entityNames.hasNext()) {
                ename = (String)entityNames.next();
                int type = this.parser.getEntityType(ename);
                if (ename.charAt(0) == '%') continue;
                if (type == 2) {
                    publicId = this.parser.getEntityPublicId(ename);
                    systemId = this.parser.getEntitySystemId(ename);
                    nname = this.parser.getEntityNotationName(ename);
                    this.dtdHandler.unparsedEntityDecl(ename, publicId, systemId, nname);
                    continue;
                }
                if (type == 3) {
                    publicId = this.parser.getEntityPublicId(ename);
                    systemId = this.parser.getEntitySystemId(ename);
                    this.declHandler.externalEntityDecl(ename, publicId, systemId);
                    continue;
                }
                if (type != 1 || "lt".equals(ename) || "gt".equals(ename) || "quot".equals(ename) || "apos".equals(ename) || "amp".equals(ename)) continue;
                this.declHandler.internalEntityDecl(ename, this.parser.getEntityValue(ename));
            }
        }
        if (this.declHandler != this.base) {
            Iterator elementNames = this.parser.declaredElements();
            while (elementNames.hasNext()) {
                String model = null;
                ename = (String)elementNames.next();
                switch (this.parser.getElementContentType(ename)) {
                    case 1: {
                        model = "ANY";
                        break;
                    }
                    case 2: {
                        model = "EMPTY";
                        break;
                    }
                    case 3: 
                    case 4: {
                        model = this.parser.getElementContentModel(ename);
                        break;
                    }
                    default: {
                        model = null;
                    }
                }
                if (model != null) {
                    this.declHandler.elementDecl(ename, model);
                }
                Iterator attNames = this.parser.declaredAttributes(ename);
                while (attNames != null && attNames.hasNext()) {
                    String valueDefault;
                    String type;
                    String aname = (String)attNames.next();
                    switch (this.parser.getAttributeType(ename, aname)) {
                        case 1: {
                            type = "CDATA";
                            break;
                        }
                        case 5: {
                            type = "ENTITY";
                            break;
                        }
                        case 6: {
                            type = "ENTITIES";
                            break;
                        }
                        case 9: {
                            type = this.parser.getAttributeIterator(ename, aname);
                            break;
                        }
                        case 2: {
                            type = "ID";
                            break;
                        }
                        case 3: {
                            type = "IDREF";
                            break;
                        }
                        case 4: {
                            type = "IDREFS";
                            break;
                        }
                        case 7: {
                            type = "NMTOKEN";
                            break;
                        }
                        case 8: {
                            type = "NMTOKENS";
                            break;
                        }
                        case 10: {
                            type = "NOTATION";
                            break;
                        }
                        default: {
                            this.errorHandler.fatalError(new SAXParseException("internal error, att type", this));
                            type = null;
                        }
                    }
                    switch (this.parser.getAttributeDefaultValueType(ename, aname)) {
                        case 32: {
                            valueDefault = "#IMPLIED";
                            break;
                        }
                        case 33: {
                            valueDefault = "#REQUIRED";
                            break;
                        }
                        case 34: {
                            valueDefault = "#FIXED";
                            break;
                        }
                        case 31: {
                            valueDefault = null;
                            break;
                        }
                        default: {
                            this.errorHandler.fatalError(new SAXParseException("internal error, att default", this));
                            valueDefault = null;
                        }
                    }
                    String value = this.parser.getAttributeDefaultValue(ename, aname);
                    this.declHandler.attributeDecl(ename, aname, type, valueDefault, value);
                }
            }
        }
    }

    public int getLength() {
        return this.attributeNames.size();
    }

    public String getURI(int index) {
        return (String)this.attributeNamespaces.get(index);
    }

    public String getLocalName(int index) {
        return (String)this.attributeLocalNames.get(index);
    }

    public String getQName(int i) {
        return (String)this.attributeNames.get(i);
    }

    public String getName(int i) {
        return (String)this.attributeNames.get(i);
    }

    public String getType(int i) {
        switch (this.parser.getAttributeType(this.elementName, this.getQName(i))) {
            case 0: 
            case 1: {
                return "CDATA";
            }
            case 2: {
                return "ID";
            }
            case 3: {
                return "IDREF";
            }
            case 4: {
                return "IDREFS";
            }
            case 5: {
                return "ENTITY";
            }
            case 6: {
                return "ENTITIES";
            }
            case 7: 
            case 9: {
                return "NMTOKEN";
            }
            case 8: {
                return "NMTOKENS";
            }
            case 10: {
                return "NOTATION";
            }
        }
        return null;
    }

    public String getValue(int i) {
        return (String)this.attributeValues.get(i);
    }

    public int getIndex(String uri, String local) {
        int length = this.getLength();
        for (int i = 0; i < length; ++i) {
            if (!this.getURI(i).equals(uri) || !this.getLocalName(i).equals(local)) continue;
            return i;
        }
        return -1;
    }

    public int getIndex(String xmlName) {
        int length = this.getLength();
        for (int i = 0; i < length; ++i) {
            if (!this.getQName(i).equals(xmlName)) continue;
            return i;
        }
        return -1;
    }

    public String getType(String uri, String local) {
        int index = this.getIndex(uri, local);
        if (index < 0) {
            return null;
        }
        return this.getType(index);
    }

    public String getType(String xmlName) {
        int index = this.getIndex(xmlName);
        if (index < 0) {
            return null;
        }
        return this.getType(index);
    }

    public String getValue(String uri, String local) {
        int index = this.getIndex(uri, local);
        if (index < 0) {
            return null;
        }
        return this.getValue(index);
    }

    public String getValue(String xmlName) {
        int index = this.getIndex(xmlName);
        if (index < 0) {
            return null;
        }
        return this.getValue(index);
    }

    public String getPublicId() {
        return null;
    }

    public String getSystemId() {
        return (String)this.entityStack.get(this.entityStack.size() - 1);
    }

    public int getLineNumber() {
        return this.parser.getLineNumber();
    }

    public int getColumnNumber() {
        return this.parser.getColumnNumber();
    }

    private static class Adapter
    implements ContentHandler {
        private DocumentHandler docHandler;

        Adapter(DocumentHandler dh) {
            this.docHandler = dh;
        }

        public void setDocumentLocator(Locator l) {
            this.docHandler.setDocumentLocator(l);
        }

        public void startDocument() throws SAXException {
            this.docHandler.startDocument();
        }

        public void processingInstruction(String target, String data) throws SAXException {
            this.docHandler.processingInstruction(target, data);
        }

        public void startPrefixMapping(String prefix, String uri) {
        }

        public void startElement(String namespace, String local, String name, Attributes attrs) throws SAXException {
            this.docHandler.startElement(name, (AttributeList)((Object)attrs));
        }

        public void characters(char[] buf, int offset, int len) throws SAXException {
            this.docHandler.characters(buf, offset, len);
        }

        public void ignorableWhitespace(char[] buf, int offset, int len) throws SAXException {
            this.docHandler.ignorableWhitespace(buf, offset, len);
        }

        public void skippedEntity(String name) {
        }

        public void endElement(String u, String l, String name) throws SAXException {
            this.docHandler.endElement(name);
        }

        public void endPrefixMapping(String prefix) {
        }

        public void endDocument() throws SAXException {
            this.docHandler.endDocument();
        }
    }
}

