/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.remoting.Client;
import org.jboss.remoting.ClientDisconnectedException;
import org.jboss.remoting.ConnectionListener;
import org.jboss.remoting.InvokerLocator;

public class ConnectionNotifier {
    private List listeners = new ArrayList();
    private static final Logger log = Logger.getLogger((Class)(class$org$jboss$remoting$ConnectionNotifier == null ? (class$org$jboss$remoting$ConnectionNotifier = ConnectionNotifier.class$("org.jboss.remoting.ConnectionNotifier")) : class$org$jboss$remoting$ConnectionNotifier));
    static /* synthetic */ Class class$org$jboss$remoting$ConnectionNotifier;

    public void addListener(ConnectionListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ConnectionListener listener) {
        this.listeners.remove(listener);
    }

    public int size() {
        return this.listeners.size();
    }

    public void connectionLost(String locatorurl, String clientSessionId, Map requestPayload) {
        try {
            log.debug((Object)("Server connection lost to client (session id = " + clientSessionId));
            Client client = new Client(new InvokerLocator(locatorurl), requestPayload);
            client.setSessionId(clientSessionId);
            ConnectionListener[] list = this.listeners.toArray(new ConnectionListener[this.listeners.size()]);
            for (int x = 0; x < list.length; ++x) {
                list[x].handleConnectionException(null, client);
            }
        }
        catch (Exception e) {
            log.error((Object)"Error notifying connection listeners of lost client connection.", (Throwable)e);
        }
    }

    public void connectionTerminated(String locatorURL, String clientSessionId, Map requestPayload) {
        try {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Client disconnected (session id = " + clientSessionId));
            }
            Client client = new Client(new InvokerLocator(locatorURL), requestPayload);
            client.setSessionId(clientSessionId);
            ClientDisconnectedException ex = new ClientDisconnectedException();
            ConnectionListener[] list = this.listeners.toArray(new ConnectionListener[this.listeners.size()]);
            for (int x = 0; x < list.length; ++x) {
                list[x].handleConnectionException(ex, client);
            }
        }
        catch (Exception e) {
            log.error((Object)"Error notifying connection listeners of disconnected client connection.", (Throwable)e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

