/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.StreamCorruptedException;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.remoting.ConnectionListener;
import org.jboss.remoting.ConnectionValidator;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.InvocationResponse;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.InvokerRegistry;
import org.jboss.remoting.LeasePinger;
import org.jboss.remoting.Version;
import org.jboss.remoting.callback.CallbackPoller;
import org.jboss.remoting.callback.InvokerCallbackHandler;
import org.jboss.remoting.invocation.InternalInvocation;
import org.jboss.remoting.invocation.OnewayInvocation;
import org.jboss.remoting.marshal.Marshaller;
import org.jboss.remoting.marshal.UnMarshaller;
import org.jboss.remoting.stream.StreamServer;
import org.jboss.remoting.transport.BidirectionalClientInvoker;
import org.jboss.remoting.transport.ClientInvoker;
import org.jboss.remoting.transport.Connector;
import org.jboss.remoting.transport.PortUtil;
import org.jboss.remoting.transport.local.LocalClientInvoker;
import org.jboss.util.id.GUID;
import org.jboss.util.threadpool.BasicThreadPool;
import org.jboss.util.threadpool.BlockingMode;
import org.jboss.util.threadpool.ThreadPool;

public class Client
implements Externalizable {
    public static final String LISTENER_ID_KEY = "listenerId";
    public static final int MAX_NUM_ONEWAY_THREADS = 10;
    public static final String RAW = "RAW_PAYLOAD";
    public static final String ENABLE_LEASE = "ENABLE_LEASE";
    public static final String CUSTOM_SOCKET_FACTORY = "CUSTOM_SOCKET_FACTORY";
    public static final String HANDSHAKE_COMPLETED_LISTENER = "HANDSHAKE_COMPLETED_LISTENER";
    public static final String CALLBACK_SERVER_PROTOCOL = "CALLBACK_SERVER_PROTOCOL";
    public static final String CALLBACK_SERVER_HOST = "CALLBACK_SERVER_HOST";
    public static final String CALLBACK_SERVER_PORT = "CALLBACK_SERVER_PORT";
    private int maxNumberThreads = 10;
    private static final Logger log = Logger.getLogger((Class)(class$org$jboss$remoting$Client == null ? (class$org$jboss$remoting$Client = Client.class$("org.jboss.remoting.Client")) : class$org$jboss$remoting$Client));
    private ClientInvoker invoker;
    private ClassLoader classloader;
    private String subsystem;
    private String sessionId = new GUID().toString();
    private ThreadPool onewayThreadPool;
    private InvokerLocator locator;
    private ConnectionValidator connectionValidator = null;
    private LeasePinger leasePinger = null;
    private Map configuration = null;
    private boolean enableLease = false;
    private long leasePeriod = -1L;
    private Map callbackConnectors = new HashMap();
    private Map callbackPollers = new HashMap();
    private static final long serialVersionUID = 5679279425009837934L;
    static /* synthetic */ Class class$org$jboss$remoting$Client;

    public Client(InvokerLocator locator) throws Exception {
        this(locator, null, null);
    }

    public Client(InvokerLocator locator, Map configuration) throws Exception {
        this(locator, null, configuration);
    }

    public Client(InvokerLocator locator, String subsystem) throws Exception {
        this(locator, subsystem, null);
    }

    public Client(InvokerLocator locator, String subsystem, Map configuration) throws Exception {
        this(Thread.currentThread().getContextClassLoader(), locator, subsystem, configuration);
    }

    public Client(ClassLoader cl, InvokerLocator locator, String subsystem, Map configuration) throws Exception {
        this.classloader = cl;
        this.locator = locator;
        this.subsystem = subsystem == null ? null : subsystem.toUpperCase();
        this.configuration = configuration;
    }

    public Client(ClassLoader cl, ClientInvoker invoker, String subsystem) throws Exception {
        this.classloader = cl;
        this.subsystem = subsystem == null ? null : subsystem.toUpperCase();
        this.invoker = invoker;
    }

    public void addConnectionListener(ConnectionListener listener) {
        this.addConnectionListener(listener, 2000);
    }

    public void addConnectionListener(ConnectionListener listener, int pingPeriod) {
        if (this.invoker == null) {
            throw new RuntimeException("Can not add connection listener to remoting client until client has been connected.");
        }
        if (this.invoker instanceof LocalClientInvoker) {
            return;
        }
        if (this.connectionValidator == null) {
            this.connectionValidator = new ConnectionValidator(this, pingPeriod);
        }
        this.connectionValidator.addConnectionListener(listener);
    }

    public boolean removeConnectionListener(ConnectionListener listener) {
        if (this.connectionValidator == null) {
            return false;
        }
        return this.connectionValidator.removeConnectionListener(listener);
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public Map getConfiguration() {
        return this.configuration;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public boolean isConnected() {
        return this.invoker != null && this.invoker.isConnected();
    }

    public void connect() throws Exception {
        if (this.invoker == null && this.locator != null) {
            this.invoker = InvokerRegistry.createClientInvoker(this.locator, this.configuration);
        }
        if (!this.isConnected()) {
            this.connect(this.invoker);
        }
    }

    private void connect(ClientInvoker invoker) {
        if (invoker == null) {
            throw new RuntimeException("Client invoker is null (may have used void constructor for Client, which should only be used for Externalization.");
        }
        invoker.connect();
        this.setupClientLease(invoker);
    }

    private void setupClientLease(ClientInvoker invoker) {
        Object val;
        if (invoker != null) {
            if (invoker instanceof LocalClientInvoker) {
                return;
            }
            InvokerLocator locator = invoker.getLocator();
            Map locatorParams = locator.getParameters();
            if (locatorParams != null) {
                String leasePeriodValue;
                String leaseValue = (String)locatorParams.get("leasing");
                if (leaseValue != null && leaseValue.length() > 0) {
                    this.enableLease = Boolean.valueOf(leaseValue);
                }
                if ((leasePeriodValue = (String)locatorParams.get("lease_period")) != null && leasePeriodValue.length() > 0) {
                    try {
                        this.leasePeriod = Long.parseLong(leasePeriodValue);
                    }
                    catch (NumberFormatException e) {
                        log.warn((Object)("Could not convert client lease period value (" + leasePeriodValue + ") to a number."));
                    }
                }
            }
        } else {
            throw new RuntimeException("Can not set up client lease as client invoker is null.");
        }
        if (this.configuration != null && (val = this.configuration.get(ENABLE_LEASE)) != null) {
            if (val instanceof Boolean) {
                this.enableLease = (Boolean)val;
            } else if (val instanceof String) {
                this.enableLease = Boolean.valueOf((String)val);
            } else {
                log.warn((Object)("Can not evaluate ENABLE_LEASE value (" + val + ") as a boolean type."));
            }
        }
        if (this.enableLease) {
            Object ret = null;
            try {
                InvocationResponse resp;
                Boolean shouldLease;
                ret = invoker.invoke(new InvocationRequest(this.sessionId, this.subsystem, "$PING$", this.configuration, new HashMap(), null));
                if (ret instanceof InvocationResponse && (shouldLease = (Boolean)(resp = (InvocationResponse)ret).getResult()).booleanValue()) {
                    Map respMap;
                    if (this.leasePeriod < 0L && (respMap = resp.getPayload()) != null) {
                        Long leaseTimeoutValue = (Long)respMap.get("clientLeasePeriod");
                        this.leasePeriod = leaseTimeoutValue;
                    }
                    if (this.leasePeriod > 0L && this.leasePinger == null) {
                        this.leasePinger = new LeasePinger(this);
                        this.leasePinger.startPing(this.leasePeriod);
                    }
                }
            }
            catch (Throwable throwable) {
                log.error((Object)"Error setting up client lease.", throwable);
            }
        }
    }

    public void disconnect() {
        if (this.leasePinger != null) {
            try {
                this.invoker.invoke(new InvocationRequest(this.sessionId, this.subsystem, "$DISCONNECT$", null, null, null));
            }
            catch (Throwable throwable) {
                log.error((Object)"Error sending disconnect to server to end client lease.", throwable);
            }
            this.leasePinger.stopPing();
        }
        if (this.invoker != null) {
            InvokerRegistry.destroyClientInvoker(this.invoker.getLocator(), this.configuration);
            this.invoker = null;
        }
    }

    public ClientInvoker getInvoker() {
        return this.invoker;
    }

    public void setInvoker(ClientInvoker invoker) {
        this.invoker = invoker;
    }

    public String getSubsystem() {
        return this.subsystem;
    }

    public void setSubsystem(String subsystem) {
        this.subsystem = subsystem;
    }

    public Object invoke(Object param) throws Throwable {
        return this.invoke(param, null);
    }

    public Object invoke(Object param, Map metadata) throws Throwable {
        return this.invoke(param, metadata, null);
    }

    private Object invoke(Object param, Map metadata, InvokerLocator callbackServerLocator) throws Throwable {
        if (this.isConnected()) {
            return this.invoker.invoke(new InvocationRequest(this.sessionId, this.subsystem, param, metadata, null, callbackServerLocator));
        }
        throw new Exception("Can not make remoting client invocation due to not being connected to server.");
    }

    public void invokeOneway(final Object param, final Map sendPayload, boolean clientSide) throws Throwable {
        if (clientSide) {
            ThreadPool threadPool = this.getOnewayThreadPool();
            Runnable onewayRun = new Runnable(){

                public void run() {
                    try {
                        Client.this.invoke(param, sendPayload);
                    }
                    catch (Throwable e) {
                        log.error((Object)("Error executing client oneway invocation request: " + param), e);
                    }
                }
            };
            threadPool.run(onewayRun);
        } else {
            OnewayInvocation invocation = new OnewayInvocation(param);
            this.invoke(invocation, sendPayload);
        }
    }

    public void setMaxNumberOfThreads(int numOfThreads) {
        this.maxNumberThreads = numOfThreads;
    }

    public int getMaxNumberOfThreads() {
        return this.maxNumberThreads;
    }

    public ThreadPool getOnewayThreadPool() {
        if (this.onewayThreadPool == null) {
            BasicThreadPool pool = new BasicThreadPool("JBossRemoting Client Oneway");
            pool.setMaximumPoolSize(this.maxNumberThreads);
            pool.setBlockingMode(BlockingMode.WAIT);
            this.onewayThreadPool = pool;
        }
        return this.onewayThreadPool;
    }

    public void setOnewayThreadPool(ThreadPool pool) {
        this.onewayThreadPool = pool;
    }

    public void invokeOneway(Object param) throws Throwable {
        this.invokeOneway(param, null);
    }

    public void invokeOneway(Object param, Map sendPayload) throws Throwable {
        this.invokeOneway(param, sendPayload, false);
    }

    public void addListener(InvokerCallbackHandler callbackhandler, Map metadata) throws Throwable {
        this.addListener(callbackhandler, metadata, null);
    }

    public void addListener(InvokerCallbackHandler callbackhandler, Map metadata, Object callbackHandlerObject) throws Throwable {
        this.addListener(callbackhandler, metadata, callbackHandlerObject, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addListener(InvokerCallbackHandler callbackhandler, Map metadata, Object callbackHandlerObject, boolean serverToClient) throws Throwable {
        InvokerLocator callbackLocator = null;
        if (!this.isConnected()) throw new Exception("Can not add callback listener because remoting client is not connected to server.");
        if (callbackhandler == null) throw new NullPointerException("InvokerCallbackHandler to be added as a listener can not be null.");
        boolean isBidirectional = this.invoker instanceof BidirectionalClientInvoker;
        if (isBidirectional || serverToClient) {
            String transport = null;
            String host = null;
            int port = -1;
            if (metadata != null) {
                transport = (String)metadata.get(CALLBACK_SERVER_PROTOCOL);
                host = (String)metadata.get(CALLBACK_SERVER_HOST);
                String sPort = (String)metadata.get(CALLBACK_SERVER_PORT);
                if (sPort != null) {
                    try {
                        port = Integer.parseInt(sPort);
                    }
                    catch (NumberFormatException e) {
                        log.warn((Object)("Could not set the internal callback server port as configuration value (" + sPort + ") is not a number."));
                    }
                }
            } else {
                metadata = new HashMap();
            }
            if (transport == null) {
                transport = this.invoker.getLocator().getProtocol();
                metadata.put(CALLBACK_SERVER_PROTOCOL, transport);
            }
            if (host == null) {
                host = InetAddress.getLocalHost().getHostAddress();
                metadata.put(CALLBACK_SERVER_HOST, host);
            }
            if (port == -1) {
                port = PortUtil.findFreePort(host);
                metadata.put(CALLBACK_SERVER_PORT, String.valueOf(port));
            }
            callbackLocator = isBidirectional ? ((BidirectionalClientInvoker)this.invoker).getCallbackLocator(metadata) : new InvokerLocator(transport, host, port, null, metadata);
            Connector callbackServerConnector = new Connector(callbackLocator);
            this.callbackConnectors.put(callbackhandler, callbackServerConnector);
            callbackServerConnector.start();
            callbackLocator = callbackServerConnector.getServerInvoker().getLocator();
        } else {
            CallbackPoller poller = new CallbackPoller(this, callbackhandler, metadata, callbackHandlerObject);
            this.callbackPollers.put(callbackhandler, poller);
            poller.start();
        }
        this.addCallbackListener(callbackhandler, metadata, callbackLocator, callbackHandlerObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCallbackListener(InvokerCallbackHandler callbackhandler, Map metadata, InvokerLocator callbackLocator, Object callbackHandlerObject) throws Throwable {
        Map internalMetadata = this.createListenerMetadata(callbackhandler);
        if (metadata != null) {
            internalMetadata.putAll(metadata);
        }
        String listenerId = (String)internalMetadata.get(LISTENER_ID_KEY);
        this.invoker.addClientLocator(listenerId, callbackLocator);
        if (callbackLocator != null) {
            Client client = new Client(callbackLocator, this.subsystem);
            client.setSessionId(this.getSessionId());
            client.connect();
            try {
                client.invoke(new InternalInvocation("addClientListener", new Object[]{callbackhandler, callbackHandlerObject}), internalMetadata);
            }
            finally {
                client.disconnect();
            }
        }
        this.invoke(new InternalInvocation("addListener", null), internalMetadata, callbackLocator);
    }

    public void addListener(InvokerCallbackHandler callbackHandler) throws Throwable {
        this.addListener(callbackHandler, (InvokerLocator)null);
    }

    public void addListener(InvokerCallbackHandler callbackHandler, InvokerLocator clientLocator) throws Throwable {
        this.addListener(callbackHandler, clientLocator, null);
    }

    public void addListener(InvokerCallbackHandler callbackHandler, InvokerLocator clientLocator, Object callbackHandlerObject) throws Throwable {
        if (callbackHandler != null) {
            if (!this.isConnected()) {
                throw new Exception("Can not add callback listener as remoting client is not connected to server.");
            }
        } else {
            throw new NullPointerException("InvokerCallbackHandler to be added as a listener can not be null.");
        }
        this.addCallbackListener(callbackHandler, null, clientLocator, callbackHandlerObject);
    }

    private Map createListenerMetadata(InvokerCallbackHandler callbackHandler) {
        String listenerId = String.valueOf(callbackHandler.hashCode());
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put(LISTENER_ID_KEY, listenerId);
        return metadata;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void removeListener(InvokerCallbackHandler callbackHandler) throws Throwable {
        CallbackPoller callbackPoller;
        if (!this.isConnected()) throw new Exception("Can not remove callback listener as remoting client is not connected to server.");
        if (callbackHandler == null) throw new NullPointerException("Can not remove null InvokerCallbackHandler listener.");
        Map metadata = this.createListenerMetadata(callbackHandler);
        String listenerId = (String)metadata.get(LISTENER_ID_KEY);
        InvokerLocator locator = this.invoker.getClientLocator(listenerId);
        if (locator != null) {
            Client client = new Client(locator, this.subsystem);
            client.setSessionId(this.getSessionId());
            client.connect();
            client.invoke(new InternalInvocation("removeClientListener", new Object[]{callbackHandler}), metadata);
            client.disconnect();
        }
        this.invoke(new InternalInvocation("removeListener", null), metadata);
        Connector callbackConnector = (Connector)this.callbackConnectors.remove(callbackHandler);
        if (callbackConnector != null) {
            callbackConnector.stop();
            callbackConnector.destroy();
        }
        if ((callbackPoller = (CallbackPoller)this.callbackPollers.remove(callbackHandler)) == null) return;
        callbackPoller.stop();
    }

    public List getCallbacks(InvokerCallbackHandler callbackHandler) throws Throwable {
        if (callbackHandler != null) {
            Map metadata = this.createListenerMetadata(callbackHandler);
            return (List)this.invoke(new InternalInvocation("getCallbacks", null), metadata);
        }
        throw new NullPointerException("Can not remove null InvokerCallbackHandler listener.");
    }

    public void setMarshaller(Marshaller marshaller) {
        if (this.isConnected()) {
            if (marshaller == null) {
                throw new NullPointerException("Can not set Marshaller with a null value.");
            }
        } else {
            throw new RuntimeException("Can not set remoting client Marshaller when not connected.");
        }
        this.invoker.setMarshaller(marshaller);
    }

    public void setUnMarshaller(UnMarshaller unmarshaller) {
        if (this.isConnected()) {
            if (unmarshaller == null) {
                throw new NullPointerException("Can not set UnMarshaller to null value.");
            }
        } else {
            throw new RuntimeException("Can not set remoting client UnMarhshaller when not connected.");
        }
        this.invoker.setUnMarshaller(unmarshaller);
    }

    public Object invoke(InputStream inputStream, Object param) throws Throwable {
        StreamServer streamServer = new StreamServer(inputStream);
        String locator = streamServer.getInvokerLocator();
        InvocationRequest invocationRequest = new InvocationRequest(this.sessionId, this.subsystem, param, null, null, null);
        return this.invoke(new InternalInvocation("addStreamCallback", new Object[]{locator, invocationRequest}), null);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        switch (version) {
            case 2: {
                InvokerLocator readLocator = (InvokerLocator)in.readObject();
                this.subsystem = (String)in.readObject();
                this.configuration = (Map)in.readObject();
                boolean wasConnected = in.readBoolean();
                this.classloader = Thread.currentThread().getContextClassLoader();
                try {
                    this.invoker = InvokerRegistry.createClientInvoker(readLocator, this.configuration);
                    if (!wasConnected) break;
                    this.connect();
                    break;
                }
                catch (Exception e) {
                    log.error((Object)e);
                    throw new IOException(e.getMessage());
                }
            }
            default: {
                throw new StreamCorruptedException("Unkown version seen: " + version);
            }
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(Version.getDefaultVersion());
        out.writeObject(this.invoker != null ? this.invoker.getLocator() : this.locator);
        out.writeObject(this.subsystem);
        out.writeObject(this.configuration);
        out.writeBoolean(this.isConnected());
        out.flush();
    }

    public Client() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

