/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.jboss.remoting.InvokerRegistry;
import org.jboss.remoting.transport.ClientInvoker;

public class InvokerLocator
implements Serializable {
    private static final long serialVersionUID = -4977622166779282521L;
    protected String protocol;
    protected String host;
    protected int port;
    protected String path;
    protected Map parameters;
    private String uri;
    private String originalURL;
    private static final String ANY = "0.0.0.0";
    private static final String SERVER_BIND_ADDRESS = "jboss.bind.address";
    public static final String BIND_BY_HOST = "remoting.bind_by_host";
    public static final String DATATYPE = "datatype";
    public static final String DATATYPE_CASED = "dataType";
    public static final String SERIALIZATIONTYPE = "serializationtype";
    public static final String SERIALIZATIONTYPE_CASED = "serializationType";
    public static final String MARSHALLER = "marshaller";
    public static final String UNMARSHALLER = "unmarshaller";
    public static final String LOADER_PORT = "loaderport";
    public static final String BYVALUE = "byvalue";
    public static final String CLIENT_LEASE = "leasing";
    public static final String CLIENT_LEASE_PERIOD = "lease_period";

    public InvokerLocator(String uri) throws MalformedURLException {
        this.originalURL = uri;
        int i = uri.indexOf("://");
        if (i < 0) {
            throw new MalformedURLException("Invalid url " + uri);
        }
        String tmp = uri.substring(i + 3);
        this.protocol = uri.substring(0, i);
        i = tmp.indexOf("/");
        int p = tmp.indexOf(":");
        if (i != -1) {
            int n = p = p < i ? p : -1;
        }
        if (p != -1) {
            this.host = InvokerLocator.resolveHost(tmp.substring(0, p).trim());
            this.port = i > -1 ? Integer.parseInt(tmp.substring(p + 1, i)) : Integer.parseInt(tmp.substring(p + 1));
        } else {
            this.host = i > -1 ? InvokerLocator.resolveHost(tmp.substring(0, i).trim()) : InvokerLocator.resolveHost(tmp.substring(0).trim());
            this.port = -1;
        }
        p = tmp.indexOf("?");
        if (p != -1) {
            this.path = tmp.substring(i + 1, p);
            String args = tmp.substring(p + 1);
            StringTokenizer tok = new StringTokenizer(args, "&");
            this.parameters = new TreeMap();
            while (tok.hasMoreTokens()) {
                String token = tok.nextToken();
                int eq = token.indexOf("=");
                String name = eq > -1 ? token.substring(0, eq) : token;
                String value = eq > -1 ? token.substring(eq + 1) : "";
                this.parameters.put(name, value);
            }
        } else {
            p = tmp.indexOf("/");
            this.path = p != -1 ? tmp.substring(p + 1) : "";
        }
        this.uri = this.protocol + "://" + this.host + (this.port > -1 ? ":" + this.port : "") + "/" + this.path + (this.parameters != null ? "?" : "");
        if (this.parameters != null) {
            Iterator iter = this.parameters.keySet().iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                String val = (String)this.parameters.get(key);
                this.uri = this.uri + key + "=" + val;
                if (!iter.hasNext()) continue;
                this.uri = this.uri + "&";
            }
        }
    }

    private static final String resolveHost(String host) {
        if (host.indexOf(ANY) != -1) {
            host = System.getProperty(SERVER_BIND_ADDRESS, ANY).equals(ANY) ? InvokerLocator.fixRemoteAddress(host) : host.replaceAll("0\\.0\\.0\\.0", System.getProperty(SERVER_BIND_ADDRESS));
        }
        try {
            return InetAddress.getByName(host).getHostAddress();
        }
        catch (Exception ex) {
            return host;
        }
    }

    private static String fixRemoteAddress(String address) {
        block5: {
            try {
                if (address != null && !ANY.equals(address)) break block5;
                boolean byHost = true;
                String bindByHost = System.getProperty(BIND_BY_HOST, "True");
                try {
                    byHost = Boolean.getBoolean(bindByHost);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (byHost) {
                    return InetAddress.getLocalHost().getHostName();
                }
                return InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return address;
    }

    public InvokerLocator(String protocol, String host, int port, String path, Map parameters) {
        this.protocol = protocol;
        this.host = InvokerLocator.resolveHost(host);
        this.port = port;
        this.path = path;
        this.parameters = parameters;
        this.uri = protocol + "://" + this.host + (port > -1 ? ":" + port : "") + "/" + path + (parameters != null ? "?" : "");
        if (parameters != null) {
            Iterator iter = parameters.keySet().iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                String val = (String)parameters.get(key);
                this.uri = this.uri + key + "=" + val;
                if (!iter.hasNext()) continue;
                this.uri = this.uri + "&";
            }
        }
        this.originalURL = this.uri;
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof InvokerLocator && obj.hashCode() == this.hashCode();
    }

    public boolean isSameEndpoint(InvokerLocator compareMe) {
        return compareMe != null && this.getProtocol().equalsIgnoreCase(compareMe.getProtocol()) && this.getHost().equalsIgnoreCase(compareMe.getHost()) && this.getPort() == compareMe.getPort();
    }

    public String getLocatorURI() {
        return this.uri;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getPath() {
        return this.path;
    }

    public Map getParameters() {
        return this.parameters;
    }

    public String toString() {
        return "InvokerLocator [" + this.uri + "]";
    }

    public String getOriginalURI() {
        return this.originalURL;
    }

    public ClientInvoker narrow() throws Exception {
        return InvokerRegistry.createClientInvoker(this);
    }

    public String findSerializationType() {
        String serializationTypeLocal = "java";
        if (this.parameters != null && (serializationTypeLocal = (String)this.parameters.get(SERIALIZATIONTYPE)) == null && (serializationTypeLocal = (String)this.parameters.get(SERIALIZATIONTYPE_CASED)) == null) {
            serializationTypeLocal = "java";
        }
        return serializationTypeLocal;
    }
}

