/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting;

import java.io.IOException;
import java.util.Map;
import org.jboss.remoting.AbstractInvoker;
import org.jboss.remoting.ConnectionFailedException;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.InvocationResponse;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.loading.ClassByteClassLoader;
import org.jboss.remoting.loading.RemotingClassLoader;
import org.jboss.remoting.marshal.InvalidMarshallingResource;
import org.jboss.remoting.marshal.MarshalFactory;
import org.jboss.remoting.marshal.Marshaller;
import org.jboss.remoting.marshal.UnMarshaller;
import org.jboss.remoting.transport.ClientInvoker;

public abstract class MicroRemoteClientInvoker
extends AbstractInvoker
implements ClientInvoker {
    protected boolean connected = false;
    private Marshaller marshaller;
    private UnMarshaller unmarshaller;
    private String dataType;

    public MicroRemoteClientInvoker(InvokerLocator locator) {
        super(locator);
    }

    public MicroRemoteClientInvoker(InvokerLocator locator, Map configuration) {
        super(locator, configuration);
    }

    public Object invoke(InvocationRequest invocationReq) throws Throwable {
        Object returnValue = null;
        int invokeCount = 0;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)(++invokeCount + ") invoking =>" + invocationReq + " with parameter: " + invocationReq.getParameter()));
        }
        Marshaller marshaller = this.getMarshaller();
        UnMarshaller unmarshaller = this.getUnMarshaller();
        if (marshaller == null && (marshaller = MarshalFactory.getMarshaller(this.getLocator(), this.getClassLoader())) == null && (marshaller = MarshalFactory.getMarshaller(this.getDataType(), this.getSerializationType())) == null) {
            throw new InvalidMarshallingResource("Can not find a valid marshaller for data type: " + this.getDataType());
        }
        RemotingClassLoader remotingClassLoader = new RemotingClassLoader(this.getClassLoader(), Thread.currentThread().getContextClassLoader());
        if (unmarshaller == null) {
            unmarshaller = MarshalFactory.getUnMarshaller(this.getLocator(), this.getClassLoader());
            if (unmarshaller == null && (unmarshaller = MarshalFactory.getUnMarshaller(this.getDataType(), this.getSerializationType())) == null) {
                throw new InvalidMarshallingResource("Can not find a valid unmarshaller for data type: " + this.getDataType());
            }
            unmarshaller.setClassLoader(remotingClassLoader);
        }
        Object payload = null;
        Map metadata = invocationReq.getRequestPayload();
        payload = metadata != null && metadata.get("RAW_PAYLOAD") != null ? invocationReq.getParameter() : invocationReq;
        returnValue = this.transport(invocationReq.getSessionId(), payload, metadata, marshaller, unmarshaller);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("received result=>" + returnValue));
        }
        if (returnValue instanceof InvocationResponse) {
            InvocationResponse response = (InvocationResponse)returnValue;
            returnValue = response.getResult();
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("received result was an InvocationResponse so going to return response's return value of " + returnValue));
                this.log.trace((Object)("response is exception = " + response.isException()));
            }
            if (response.isException()) {
                StackTraceElement[] serverStackTrace;
                Throwable e = (Throwable)returnValue;
                if (e.getCause() != null) {
                    serverStackTrace = e.getCause().getStackTrace();
                    if (serverStackTrace == null || serverStackTrace.length == 0) {
                        serverStackTrace = e.getStackTrace();
                    }
                } else {
                    serverStackTrace = e.getStackTrace();
                }
                if (serverStackTrace == null || serverStackTrace.length == 0) {
                    this.log.warn((Object)("An exception occurred on the server side when making remote invocation.  The exception returned from server does not include a stack trace.  Original server side exception message is " + e.getMessage()), e);
                }
                Exception clientException = new Exception();
                StackTraceElement[] clientStackTrace = clientException.getStackTrace();
                StackTraceElement[] completeStackTrace = new StackTraceElement[serverStackTrace.length + clientStackTrace.length];
                System.arraycopy(serverStackTrace, 0, completeStackTrace, 0, serverStackTrace.length);
                System.arraycopy(clientStackTrace, 0, completeStackTrace, serverStackTrace.length, clientStackTrace.length);
                if (e.getCause() != null) {
                    e.getCause().setStackTrace(completeStackTrace);
                } else {
                    e.setStackTrace(completeStackTrace);
                }
                throw e;
            }
        }
        return returnValue;
    }

    protected void preProcess(String sessionId, Object param, Map sendPayload, Map receivedPayload) {
    }

    protected void postProcess(String sessionId, Object param, Map sendPayload, Map receivedPayload) {
    }

    protected abstract Object transport(String var1, Object var2, Map var3, Marshaller var4, UnMarshaller var5) throws IOException, ConnectionFailedException, ClassNotFoundException;

    public boolean isConnected() {
        return this.connected;
    }

    public synchronized void connect() throws ConnectionFailedException {
        if (!this.connected) {
            this.log.debug((Object)("connect called for: " + this));
            this.handleConnect();
            this.connected = true;
        }
    }

    protected abstract void handleConnect() throws ConnectionFailedException;

    protected abstract void handleDisconnect();

    public synchronized void disconnect() {
        if (this.connected) {
            this.log.debug((Object)("disconnect called for: " + this));
            this.connected = false;
            this.handleDisconnect();
            ClassLoader classLoader = this.getClassLoader();
            if (classLoader != null && classLoader instanceof ClassByteClassLoader) {
                this.classbyteloader.destroy();
            }
        }
    }

    public void setMarshaller(Marshaller marshaller) {
        this.marshaller = marshaller;
    }

    public Marshaller getMarshaller() {
        return this.marshaller;
    }

    public void setUnMarshaller(UnMarshaller unmarshaller) {
        this.unmarshaller = unmarshaller;
    }

    public UnMarshaller getUnMarshaller() {
        return this.unmarshaller;
    }

    private String getDataType() {
        if (this.dataType == null) {
            this.dataType = this.getDataType(this.getLocator());
            if (this.dataType == null) {
                this.dataType = this.getDefaultDataType();
            }
        }
        return this.dataType;
    }

    private String getDataType(InvokerLocator locator) {
        Map params;
        String type = null;
        if (locator != null && (params = locator.getParameters()) != null && (type = (String)params.get("datatype")) == null) {
            type = (String)params.get("dataType");
        }
        return type;
    }

    protected abstract String getDefaultDataType();

    protected void finalize() throws Throwable {
        this.disconnect();
        super.finalize();
    }
}

