/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting;

import java.util.Map;
import javax.net.SocketFactory;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.MicroRemoteClientInvoker;
import org.jboss.remoting.util.socket.RemotingSSLSocketFactory;

public abstract class RemoteClientInvoker
extends MicroRemoteClientInvoker {
    private SocketFactory socketFactory;

    public RemoteClientInvoker(InvokerLocator locator) {
        super(locator);
    }

    public RemoteClientInvoker(InvokerLocator locator, Map configuration) {
        super(locator, configuration);
        this.socketFactory = this.createSocketFactory(configuration);
    }

    public SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    protected SocketFactory createSocketFactory(Map configuration) {
        SocketFactory factory = null;
        if (configuration != null) {
            Object obj = configuration.get("CUSTOM_SOCKET_FACTORY");
            if (obj != null) {
                if (obj instanceof SocketFactory) {
                    factory = (SocketFactory)obj;
                } else {
                    throw new RuntimeException("Can not set custom socket factory (" + obj + ") as is not of type javax.net.SocketFactory");
                }
            }
            if (factory == null && (configuration.get("org.jboss.remoting.algorithm") != null || configuration.get("org.jboss.remoting.keyAlias") != null || configuration.get("org.jboss.remoting.keyStore") != null || configuration.get("org.jboss.remoting.keyStorePassword") != null || configuration.get("org.jboss.remoting.keyStoreType") != null || configuration.get("org.jboss.remoting.truststoreAlgorithm") != null || configuration.get("org.jboss.remoting.trustStore") != null || configuration.get("org.jboss.remoting.trustStorePassword") != null || configuration.get("org.jboss.remoting.trustStoreType") != null)) {
                factory = new RemotingSSLSocketFactory(configuration);
            }
        }
        return factory;
    }
}

