/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.callback;

import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import org.jboss.logging.Logger;
import org.jboss.remoting.Client;
import org.jboss.remoting.callback.Callback;
import org.jboss.remoting.callback.HandleCallbackException;
import org.jboss.remoting.callback.InvokerCallbackHandler;
import org.jboss.remoting.util.TimerUtil;

public class CallbackPoller
extends TimerTask {
    public static final long DEFAULT_POLL_PERIOD = 5000L;
    public static final String CALLBACK_POLL_PERIOD = "callbackPollPeriod";
    private Client client = null;
    private InvokerCallbackHandler callbackHandler = null;
    private Map metadata = null;
    private Object callbackHandlerObject = null;
    private long pollPeriod = 5000L;
    private static final Logger log = Logger.getLogger((Class)(class$org$jboss$remoting$callback$CallbackPoller == null ? (class$org$jboss$remoting$callback$CallbackPoller = CallbackPoller.class$("org.jboss.remoting.callback.CallbackPoller")) : class$org$jboss$remoting$callback$CallbackPoller));
    static /* synthetic */ Class class$org$jboss$remoting$callback$CallbackPoller;
    static /* synthetic */ Class class$java$lang$String;

    public CallbackPoller(Client client, InvokerCallbackHandler callbackhandler, Map metadata, Object callbackHandlerObject) {
        this.client = client;
        this.callbackHandler = callbackhandler;
        this.metadata = metadata;
        this.callbackHandlerObject = callbackHandlerObject;
    }

    public void start() throws Exception {
        Object val;
        if (this.callbackHandler == null) {
            throw new NullPointerException("Can not poll for callbacks when InvokerCallbackHandler is null.");
        }
        if (this.client != null) {
            this.client.connect();
        }
        if (this.metadata != null && (val = this.metadata.get(CALLBACK_POLL_PERIOD)) != null) {
            if (val instanceof String) {
                try {
                    this.pollPeriod = Long.parseLong((String)val);
                }
                catch (NumberFormatException e) {
                    log.warn((Object)("Error converting callbackPollPeriod to type long.  " + e.getMessage()));
                }
            } else {
                log.warn((Object)("Value for callbackPollPeriod configuration must be of type " + (class$java$lang$String == null ? (class$java$lang$String = CallbackPoller.class$("java.lang.String")) : class$java$lang$String).getName() + " and is " + val.getClass().getName()));
            }
        }
        TimerUtil.schedule(this, this.pollPeriod);
    }

    public void run() {
        try {
            List callbacks = this.client.getCallbacks(this.callbackHandler);
            if (callbacks != null && callbacks.size() > 0) {
                final Callback[] callbackArray = callbacks.toArray(new Callback[callbacks.size()]);
                new Thread(new Runnable(){

                    public void run() {
                        for (int x = 0; x < callbackArray.length; ++x) {
                            Callback callbackObject = callbackArray[x];
                            callbackObject.setCallbackHandleObject(CallbackPoller.this.callbackHandlerObject);
                            try {
                                CallbackPoller.this.callbackHandler.handleCallback(callbackObject);
                                continue;
                            }
                            catch (HandleCallbackException e) {
                                log.error((Object)("Error delivering callback to callback handler (" + CallbackPoller.this.callbackHandler + ")."), (Throwable)e);
                            }
                        }
                    }
                }).start();
            }
        }
        catch (Throwable throwable) {
            log.error((Object)"Error getting callbacks from server.", throwable);
        }
    }

    public void stop() {
        this.cancel();
        this.client = null;
        this.callbackHandler = null;
        this.callbackHandlerObject = null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

