/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.samples.detection.jndi;

import java.net.InetAddress;
import java.util.Date;
import org.jnp.server.Main;

public class SimpleJNDIServer {
    private static String transport = "socket";
    private static String host = "localhost";
    private static int port = 5400;
    private int detectorPort = 1099;
    static /* synthetic */ Class class$org$jboss$remoting$samples$detection$jndi$SimpleJNDIServer;

    public static void main(String[] args) {
        String prop = System.getProperty("args");
        if (prop != null) {
            try {
                transport = prop.substring(0, prop.indexOf("-"));
                port = Integer.parseInt(prop.substring(prop.indexOf("-") + 1));
            }
            catch (NumberFormatException nfe) {
                SimpleJNDIServer.println("INVALID ARGUMENTS: Bad port from property args: " + prop);
                System.exit(1);
            }
            catch (Exception e) {
                SimpleJNDIServer.println("INVALID ARGUMENTS: -Dargs property must be in the form '{socket|rmi}-{port#}': " + prop);
                System.exit(1);
            }
        }
        if (args != null && args.length != 0) {
            if (args.length == 2) {
                transport = args[0];
                port = Integer.parseInt(args[1]);
            } else {
                SimpleJNDIServer.println("INVALID ARGUMENTS: Usage: " + (class$org$jboss$remoting$samples$detection$jndi$SimpleJNDIServer == null ? (class$org$jboss$remoting$samples$detection$jndi$SimpleJNDIServer = SimpleJNDIServer.class$("org.jboss.remoting.samples.detection.jndi.SimpleJNDIServer")) : class$org$jboss$remoting$samples$detection$jndi$SimpleJNDIServer).getName() + " [rmi|socket <port>]");
                System.exit(1);
            }
        }
        SimpleJNDIServer.println("Starting JBoss/Remoting server... to stop this server, kill it manually via Control-C");
        String locatorURI = transport + "://" + host + ":" + port;
        SimpleJNDIServer.println("This server's endpoint will be: " + locatorURI);
        SimpleJNDIServer server = new SimpleJNDIServer();
        try {
            server.setupJNDIServer();
            while (true) {
                Thread.sleep(1000L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            SimpleJNDIServer.println("Stopping JBoss/Remoting server");
            return;
        }
    }

    private void setupJNDIServer() throws Exception {
        String detectorHost = InetAddress.getLocalHost().getHostName();
        Main JNDIServer2 = new Main();
        JNDIServer2.setPort(this.detectorPort);
        JNDIServer2.setBindAddress(detectorHost);
        JNDIServer2.start();
        System.out.println("Started JNDI server on " + detectorHost + ":" + this.detectorPort);
    }

    public static void println(String msg) {
        System.out.println(new Date() + ": [SERVER]: " + msg);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

