/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.security;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.URL;
import java.security.AccessController;
import java.security.InvalidParameterException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.jboss.logging.Logger;
import org.jboss.remoting.security.SSLSocketBuilderMBean;

public class SSLSocketBuilder
implements SSLSocketBuilderMBean {
    public static final String DEFAULT_SECURE_SOCKET_PROTOCOL = "TLS";
    public static final String DEFAULT_KEY_MANAGEMENT_ALGORITHM = "SunX509";
    public static final String DEFAULT_KEY_STORE_TYPE = "JKS";
    private String secureSocketProtocol = "TLS";
    private String keyManagementAlgorithm = "SunX509";
    private String keyStoreType = "JKS";
    private boolean useSSLServerSocketFactory = true;
    private boolean useSSLSocketFactory = true;
    private char[] keyStorePassword = null;
    private char[] keyPassword = null;
    private URL keyStoreURL = null;
    private URL trustStoreURL = null;
    private boolean useClientMode;
    private static final Logger log = Logger.getLogger((Class)(class$org$jboss$remoting$security$SSLSocketBuilder == null ? (class$org$jboss$remoting$security$SSLSocketBuilder = SSLSocketBuilder.class$("org.jboss.remoting.security.SSLSocketBuilder")) : class$org$jboss$remoting$security$SSLSocketBuilder));
    static /* synthetic */ Class class$org$jboss$remoting$security$SSLSocketBuilder;

    public void setUseSSLServerSocketFactory(boolean shouldUse) {
        this.useSSLServerSocketFactory = shouldUse;
    }

    public boolean getUseSSLServerSocketFactory() {
        return this.useSSLServerSocketFactory;
    }

    public void setUseSSLSocketFactory(boolean shouldUse) {
        this.useSSLSocketFactory = shouldUse;
    }

    public boolean getUseSSLSocketFactory() {
        return this.useSSLSocketFactory;
    }

    public String getSecureSocketProtocol() {
        return this.secureSocketProtocol;
    }

    public void setSecureSocketProtocol(String secureSocketProtocol) {
        this.secureSocketProtocol = secureSocketProtocol;
    }

    public String getKeyManagementAlgorithm() {
        return this.keyManagementAlgorithm;
    }

    public void setKeyManagementAlgorithm(String keyManagementAlgorithm) {
        this.keyManagementAlgorithm = keyManagementAlgorithm;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public void setKeyStoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
    }

    public void setKeyStorePassword(String passphrase) {
        if (passphrase == null || passphrase.length() <= 0) {
            throw new InvalidParameterException("Must enter a non null key store passphrase with at least one character.");
        }
        this.keyStorePassword = passphrase.toCharArray();
    }

    public void setKeyPassword(String passphrase) {
        if (passphrase == null || passphrase.length() <= 0) {
            throw new InvalidParameterException("Must enter a non null key passphrase with at least one character.");
        }
        this.keyPassword = passphrase.toCharArray();
    }

    public void setUseClientMode(boolean useClientMode) {
        this.useClientMode = useClientMode;
    }

    public ServerSocketFactory createSSLServerSocketFactory() throws IOException, NoSuchAlgorithmException, KeyStoreException, CertificateException, UnrecoverableKeyException, KeyManagementException {
        ServerSocketFactory ssf = null;
        ssf = this.useSSLServerSocketFactory ? SSLServerSocketFactory.getDefault() : this.createCustomServerSocketFactory();
        return ssf;
    }

    private ServerSocketFactory createCustomServerSocketFactory() throws NoSuchAlgorithmException, KeyStoreException, IOException, CertificateException, UnrecoverableKeyException, KeyManagementException {
        SSLServerSocketFactory ssf = null;
        SSLContext sslContext = SSLContext.getInstance(this.secureSocketProtocol);
        KeyManager[] keyManagers = null;
        try {
            KeyManagerFactory keyMgrFactory = this.getKeyManagerFactory();
            keyManagers = keyMgrFactory.getKeyManagers();
        }
        catch (NullStoreURLException e) {
            IOException ioe = new IOException("Can not find keystore url.");
            ioe.initCause(e);
            throw ioe;
        }
        TrustManager[] trustManagers = null;
        try {
            TrustManagerFactory trustMgrFactory = this.getTrustManagerFactory();
            trustManagers = trustMgrFactory.getTrustManagers();
        }
        catch (NullStoreURLException e) {
            log.debug((Object)("Could not find truststore url.  " + e.getMessage()));
        }
        sslContext.init(keyManagers, trustManagers, null);
        ssf = sslContext.getServerSocketFactory();
        if (this.useClientMode) {
            return new UserModeSSLServerSocketFactory(ssf);
        }
        return ssf;
    }

    public SocketFactory createSSLSocketFactory() throws IOException, NoSuchAlgorithmException, KeyStoreException, CertificateException, KeyManagementException {
        SocketFactory sf = null;
        if (this.useSSLSocketFactory) {
            sf = SSLSocketFactory.getDefault();
        } else {
            try {
                sf = this.createCustomSocketFactory();
            }
            catch (UnrecoverableKeyException e) {
                KeyStoreException kse = new KeyStoreException(e.getMessage());
                kse.initCause(e);
                throw kse;
            }
        }
        return sf;
    }

    private SocketFactory createCustomSocketFactory() throws NoSuchAlgorithmException, IOException, CertificateException, KeyStoreException, KeyManagementException, UnrecoverableKeyException {
        SSLSocketFactory sf = null;
        SSLContext sslContext = SSLContext.getInstance(this.secureSocketProtocol);
        KeyManager[] keyManagers = null;
        try {
            KeyManagerFactory keyMgrFactory = this.getKeyManagerFactory();
            keyManagers = keyMgrFactory.getKeyManagers();
        }
        catch (NullStoreURLException e) {
            log.debug((Object)("Could not find keystore url.  " + e.getMessage()));
        }
        TrustManager[] trustManagers = null;
        try {
            TrustManagerFactory trustMgrFactory = this.getTrustManagerFactory();
            trustManagers = trustMgrFactory.getTrustManagers();
        }
        catch (NullStoreURLException e) {
            if (keyManagers != null) {
                log.debug((Object)("Could not find truststore url.  " + e.getMessage()));
            }
            IOException ioe = new IOException("Can not find truststore url.");
            ioe.initCause(e);
            throw ioe;
        }
        sslContext.init(keyManagers, trustManagers, null);
        sf = sslContext.getSocketFactory();
        return sf;
    }

    private TrustManagerFactory getTrustManagerFactory() throws NoSuchAlgorithmException, IOException, CertificateException, KeyStoreException, NullStoreURLException {
        TrustManagerFactory truestMgrFactory = null;
        truestMgrFactory = TrustManagerFactory.getInstance(this.keyManagementAlgorithm);
        KeyStore keyStore = this.getKeyStore(this.trustStoreURL);
        truestMgrFactory.init(keyStore);
        return truestMgrFactory;
    }

    private KeyManagerFactory getKeyManagerFactory() throws NoSuchAlgorithmException, KeyStoreException, IOException, CertificateException, UnrecoverableKeyException, NullStoreURLException {
        KeyManagerFactory keyMgrFactory = null;
        keyMgrFactory = KeyManagerFactory.getInstance(this.keyManagementAlgorithm);
        KeyStore keyStore = this.getKeyStore(this.keyStoreURL);
        keyMgrFactory.init(keyStore, this.keyPassword);
        return keyMgrFactory;
    }

    private KeyStore getKeyStore(URL storeURL) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, NullStoreURLException {
        KeyStore keyStore = KeyStore.getInstance(this.keyStoreType);
        if (storeURL == null) {
            throw new NullStoreURLException("Can not find store file for url because store url is null.");
        }
        InputStream is = storeURL.openStream();
        keyStore.load(is, this.keyStorePassword);
        if (this.keyPassword == null || this.keyPassword.length > 0) {
            this.keyPassword = this.keyStorePassword;
        }
        return keyStore;
    }

    public void setKeyStoreURL(String storeURL) throws IOException {
        this.keyStoreURL = this.validateStoreURL(storeURL);
    }

    public void setTrustStoreURL(String storeURL) throws IOException {
        this.trustStoreURL = this.validateStoreURL(storeURL);
    }

    private URL validateStoreURL(String storeURL) throws IOException {
        File tst;
        URL url = null;
        try {
            url = new URL(storeURL);
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        if (url == null && (tst = new File(storeURL)).exists()) {
            url = tst.toURL();
        }
        if (url == null) {
            ClassLoader loader = SSLSocketBuilder.getContextClassLoader();
            url = loader.getResource(storeURL);
        }
        if (url == null) {
            String msg = "Failed to find url=" + storeURL + " as a URL, file or resource";
            throw new MalformedURLException(msg);
        }
        return url;
    }

    public void create() throws Exception {
    }

    public void start() throws Exception {
    }

    public void stop() {
    }

    public void destroy() {
    }

    static ClassLoader getContextClassLoader() {
        ClassLoader loader = (ClassLoader)AccessController.doPrivileged(GetTCLAction.ACTION);
        return loader;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class NullStoreURLException
    extends Exception {
        public NullStoreURLException(String message) {
            super(message);
        }
    }

    private static class UserModeSSLServerSocketFactory
    extends ServerSocketFactory {
        SSLServerSocketFactory serverSocketFactory;

        public UserModeSSLServerSocketFactory(SSLServerSocketFactory serverSocketFactory) {
            this.serverSocketFactory = serverSocketFactory;
        }

        public ServerSocket createServerSocket() throws IOException {
            SSLServerSocket ss = (SSLServerSocket)this.serverSocketFactory.createServerSocket();
            ss.setUseClientMode(true);
            return ss;
        }

        public ServerSocket createServerSocket(int arg0) throws IOException {
            SSLServerSocket ss = (SSLServerSocket)this.serverSocketFactory.createServerSocket(arg0);
            ss.setUseClientMode(true);
            return ss;
        }

        public ServerSocket createServerSocket(int arg0, int arg1) throws IOException {
            SSLServerSocket ss = (SSLServerSocket)this.serverSocketFactory.createServerSocket(arg0, arg1);
            ss.setUseClientMode(true);
            return ss;
        }

        public ServerSocket createServerSocket(int arg0, int arg1, InetAddress arg2) throws IOException {
            SSLServerSocket ss = (SSLServerSocket)this.serverSocketFactory.createServerSocket(arg0, arg1, arg2);
            ss.setUseClientMode(true);
            return ss;
        }

        public boolean equals(Object obj) {
            return this.serverSocketFactory.equals(obj);
        }

        public String[] getDefaultCipherSuites() {
            return this.serverSocketFactory.getDefaultCipherSuites();
        }

        public String[] getSupportedCipherSuites() {
            return this.serverSocketFactory.getSupportedCipherSuites();
        }

        public int hashCode() {
            return this.serverSocketFactory.hashCode();
        }

        public String toString() {
            return this.serverSocketFactory.toString();
        }
    }

    private static class GetTCLAction
    implements PrivilegedAction {
        static PrivilegedAction ACTION = new GetTCLAction();

        private GetTCLAction() {
        }

        public Object run() {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            return loader;
        }
    }
}

