/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.logging.Logger;
import org.jboss.remoting.CannotConnectException;
import org.jboss.remoting.ConnectionFailedException;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.InvocationResponse;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.RemoteClientInvoker;
import org.jboss.remoting.Version;
import org.jboss.remoting.marshal.MarshalFactory;
import org.jboss.remoting.marshal.Marshaller;
import org.jboss.remoting.marshal.UnMarshaller;
import org.jboss.remoting.marshal.compress.CompressingUnMarshaller;
import org.jboss.remoting.transport.web.WebUtil;
import org.jboss.util.Base64;

public class HTTPClientInvoker
extends RemoteClientInvoker {
    protected final Logger log = Logger.getLogger(this.getClass());

    public HTTPClientInvoker(InvokerLocator locator) {
        super(locator);
    }

    public HTTPClientInvoker(InvokerLocator locator, Map configuration) {
        super(locator, configuration);
    }

    protected Object transport(String sessionId, Object invocation, Map metadata, Marshaller marshaller, UnMarshaller unmarshaller) throws IOException, ConnectionFailedException {
        String targetURL = this.getLocator().getOriginalURI();
        Object httpResponse = this.useHttpURLConnection(targetURL, invocation, metadata, marshaller, unmarshaller);
        return httpResponse;
    }

    private Object useHttpURLConnection(String url, Object invocation, Map metadata, Marshaller marshaller, UnMarshaller unmarshaller) {
        Object result = null;
        try {
            Map header;
            String validatedUrl = this.validateURL(url);
            if (metadata == null) {
                metadata = new HashMap<String, Object>();
            }
            HttpURLConnection conn = this.createURLConnection(validatedUrl, metadata);
            this.setTimeout(this.configuration, conn);
            this.setChunked(this.configuration, conn);
            String basicAuth = this.getBasicAuth(metadata);
            if (basicAuth != null) {
                conn.setRequestProperty("Authorization", basicAuth);
            }
            if ((result = this.checkForLeasePing(conn, invocation, metadata)) != null) {
                return result;
            }
            boolean sendingData = true;
            String type = "POST";
            if (metadata != null) {
                type = (String)metadata.get("TYPE");
                if (type != null) {
                    if (!type.equals("POST") && !type.equals("PUT")) {
                        sendingData = false;
                    }
                } else {
                    type = "POST";
                }
            } else {
                metadata = new HashMap();
                header = new HashMap<String, String>();
                header.put("Content-Type", WebUtil.getContentType(invocation));
                metadata.put("HEADER", header);
            }
            if ((header = (Map)metadata.get("HEADER")) != null) {
                Set keys = header.keySet();
                Iterator itr = keys.iterator();
                while (itr.hasNext()) {
                    String key = (String)itr.next();
                    String value = (String)header.get(key);
                    this.log.debug((Object)("Setting request header with " + key + " : " + value));
                    conn.setRequestProperty(key, value);
                }
            } else {
                conn.setRequestProperty("Content-Type", WebUtil.getContentType(invocation));
            }
            conn.setRequestProperty("JBoss-Remoting-Version", new Integer(Version.getDefaultVersion()).toString());
            conn.setRequestProperty("User-Agent", "JBossRemoting - 2.0.0 Beta2 (Boon)");
            if (sendingData) {
                conn.setDoOutput(true);
                conn.setDoInput(true);
                conn.setRequestMethod(type);
                OutputStream stream = conn.getOutputStream();
                marshaller.write(invocation, stream);
                int responseCode = conn.getResponseCode();
                InputStream is = responseCode < 400 ? conn.getInputStream() : conn.getErrorStream();
                Map<String, List<String>> headers = conn.getHeaderFields();
                if (metadata == null) {
                    metadata = new HashMap();
                }
                metadata.putAll(headers);
                metadata.put("ResponseCodeMessage", conn.getResponseMessage());
                metadata.put("ResponseCode", new Integer(responseCode));
                result = this.readResponse(metadata, headers, unmarshaller, is);
            } else {
                conn.setDoOutput(false);
                conn.setDoInput(true);
                conn.setRequestMethod(type);
                conn.connect();
                InputStream is = conn.getResponseCode() < 400 ? conn.getInputStream() : conn.getErrorStream();
                Map<String, List<String>> headers = conn.getHeaderFields();
                result = this.readResponse(null, headers, unmarshaller, is);
                if (metadata == null) {
                    metadata = new HashMap();
                }
                metadata.putAll(headers);
                metadata.put("ResponseCodeMessage", conn.getResponseMessage());
                int responseCode = conn.getResponseCode();
                metadata.put("ResponseCode", new Integer(responseCode));
            }
        }
        catch (Exception e) {
            this.log.debug((Object)"Error invoking http client invoker.", (Throwable)e);
            throw new CannotConnectException("Can not connect http client invoker.", e);
        }
        return result;
    }

    private Object checkForLeasePing(HttpURLConnection conn, Object invocation, Map metadata) throws IOException {
        InvocationRequest request;
        Object payload;
        InvocationResponse response = null;
        boolean shouldLease = false;
        long leasePeriod = -1L;
        if (invocation != null && invocation instanceof InvocationRequest && (payload = (request = (InvocationRequest)invocation).getParameter()) != null && payload instanceof String && "$PING$".equalsIgnoreCase((String)payload) && request.getReturnPayload() != null) {
            try {
                conn.setDoOutput(false);
                conn.setDoInput(true);
                conn.setRequestMethod("HEAD");
                conn.connect();
                Map<String, List<String>> headers = conn.getHeaderFields();
                if (headers != null) {
                    List<String> leasingPeriod;
                    List<String> leasingEnabled = headers.get("LEASING_ENABLED");
                    if (leasingEnabled != null && leasingEnabled instanceof List) {
                        shouldLease = new Boolean(leasingEnabled.get(0));
                    }
                    if ((leasingPeriod = headers.get("LEASE_PERIOD")) != null && leasingPeriod instanceof List) {
                        leasePeriod = new Long(leasingPeriod.get(0));
                    }
                }
            }
            catch (IOException e) {
                this.log.error((Object)"Error checking server for lease information.", (Throwable)e);
            }
            HashMap<String, Long> p = new HashMap<String, Long>();
            p.put("clientLeasePeriod", new Long(leasePeriod));
            InvocationResponse innterResponse = new InvocationResponse(null, new Boolean(shouldLease), false, p);
            response = new InvocationResponse(null, innterResponse, false, null);
        }
        return response;
    }

    private Object readResponse(Map metadata, Map headers, UnMarshaller unmarshaller, InputStream is) throws IOException, ClassNotFoundException {
        String encoding = null;
        Object ceObj = headers.get("Content-Encoding");
        if (ceObj != null && ceObj instanceof List) {
            encoding = (String)((List)ceObj).get(0);
        }
        if (encoding != null && encoding.indexOf("gzip") >= 0) {
            unmarshaller = new CompressingUnMarshaller(MarshalFactory.getUnMarshaller("serializable"));
        }
        Object result = unmarshaller.read(is, metadata == null ? headers : metadata);
        return result;
    }

    private void setChunked(Map metadata, HttpURLConnection conn) {
        String chunkedValue = (String)metadata.get("chunkedLength");
        if (chunkedValue != null && chunkedValue.length() > 0) {
            try {
                int chunkedLength = Integer.parseInt(chunkedValue);
                try {
                    Method setChunkedLengthMethod = conn.getClass().getMethod("setChunkedStreamingMode", Integer.TYPE);
                    setChunkedLengthMethod.invoke((Object)conn, new Integer(chunkedLength));
                }
                catch (NoSuchMethodException e) {
                    this.log.warn((Object)("Could not set chunked length (" + chunkedLength + ") on http client transport as method not available with JDK 1.4 (only JDK 1.5 or higher)"));
                }
                catch (IllegalAccessException e) {
                    this.log.error((Object)"Error setting http client connection chunked length.");
                    this.log.debug((Object)e);
                }
                catch (InvocationTargetException e) {
                    this.log.error((Object)"Error setting http client connection chunked length.");
                    this.log.debug((Object)e);
                }
            }
            catch (NumberFormatException e) {
                this.log.error((Object)("Could not set chunked length for http client connection because value (" + chunkedValue + ") is not a number."));
            }
        }
    }

    private void setTimeout(Map metadata, HttpURLConnection conn) {
        String timeoutValue = (String)metadata.get("timeout");
        if (timeoutValue != null && timeoutValue.length() > 0) {
            try {
                int timeout = Integer.parseInt(timeoutValue);
                try {
                    Method setTimeoutMethod = conn.getClass().getMethod("setConnectTimeout", Integer.TYPE);
                    setTimeoutMethod.invoke((Object)conn, new Integer(timeout));
                    setTimeoutMethod = conn.getClass().getMethod("setReadTimeout", Integer.TYPE);
                    setTimeoutMethod.invoke((Object)conn, new Integer(timeout));
                }
                catch (NoSuchMethodException e) {
                    this.log.warn((Object)("Could not set timeout (" + timeout + ") on http client transport as method not available with JDK 1.4 (only JDK 1.5 or higher)"));
                }
                catch (IllegalAccessException e) {
                    this.log.error((Object)"Error setting http client connection timeout.");
                    this.log.debug((Object)e);
                }
                catch (InvocationTargetException e) {
                    this.log.error((Object)"Error setting http client connection timeout.");
                    this.log.debug((Object)e);
                }
            }
            catch (NumberFormatException e) {
                this.log.error((Object)("Could not set timeout for http client connection because value (" + timeoutValue + ") is not a number."));
            }
        }
    }

    private String validateURL(String url) {
        String validatedUrl = url;
        if (validatedUrl.startsWith("servlet")) {
            validatedUrl = "http" + validatedUrl.substring("servlet".length());
        }
        return validatedUrl;
    }

    protected HttpURLConnection createURLConnection(String url, Map metadata) throws IOException {
        URL externalURL = null;
        HttpURLConnection httpURLConn = null;
        String proxyHost = null;
        String proxyportString = null;
        int proxyPort = -1;
        boolean proxyOn = true;
        if (metadata != null) {
            proxyHost = (String)metadata.get("http.proxyHost");
            proxyportString = (String)metadata.get("http.proxyPort");
            if (proxyportString != null && proxyportString.length() > 0) {
                try {
                    proxyPort = Integer.parseInt(proxyportString);
                }
                catch (NumberFormatException e) {
                    this.log.warn((Object)("Error converting proxy port specified (" + proxyportString + ") to a number."));
                }
            }
        }
        if (proxyHost == null) {
            String proxyOnString;
            proxyHost = System.getProperty("http.proxyHost");
            if (proxyHost == null) {
                proxyHost = System.getProperty("proxyHost");
            }
            if ((proxyOnString = System.getProperty("http.proxySet")) == null) {
                proxyOnString = System.getProperty("proxySet");
            }
            if (proxyOnString != null) {
                proxyOn = Boolean.getBoolean(proxyOnString);
            }
        }
        if (proxyPort < 0) {
            String proxyPortString = System.getProperty("http.proxyPort");
            if (proxyPortString == null) {
                proxyPortString = System.getProperty("proxyPort");
            }
            if (proxyPortString != null) {
                try {
                    proxyPort = Integer.parseInt(proxyPortString);
                }
                catch (NumberFormatException e) {
                    this.log.warn((Object)("Error converting proxy port specified (" + proxyportString + ") to a number."));
                }
            }
        }
        if (proxyHost != null && proxyOn) {
            externalURL = new URL("http", proxyHost, proxyPort, url);
            httpURLConn = (HttpURLConnection)externalURL.openConnection();
            String proxyAuth = this.getProxyAuth(metadata);
            if (proxyAuth != null) {
                httpURLConn.setRequestProperty("Proxy-Authorization", proxyAuth);
            }
        } else {
            externalURL = new URL(url);
            httpURLConn = (HttpURLConnection)externalURL.openConnection();
        }
        return httpURLConn;
    }

    private String getProxyAuth(Map metadata) {
        String authString = null;
        String username = null;
        String password = null;
        if (metadata != null) {
            username = (String)metadata.get("http.proxy.username");
        }
        if (username == null || username.length() == 0) {
            username = System.getProperty("http.proxy.username");
        }
        if (metadata != null) {
            password = (String)metadata.get("http.proxy.password");
        }
        if (password == null || password.length() == 0) {
            password = System.getProperty("http.proxy.password");
        }
        if (username != null && password != null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(username);
            buffer.append(":");
            buffer.append(password);
            String encoded = Base64.encodeBytes((byte[])buffer.toString().getBytes());
            authString = "Basic " + encoded;
        }
        return authString;
    }

    private String getBasicAuth(Map metadata) {
        String authString = null;
        String username = null;
        String password = null;
        if (metadata != null) {
            username = (String)metadata.get("http.basic.username");
        }
        if (username == null || username.length() == 0) {
            username = System.getProperty("http.basic.username");
        }
        if (metadata != null) {
            password = (String)metadata.get("http.basic.password");
        }
        if (password == null || password.length() == 0) {
            password = System.getProperty("http.basic.password");
        }
        if (username != null && password != null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(username);
            buffer.append(":");
            buffer.append(password);
            String encoded = Base64.encodeBytes((byte[])buffer.toString().getBytes());
            authString = "Basic " + encoded;
        }
        return authString;
    }

    protected void handleConnect() throws ConnectionFailedException {
    }

    protected void handleDisconnect() {
    }

    protected String getDefaultDataType() {
        return "http";
    }
}

