/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.http.ssl;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.util.Map;
import javax.net.SocketFactory;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.security.SSLSocketBuilder;
import org.jboss.remoting.transport.http.HTTPClientInvoker;
import org.jboss.remoting.transport.http.ssl.HTTPSSocketFactory;

public class HTTPSClientInvoker
extends HTTPClientInvoker {
    public static final String IGNORE_HTTPS_HOST = "org.jboss.security.ignoreHttpsHost";

    public HTTPSClientInvoker(InvokerLocator locator) {
        super(locator);
    }

    public HTTPSClientInvoker(InvokerLocator locator, Map configuration) {
        super(locator, configuration);
    }

    protected HttpURLConnection createURLConnection(String url, Map metadata) throws IOException {
        HttpURLConnection conn = super.createURLConnection(url, metadata);
        boolean ignoreHTTPSHost = Boolean.getBoolean(IGNORE_HTTPS_HOST);
        String ignoreHost = (String)metadata.get(IGNORE_HTTPS_HOST);
        if (ignoreHost != null && ignoreHost.length() > 0) {
            ignoreHTTPSHost = Boolean.valueOf(ignoreHost);
        }
        if (conn instanceof HttpsURLConnection) {
            HttpsURLConnection sconn = (HttpsURLConnection)conn;
            SocketFactory socketFactory = this.getSocketFactory();
            if (socketFactory != null && socketFactory instanceof SSLSocketFactory) {
                SSLSocketFactory sslSocketFactory = this.getHandshakeCompatibleFactory((SSLSocketFactory)socketFactory, metadata);
                sconn.setSSLSocketFactory(sslSocketFactory);
            }
            if (ignoreHTTPSHost) {
                sconn.setHostnameVerifier(new AnyhostVerifier());
            }
        }
        return conn;
    }

    private SSLSocketFactory getHandshakeCompatibleFactory(SSLSocketFactory socketFactory, Map metadata) {
        SSLSocketFactory sslSocketFactory = socketFactory;
        Object obj = this.configuration.get("HANDSHAKE_COMPLETED_LISTENER");
        if (obj != null && obj instanceof HandshakeCompletedListener) {
            HandshakeCompletedListener listener = (HandshakeCompletedListener)obj;
            sslSocketFactory = new HTTPSSocketFactory(socketFactory, listener);
        }
        return sslSocketFactory;
    }

    protected SocketFactory createSocketFactory(Map configuration) {
        SocketFactory sf = super.createSocketFactory(configuration);
        if (sf != null) {
            return sf;
        }
        try {
            SSLSocketBuilder server = new SSLSocketBuilder();
            sf = server.createSSLSocketFactory();
        }
        catch (Exception e) {
            this.log.error((Object)"Error creating SSL Socket Factory for client invoker.", (Throwable)e);
        }
        return sf;
    }

    private class AnyhostVerifier
    implements HostnameVerifier {
        private AnyhostVerifier() {
        }

        public boolean verify(String s, SSLSession sslSession) {
            return true;
        }
    }
}

