/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.local;

import java.util.Map;
import org.jboss.remoting.AbstractInvoker;
import org.jboss.remoting.ConnectionFailedException;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.InvokerRegistry;
import org.jboss.remoting.ServerInvoker;
import org.jboss.remoting.marshal.Marshaller;
import org.jboss.remoting.marshal.UnMarshaller;
import org.jboss.remoting.transport.BidirectionalClientInvoker;

public class LocalClientInvoker
extends AbstractInvoker
implements BidirectionalClientInvoker {
    private ServerInvoker serverInvoker;
    private boolean isConnected = false;

    public LocalClientInvoker(InvokerLocator locator) {
        super(locator);
    }

    public LocalClientInvoker(InvokerLocator locator, Map configuration) {
        super(locator, configuration);
    }

    public Object invoke(InvocationRequest invocation) throws Throwable {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"Using local client invoker for invocation.");
        }
        Object ret = null;
        if (this.serverInvoker != null) {
            try {
                ret = this.serverInvoker.invoke(invocation);
            }
            catch (ServerInvoker.InvalidStateException invalidStateEx) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("Error calling on " + this.serverInvoker + " because is in invalid state.  Will retry with new server invoker."));
                }
                ServerInvoker newServerInvoker = null;
                ServerInvoker[] invokers = InvokerRegistry.getServerInvokers();
                if (invokers != null) {
                    for (int x = 0; x < invokers.length; ++x) {
                        ServerInvoker svrinvoker = invokers[x];
                        InvokerLocator svrlocator = svrinvoker.getLocator();
                        if (!this.getLocator().equals(svrlocator)) continue;
                        newServerInvoker = svrinvoker;
                        break;
                    }
                }
                if (newServerInvoker != null) {
                    this.serverInvoker = newServerInvoker;
                    ret = this.serverInvoker.invoke(invocation);
                }
                throw invalidStateEx;
            }
        } else {
            throw new ConnectionFailedException("Error invoking on server because no local server to call upon.");
        }
        return ret;
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public void connect() throws ConnectionFailedException {
        this.isConnected = true;
    }

    public void disconnect() {
        this.isConnected = false;
    }

    public void setMarshaller(Marshaller marshaller) {
    }

    public Marshaller getMarshaller() {
        return null;
    }

    public void setUnMarshaller(UnMarshaller unmarshaller) {
    }

    public UnMarshaller getUnMarshaller() {
        return null;
    }

    public void setServerInvoker(ServerInvoker svrInvoker) {
        this.serverInvoker = svrInvoker;
    }

    public InvokerLocator getCallbackLocator(Map metadata) {
        String transport = (String)metadata.get("CALLBACK_SERVER_PROTOCOL");
        String host = (String)metadata.get("CALLBACK_SERVER_HOST");
        String sPort = (String)metadata.get("CALLBACK_SERVER_PORT");
        int port = -1;
        if (sPort != null) {
            try {
                port = Integer.parseInt(sPort);
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Can not set internal callback server port as configuration value (" + sPort + " is not a number.");
            }
        }
        return new InvokerLocator(transport, host, port, "callback", metadata);
    }
}

