/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.socket;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.net.Socket;
import java.net.SocketException;
import java.util.LinkedList;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.remoting.ServerInvoker;
import org.jboss.remoting.Version;
import org.jboss.remoting.marshal.MarshalFactory;
import org.jboss.remoting.marshal.Marshaller;
import org.jboss.remoting.marshal.UnMarshaller;
import org.jboss.remoting.transport.socket.LRUPool;
import org.jboss.remoting.transport.socket.SocketServerInvoker;
import org.jboss.remoting.transport.socket.SocketWrapper;

public class ServerThread
extends Thread {
    private static final Logger log = Logger.getLogger((Class)(class$org$jboss$remoting$transport$socket$ServerThread == null ? (class$org$jboss$remoting$transport$socket$ServerThread = ServerThread.class$("org.jboss.remoting.transport.socket.ServerThread")) : class$org$jboss$remoting$transport$socket$ServerThread));
    protected SocketServerInvoker invoker;
    protected LRUPool clientpool;
    protected LinkedList threadpool;
    protected volatile boolean running = true;
    protected volatile boolean handlingResponse = true;
    protected volatile boolean shutdown = false;
    protected static int id = 0;
    private SocketWrapper socketWrapper = null;
    protected String serverSocketClass = (class$org$jboss$remoting$transport$socket$ServerSocketWrapper == null ? (class$org$jboss$remoting$transport$socket$ServerSocketWrapper = ServerThread.class$("org.jboss.remoting.transport.socket.ServerSocketWrapper")) : class$org$jboss$remoting$transport$socket$ServerSocketWrapper).getName();
    private Constructor serverSocketConstructor = null;
    private boolean shouldCheckConnection = false;
    static /* synthetic */ Class class$org$jboss$remoting$transport$socket$ServerThread;
    static /* synthetic */ Class class$org$jboss$remoting$transport$socket$ServerSocketWrapper;
    static /* synthetic */ Class class$java$net$Socket;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$java$lang$Integer;

    public static synchronized int nextID() {
        int nextID = id++;
        return nextID;
    }

    public ServerThread(Socket socket, SocketServerInvoker invoker, LRUPool clientpool, LinkedList threadpool, int timeout, String serverSocketClass) throws Exception {
        super("SocketServerInvokerThread-" + socket.getInetAddress().getHostAddress() + "-" + ServerThread.nextID());
        this.serverSocketClass = serverSocketClass;
        this.socketWrapper = this.createServerSocket(socket, timeout, invoker.getLocator().getParameters());
        this.invoker = invoker;
        this.clientpool = clientpool;
        this.threadpool = threadpool;
        this.init();
    }

    private void init() {
        Map configMap;
        String checkValue;
        if (this.invoker != null && (checkValue = (String)(configMap = this.invoker.getConfiguration()).get("socket.check_connection")) != null && checkValue.length() > 0) {
            this.shouldCheckConnection = Boolean.valueOf(checkValue);
        }
    }

    public void shutdown() {
        this.shutdown = true;
        this.running = false;
        if (!this.handlingResponse) {
            try {
                this.interrupt();
                Thread.interrupted();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void shouldCheckConnection(boolean checkConnection) {
        this.shouldCheckConnection = checkConnection;
    }

    public boolean getCheckingConnection() {
        return this.shouldCheckConnection;
    }

    private SocketWrapper createServerSocket(Socket socket, int timeout, Map metadata) throws Exception {
        if (this.serverSocketConstructor == null) {
            ClassLoader classLoader = null;
            if (classLoader == null && (classLoader = Thread.currentThread().getContextClassLoader()) == null) {
                classLoader = this.getClass().getClassLoader();
            }
            Class<?> cl = classLoader.loadClass(this.serverSocketClass);
            try {
                this.serverSocketConstructor = cl.getConstructor(class$java$net$Socket == null ? (class$java$net$Socket = ServerThread.class$("java.net.Socket")) : class$java$net$Socket, class$java$util$Map == null ? (class$java$util$Map = ServerThread.class$("java.util.Map")) : class$java$util$Map, class$java$lang$Integer == null ? (class$java$lang$Integer = ServerThread.class$("java.lang.Integer")) : class$java$lang$Integer);
            }
            catch (NoSuchMethodException e) {
                this.serverSocketConstructor = cl.getConstructor(class$java$net$Socket == null ? (class$java$net$Socket = ServerThread.class$("java.net.Socket")) : class$java$net$Socket);
            }
        }
        SocketWrapper serverSocketWrapper = null;
        if (this.serverSocketConstructor.getParameterTypes().length == 3) {
            serverSocketWrapper = (SocketWrapper)this.serverSocketConstructor.newInstance(socket, metadata, new Integer(timeout));
        } else {
            serverSocketWrapper = (SocketWrapper)this.serverSocketConstructor.newInstance(socket);
            serverSocketWrapper.setTimeout(timeout);
        }
        return serverSocketWrapper;
    }

    public void evict() {
        this.running = false;
        if (!this.handlingResponse) {
            try {
                this.interrupt();
                Thread.interrupted();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public synchronized void wakeup(Socket socket, int timeout, Map metadata) throws Exception {
        this.socketWrapper = this.createServerSocket(socket, timeout, metadata);
        this.running = true;
        this.handlingResponse = true;
        this.notify();
        if (log.isTraceEnabled()) {
            log.trace((Object)("Have woken up " + this.getName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            while (true) {
                this.dorun();
                ServerThread serverThread = this;
                synchronized (serverThread) {
                    LRUPool lRUPool = this.clientpool;
                    synchronized (lRUPool) {
                        LinkedList linkedList = this.threadpool;
                        synchronized (linkedList) {
                            if (this.shutdown) {
                                this.invoker = null;
                                return;
                            }
                            if (log.isTraceEnabled()) {
                                log.trace((Object)("removing from clientpool and adding to threadpool " + this));
                            }
                            this.clientpool.remove(this);
                            this.threadpool.add(this);
                            Thread.interrupted();
                            ((Object)((Object)this.clientpool)).notify();
                        }
                    }
                    try {
                        if (log.isTraceEnabled()) {
                            log.trace((Object)"begin thread wait");
                        }
                        this.wait();
                        if (log.isTraceEnabled()) {
                            log.trace((Object)"WAKEUP in SERVER THREAD");
                        }
                    }
                    catch (InterruptedException e) {
                        if (this.shutdown) {
                            this.invoker = null;
                            return;
                        }
                        throw e;
                    }
                }
            }
        }
        catch (Exception ignored) {
            log.debug((Object)"Exiting run on exception", (Throwable)ignored);
            return;
        }
    }

    protected void acknowledge() throws Exception {
        if (this.shouldCheckConnection) {
            this.handlingResponse = true;
            try {
                this.socketWrapper.checkConnection();
            }
            catch (EOFException e) {
                throw new AcknowledgeFailure();
            }
            catch (SocketException se) {
                throw new AcknowledgeFailure();
            }
            catch (IOException ioe) {
                throw new AcknowledgeFailure();
            }
            this.handlingResponse = false;
        }
    }

    protected Object versionedRead(InputStream inputStream, ServerInvoker invoker, ClassLoader classLoader, int version) throws IOException, ClassNotFoundException {
        switch (version) {
            case 1: 
            case 2: {
                UnMarshaller unmarshaller = MarshalFactory.getUnMarshaller(invoker.getLocator(), classLoader);
                if (unmarshaller == null) {
                    unmarshaller = MarshalFactory.getUnMarshaller(invoker.getDataType(), invoker.getSerializationType());
                }
                return unmarshaller.read(inputStream, null);
            }
        }
        throw new IOException("Can not read data for version " + version + ".  Supported versions: " + 1 + "," + 2);
    }

    protected void processInvocation() throws Exception {
        if (log.isTraceEnabled()) {
            log.trace((Object)"processing invocation in server thread.");
        }
        this.handlingResponse = true;
        int version = Version.getDefaultVersion();
        boolean performVersioning = Version.performVersioning();
        InputStream inputStream = this.socketWrapper.getInputStream();
        if (performVersioning && (version = this.readVersion(inputStream)) == -1) {
            version = 1;
        }
        Object obj = this.versionedRead(inputStream, this.invoker, this.getClass().getClassLoader(), version);
        Object resp = null;
        try {
            boolean interrupted = Thread.interrupted();
            resp = this.invoker.invoke(obj);
        }
        catch (Exception ex) {
            resp = ex;
        }
        Thread.interrupted();
        OutputStream outputStream = this.socketWrapper.getOutputStream();
        if (performVersioning) {
            this.writeVersion(outputStream, version);
        }
        this.versionedWrite(outputStream, this.invoker, this.getClass().getClassLoader(), resp, version);
        this.handlingResponse = false;
    }

    private void versionedWrite(OutputStream outputStream, SocketServerInvoker invoker, ClassLoader classLoader, Object resp, int version) throws IOException {
        switch (version) {
            case 1: 
            case 2: {
                Marshaller marshaller = MarshalFactory.getMarshaller(invoker.getLocator(), classLoader);
                if (marshaller == null) {
                    marshaller = MarshalFactory.getMarshaller(invoker.getDataType(), invoker.getSerializationType());
                }
                marshaller.write(resp, outputStream);
                return;
            }
        }
        throw new IOException("Can not write data for version " + version + ".  Supported version: " + 1 + ", " + 2);
    }

    private int readVersion(InputStream inputStream) throws IOException {
        return inputStream.read();
    }

    private void writeVersion(OutputStream outputStream, int version) throws IOException {
        outputStream.write(version);
    }

    protected void dorun() {
        if (log.isTraceEnabled()) {
            log.trace((Object)"beginning dorun");
        }
        this.running = true;
        this.handlingResponse = true;
        try {
            this.processInvocation();
        }
        catch (Exception ex) {
            log.error((Object)"failed to process invocation.", (Throwable)ex);
            this.running = false;
        }
        while (this.running) {
            block23: {
                try {
                    this.acknowledge();
                    this.processInvocation();
                }
                catch (AcknowledgeFailure e) {
                    if (!this.shutdown) {
                        log.trace((Object)"Keep alive acknowledge failed.");
                    }
                    this.running = false;
                }
                catch (InterruptedIOException e) {
                    if (!this.shutdown) {
                        log.error((Object)"socket timed out", (Throwable)e);
                    }
                    this.running = false;
                }
                catch (InterruptedException e) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)e);
                    }
                    if (!this.shutdown) {
                        log.error((Object)"interrupted", (Throwable)e);
                    }
                }
                catch (EOFException eof) {
                    if (!this.shutdown) {
                        log.trace((Object)"EOF received.  This is likely due to client finishing comminication.");
                    }
                    this.running = false;
                }
                catch (SocketException sex) {
                    if (!this.shutdown) {
                        log.trace((Object)"SocketException received.  This is likely due to client disconnecting and resetting connection.");
                    }
                    this.running = false;
                }
                catch (Exception ex) {
                    if (this.shutdown) break block23;
                    log.error((Object)"failed", (Throwable)ex);
                    this.running = false;
                }
            }
            this.handlingResponse = false;
            Thread.interrupted();
        }
        try {
            OutputStream out;
            InputStream in = this.socketWrapper.getInputStream();
            if (in != null) {
                in.close();
            }
            if ((out = this.socketWrapper.getOutputStream()) != null) {
                out.close();
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            this.socketWrapper.close();
        }
        catch (Exception ex) {
            log.error((Object)"Failed cleanup", (Throwable)ex);
        }
        this.socketWrapper = null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class AcknowledgeFailure
    extends Exception {
    }
}

