/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.socket.ssl;

import java.io.IOException;
import java.net.Socket;
import java.util.Map;
import javax.net.SocketFactory;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLSocket;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.security.SSLSocketBuilder;
import org.jboss.remoting.transport.socket.SocketClientInvoker;
import org.jboss.remoting.util.socket.HandshakeRepeater;

public class SSLSocketClientInvoker
extends SocketClientInvoker {
    private boolean useClientMode = true;

    public SSLSocketClientInvoker(InvokerLocator locator) throws IOException {
        super(locator);
        try {
            this.setup();
        }
        catch (Exception ex) {
            this.log.error((Object)"Error setting up ssl socket client invoker.", (Throwable)ex);
            throw new RuntimeException(ex.getMessage());
        }
    }

    public SSLSocketClientInvoker(InvokerLocator locator, Map configuration) throws IOException {
        super(locator, configuration);
        try {
            this.setup();
        }
        catch (Exception ex) {
            this.log.error((Object)"Error setting up ssl socket client invoker.", (Throwable)ex);
            throw new RuntimeException(ex.getMessage());
        }
    }

    public void setUseClientMode(boolean clientMode) {
        this.useClientMode = clientMode;
    }

    public boolean getUseClientMode() {
        return this.useClientMode;
    }

    protected SocketFactory createSocketFactory(Map configuration) {
        SocketFactory sf = super.createSocketFactory(configuration);
        if (sf != null) {
            return sf;
        }
        try {
            SSLSocketBuilder server = new SSLSocketBuilder();
            sf = server.createSSLSocketFactory();
        }
        catch (Exception e) {
            this.log.error((Object)"Error creating SSL Socket Factory for client invoker.", (Throwable)e);
        }
        return sf;
    }

    protected Socket createSocket(String address, int port) throws IOException {
        Socket s;
        SocketFactory sf = this.getSocketFactory();
        if (sf == null) {
            this.createSocketFactory(this.configuration);
        }
        if ((s = sf.createSocket(address, port)) instanceof SSLSocket) {
            Object obj;
            if (!this.useClientMode) {
                ((SSLSocket)s).setUseClientMode(this.useClientMode);
            }
            if ((obj = this.configuration.get("HANDSHAKE_COMPLETED_LISTENER")) != null && obj instanceof HandshakeCompletedListener) {
                SSLSocket sslSocket = (SSLSocket)s;
                HandshakeCompletedListener listener = (HandshakeCompletedListener)obj;
                this.establishHandshake(sslSocket, listener);
            }
        }
        return s;
    }

    private void establishHandshake(SSLSocket sslSocket, HandshakeCompletedListener listener) throws IOException {
        HandshakeRepeater repeater = new HandshakeRepeater(listener);
        sslSocket.addHandshakeCompletedListener(repeater);
        sslSocket.getSession();
        repeater.waitForHandshake();
    }
}

