/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.socket.ssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.Map;
import javax.net.ServerSocketFactory;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.transport.socket.SocketServerInvoker;
import org.jboss.remoting.transport.socket.ssl.SSLSocketServerInvokerMBean;

public class SSLSocketServerInvoker
extends SocketServerInvoker
implements SSLSocketServerInvokerMBean {
    protected ServerSocketFactory serverSocketFactory = null;
    private boolean useClientMode = false;

    public SSLSocketServerInvoker(InvokerLocator locator) {
        super(locator);
    }

    public SSLSocketServerInvoker(InvokerLocator locator, Map configuration) {
        super(locator, configuration);
    }

    public void setUseClientMode(boolean clientMode) {
        this.useClientMode = clientMode;
    }

    public boolean getUseClientMode() {
        return this.useClientMode;
    }

    protected ServerSocketFactory getDefaultServerSocketFactory() {
        return SSLServerSocketFactory.getDefault();
    }

    protected ServerSocket createServerSocket(int serverBindPort, int backlog, InetAddress bindAddress) throws IOException {
        ServerSocket svrSocket = this.getServerSocketFactory().createServerSocket(serverBindPort, backlog, bindAddress);
        if (svrSocket != null && svrSocket instanceof SSLServerSocket && this.getUseClientMode()) {
            ((SSLServerSocket)svrSocket).setUseClientMode(this.useClientMode);
        }
        return svrSocket;
    }
}

