/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.util.socket;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Map;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import org.jboss.remoting.util.socket.RemotingKeyManager;

public class RemotingSSLSocketFactory
extends SSLSocketFactory {
    private SSLContext sslContext = null;
    private Provider provider = null;
    private String providerName = null;
    private String protocol = "TLS";
    private KeyManager[] keyManagers = null;
    private TrustManager[] trustManagers = null;
    private SecureRandom secureRandom = null;
    private SSLSocketFactory socketFactory = null;
    private String keyStoreFilePath = null;
    private String keyStorePassword = null;
    private String keyStoreType = null;
    private String keyAlias = null;
    private String algorithm = null;
    private String trustAlgorithm = null;
    private String trustStoreType = null;
    private String trustStorePassword = null;
    private String trustStoreFilePath = null;
    private Map config = null;
    private boolean useClientMode = true;
    public static final String REMOTING_KEY_STORE_FILE_PATH = "org.jboss.remoting.keyStore";
    public static final String STANDARD_KEY_STORE_FILE_PATH = "javax.net.ssl.keyStore";
    public static final String REMOTING_KEY_STORE_PASSWORD = "org.jboss.remoting.keyStorePassword";
    public static final String STANDARD_KEY_STORE_PASSWORD = "javax.net.ssl.keyStorePassword";
    public static final String DEFAULT_KEY_STORE_TYPE = "JKS";
    public static final String REMOTING_KEY_STORE_TYPE = "org.jboss.remoting.keyStoreType";
    public static final String STANDARD_KEY_STORE_TYPE = "javax.net.ssl.keyStoreType";
    public static final String DEFAULT_ALGORITHM = "SunX509";
    public static final String REMOTING_ALGORITHM = "org.jboss.remoting.algorithm";
    public static final String REMOTING_KEY_ALIAS = "org.jboss.remoting.keyAlias";
    public static final String REMOTING_TRUST_ALGORITHM = "org.jboss.remoting.truststoreAlgorithm";
    public static final String REMOTING_TRUST_STORE_TYPE = "org.jboss.remoting.trustStoreType";
    public static final String STANDARD_TRUST_STORE_TYPE = "javax.net.ssl.trustStoreType";
    public static final String REMOTING_TRUST_STORE_PASSWORD = "org.jboss.remoting.trustStorePassword";
    public static final String STANDARD_TRUST_STORE_PASSWORD = "javax.net.ssl.trustStorePassword";
    public static final String REMOTING_TRUST_STORE_FILE_PATH = "org.jboss.remoting.trustStore";
    public static final String STANDARD_TRUST_STORE_FILE_PATH = "javax.net.ssl.trustStore";
    public static final String REMOTING_USE_CLIENT_MODE = "org.jboss.remoting.useClientMode";

    public RemotingSSLSocketFactory(Map config) {
        this.config = config;
    }

    public void setProtocol(String protocol) {
        if (protocol == null || protocol.length() <= 0) {
            throw new IllegalArgumentException("Can not set remoting socket factory with null protocol");
        }
        this.protocol = protocol;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProvider(Provider provider) {
        this.provider = provider;
    }

    public void setProviderName(String providerName) {
        this.providerName = providerName;
    }

    public Provider getProvider() {
        if (this.provider != null) {
            return this.provider;
        }
        if (this.sslContext != null) {
            return this.sslContext.getProvider();
        }
        return null;
    }

    private void init() throws IOException {
        try {
            this.sslContext = this.provider != null ? SSLContext.getInstance(this.protocol, this.provider) : (this.providerName != null ? SSLContext.getInstance(this.protocol, this.providerName) : SSLContext.getInstance(this.protocol));
            this.keyManagers = this.loadKeyManagers();
            this.trustManagers = this.loadTrustManagers();
            this.secureRandom = this.getSecureRandom();
            this.sslContext.init(this.keyManagers, this.trustManagers, this.secureRandom);
            this.socketFactory = this.sslContext.getSocketFactory();
        }
        catch (Exception e) {
            IOException ioe = new IOException("Error creating Remoting SSL Socket Factory:" + e.getMessage());
            ioe.setStackTrace(e.getStackTrace());
            throw ioe;
        }
    }

    public void setSecureRandom(SecureRandom secureRandom) {
        this.secureRandom = secureRandom;
    }

    private SecureRandom getSecureRandom() {
        if (this.secureRandom != null) {
            return this.secureRandom;
        }
        this.secureRandom = new SecureRandom();
        return this.secureRandom;
    }

    private TrustManager[] loadTrustManagers() throws NoSuchProviderException, NoSuchAlgorithmException, IOException, CertificateException, KeyStoreException {
        TrustManager[] trustManagers = null;
        String tsType = this.getTrustStoreType();
        String tsPasswd = this.getTrustStorePassword();
        String tsPath = this.getTrustStoreFile();
        KeyStore trustStore = this.loadKeyStore(tsType, tsPath, tsPasswd);
        if (trustStore != null) {
            String tsAlg = this.getTrustAlgorithm();
            TrustManagerFactory trustMgrFactory = null;
            trustMgrFactory = this.provider != null ? TrustManagerFactory.getInstance(tsAlg, this.provider) : (this.providerName != null ? TrustManagerFactory.getInstance(tsAlg, this.providerName) : TrustManagerFactory.getInstance(tsAlg));
            trustMgrFactory.init(trustStore);
            trustManagers = trustMgrFactory.getTrustManagers();
        }
        return trustManagers;
    }

    private KeyManager[] loadKeyManagers() throws NoSuchProviderException, NoSuchAlgorithmException, IOException, CertificateException, KeyStoreException, UnrecoverableKeyException {
        KeyStore keyStore;
        KeyManager[] keyManagers = null;
        String ksPath = this.getKeyStoreFile();
        String ksPasswd = this.getKeyStorePassword();
        String ksType = this.getKeyStoreType();
        if (ksPath != null && (keyStore = this.loadKeyStore(ksType, ksPath, ksPasswd)) != null) {
            boolean containsAlias;
            String alg = this.getAlgorithm();
            String alias = this.getKeyAlias();
            if (alias != null && !(containsAlias = keyStore.isKeyEntry(alias))) {
                throw new IOException("Can not find key entry for key store (" + ksPath + ") with given alias (" + alias + ")");
            }
            KeyManagerFactory keyMgrFactory = null;
            keyMgrFactory = this.provider != null ? KeyManagerFactory.getInstance(alg, this.provider) : (this.providerName != null ? KeyManagerFactory.getInstance(alg, this.providerName) : KeyManagerFactory.getInstance(alg));
            keyMgrFactory.init(keyStore, ksPasswd.toCharArray());
            keyManagers = keyMgrFactory.getKeyManagers();
            if (alias != null) {
                for (int x = 0; x < keyManagers.length; ++x) {
                    keyManagers[x] = new RemotingKeyManager((X509KeyManager)keyManagers[x], alias);
                }
            }
        }
        return keyManagers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyStore loadKeyStore(String keyStoreType, String keyStorePath, String keyStorePassword) throws KeyStoreException, NoSuchProviderException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore keyStore;
        block8: {
            keyStore = null;
            keyStore = this.provider != null ? KeyStore.getInstance(keyStoreType, this.provider) : (this.providerName != null ? KeyStore.getInstance(keyStoreType, this.providerName) : KeyStore.getInstance(keyStoreType));
            InputStream keyStoreInputStream = null;
            try {
                if (keyStorePath != null) {
                    keyStoreInputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(keyStorePath);
                    if (keyStoreInputStream == null) {
                        keyStoreInputStream = new FileInputStream(keyStorePath);
                    }
                    char[] password = keyStorePassword != null ? keyStorePassword.toCharArray() : null;
                    keyStore.load(keyStoreInputStream, password);
                }
                Object var8_7 = null;
                if (keyStoreInputStream == null) break block8;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (keyStoreInputStream != null) {
                    try {
                        keyStoreInputStream.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    keyStoreInputStream = null;
                }
                throw throwable;
            }
            try {
                keyStoreInputStream.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            keyStoreInputStream = null;
            {
            }
        }
        return keyStore;
    }

    public void setTrustStoreFile(String trustStoreFilePath) {
        this.trustStoreFilePath = trustStoreFilePath;
    }

    private String getTrustStoreFile() {
        String path;
        if (this.trustStoreFilePath != null) {
            return this.trustStoreFilePath;
        }
        if (this.config != null && (path = (String)this.config.get(REMOTING_TRUST_STORE_FILE_PATH)) != null && path.length() > 0) {
            this.trustStoreFilePath = path;
        }
        if (this.trustStoreFilePath == null) {
            this.trustStoreFilePath = System.getProperty(STANDARD_TRUST_STORE_FILE_PATH);
        }
        return this.trustStoreFilePath;
    }

    private String getKeyStoreFile() {
        String path;
        if (this.keyStoreFilePath != null) {
            return this.keyStoreFilePath;
        }
        if (this.config != null && (path = (String)this.config.get(REMOTING_KEY_STORE_FILE_PATH)) != null && path.length() > 0) {
            this.keyStoreFilePath = path;
        }
        if (this.keyStoreFilePath == null) {
            this.keyStoreFilePath = System.getProperty(STANDARD_KEY_STORE_FILE_PATH);
        }
        return this.keyStoreFilePath;
    }

    public void setKeyStoreFile(String keyStoreFilePath) {
        this.keyStoreFilePath = keyStoreFilePath;
    }

    public void setTrustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
    }

    private String getTrustStorePassword() {
        String passwd;
        if (this.trustStorePassword != null) {
            return this.trustStorePassword;
        }
        if (this.config != null && (passwd = (String)this.config.get(REMOTING_TRUST_STORE_PASSWORD)) != null && passwd.length() > 0) {
            this.trustStorePassword = passwd;
        }
        if (this.trustStorePassword == null) {
            this.trustStorePassword = System.getProperty(STANDARD_TRUST_STORE_PASSWORD);
        }
        if (this.trustStorePassword == null) {
            this.trustStorePassword = this.getKeyStorePassword();
        }
        return this.trustStorePassword;
    }

    private String getKeyStorePassword() {
        String passwd;
        if (this.keyStorePassword != null) {
            return this.keyStorePassword;
        }
        if (this.config != null && (passwd = (String)this.config.get(REMOTING_KEY_STORE_PASSWORD)) != null && passwd.length() > 0) {
            this.keyStorePassword = passwd;
        }
        if (this.keyStorePassword == null) {
            this.keyStorePassword = System.getProperty(STANDARD_KEY_STORE_PASSWORD);
        }
        return this.keyStorePassword;
    }

    private void initializeUseClientMode() {
        if (this.config.get(REMOTING_USE_CLIENT_MODE).equals("false")) {
            this.useClientMode = false;
        }
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public void setTrustStoreType(String trustStoreType) {
        this.trustStoreType = trustStoreType;
    }

    public String getTrustStoreType() {
        String type;
        if (this.trustStoreType != null) {
            return this.trustStoreType;
        }
        if (this.config != null && (type = (String)this.config.get(REMOTING_TRUST_STORE_TYPE)) != null && type.length() > 0) {
            this.trustStoreType = type;
        }
        if (this.trustStoreType == null) {
            this.trustStoreType = System.getProperty(STANDARD_TRUST_STORE_TYPE);
        }
        if (this.trustStoreType == null) {
            this.trustStoreType = DEFAULT_KEY_STORE_TYPE;
        }
        return this.trustStoreType;
    }

    public String getKeyStoreType() {
        String type;
        if (this.keyStoreType != null) {
            return this.keyStoreType;
        }
        if (this.config != null && (type = (String)this.config.get(REMOTING_KEY_STORE_TYPE)) != null && type.length() > 0) {
            this.keyStoreType = type;
        }
        if (this.keyStoreType == null) {
            this.keyStoreType = System.getProperty(STANDARD_KEY_STORE_TYPE);
        }
        if (this.keyStoreType == null) {
            this.keyStoreType = DEFAULT_KEY_STORE_TYPE;
        }
        return this.keyStoreType;
    }

    public void setKeyStoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
    }

    public void setTrustAlgorithm(String algorithm) {
        this.trustAlgorithm = algorithm;
    }

    public String getTrustAlgorithm() {
        String alg;
        if (this.trustAlgorithm != null) {
            return this.trustAlgorithm;
        }
        if (this.config != null && (alg = (String)this.config.get(REMOTING_TRUST_ALGORITHM)) != null && alg.length() > 0) {
            this.trustAlgorithm = alg;
        }
        if (this.trustAlgorithm == null) {
            this.trustAlgorithm = this.getAlgorithm();
        }
        return this.trustAlgorithm;
    }

    public String getAlgorithm() {
        String alg;
        if (this.algorithm != null) {
            return this.algorithm;
        }
        if (this.config != null && (alg = (String)this.config.get(REMOTING_ALGORITHM)) != null && alg.length() > 0) {
            this.algorithm = alg;
        }
        if (this.algorithm == null) {
            this.algorithm = DEFAULT_ALGORITHM;
        }
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public String getKeyAlias() {
        if (this.keyAlias != null) {
            return this.keyAlias;
        }
        if (this.config != null) {
            this.keyAlias = (String)this.config.get(REMOTING_KEY_ALIAS);
        }
        return this.keyAlias;
    }

    public void setKeyAlias(String alias) {
        this.keyAlias = alias;
    }

    public String[] getDefaultCipherSuites() {
        if (this.socketFactory == null) {
            try {
                this.init();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.socketFactory.getDefaultCipherSuites();
    }

    public String[] getSupportedCipherSuites() {
        if (this.socketFactory == null) {
            try {
                this.init();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.socketFactory.getSupportedCipherSuites();
    }

    public Socket createSocket() throws IOException {
        if (this.socketFactory == null) {
            this.init();
        }
        SSLSocket s = (SSLSocket)this.socketFactory.createSocket();
        if (!this.useClientMode) {
            s.setUseClientMode(false);
        }
        return this.socketFactory.createSocket();
    }

    public Socket createSocket(Socket socket, String string, int i, boolean b) throws IOException {
        if (this.socketFactory == null) {
            this.init();
        }
        SSLSocket s = (SSLSocket)this.socketFactory.createSocket(socket, string, i, b);
        if (!this.useClientMode) {
            s.setUseClientMode(false);
        }
        return s;
    }

    public Socket createSocket(String string, int i) throws IOException, UnknownHostException {
        if (this.socketFactory == null) {
            this.init();
        }
        SSLSocket s = (SSLSocket)this.socketFactory.createSocket(string, i);
        if (!this.useClientMode) {
            s.setUseClientMode(false);
        }
        return s;
    }

    public Socket createSocket(InetAddress inetAddress, int i) throws IOException {
        if (this.socketFactory == null) {
            this.init();
        }
        SSLSocket s = (SSLSocket)this.socketFactory.createSocket(inetAddress, i);
        if (!this.useClientMode) {
            s.setUseClientMode(false);
        }
        return s;
    }

    public Socket createSocket(String string, int i, InetAddress inetAddress, int i1) throws IOException, UnknownHostException {
        if (this.socketFactory == null) {
            this.init();
        }
        SSLSocket s = (SSLSocket)this.socketFactory.createSocket(string, i, inetAddress, i1);
        if (!this.useClientMode) {
            s.setUseClientMode(false);
        }
        return s;
    }

    public Socket createSocket(InetAddress inetAddress, int i, InetAddress inetAddress1, int i1) throws IOException {
        if (this.socketFactory == null) {
            this.init();
        }
        SSLSocket s = (SSLSocket)this.socketFactory.createSocket(inetAddress, i, inetAddress1, i1);
        if (!this.useClientMode) {
            s.setUseClientMode(false);
        }
        return s;
    }
}

