/* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package com.titan.client;

import javax.naming.Context;

import junit.framework.TestCase;

import com.titan.domain.Ship;
import com.titan.travelagent.TravelAgentRemote;

/**
 * @author <a href="ron.sigal@jboss.com">Ron Sigal</a>
 * @version $Revision: 1.1 $
 * <p>
 * Copyright Jun 19, 2008
 * </p>
 */
public class Client extends TestCase
{
   public void testScoped() throws Exception 
   {
      try 
      {
         Context jndiContext = getInitialContext();
         Object ref = jndiContext.lookup("titan2/TravelAgentBean/remote");
         TravelAgentRemote dao = (TravelAgentRemote)ref;
         Ship ship = dao.getShip();
         System.out.println("ship type: " + ship.getClass());
         System.out.println("ship name: " + ship.getName());
         System.out.println("tonnage: " + ship.getTonnage());
         assertEquals("com.titan.domain.Titanic", ship.getClass().getName());
         assertEquals("Titanic", ship.getName());
         assertEquals(99999, ship.getTonnage());
      } 
      catch (javax.naming.NamingException ne)
      {
         ne.printStackTrace();
      }
   }

   public static Context getInitialContext() 
   throws javax.naming.NamingException 
   {
      return new javax.naming.InitialContext();
   }
}
