/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/

package org.jboss.test.remoting.locator;

import java.net.InetAddress;

import junit.framework.TestCase;
import org.jboss.remoting.InvokerLocator;

/**
 * @author <a href="mailto:tom.elrod@jboss.com">Tom Elrod</a>
 */
public class InvokerLocatorTestCase extends TestCase
{
   public void testLocatorConfig() throws Exception
   {
      InvokerLocator locator = new InvokerLocator("http://localhost:1234/services/uri:Test");
      InvokerLocator locator2 = new InvokerLocator("http://localhost:1234");
      InvokerLocator locator3 = new InvokerLocator("http://127.0.0.1:1234");
      InvokerLocator locator4 = new InvokerLocator("http://1.2.3.4/aaa");
      InvokerLocator locator5 = new InvokerLocator("http://1.2.3.4/abB");

      assertFalse(locator.equals(null));
      assertFalse(locator.equals(locator2));
      assertFalse(locator.isSameEndpoint(null));
      assertTrue(locator.isSameEndpoint(locator2));
      assertFalse(locator.equals(locator3));
      assertFalse(locator.isSameEndpoint(locator3));

      assertTrue(locator4.equals(locator4));
      assertFalse(locator4.equals(locator5));
      assertTrue(locator5.equals(locator5));
      assertFalse(locator5.equals(locator4));

      String url = locator.getLocatorURI();
      String origUrl = locator.getOriginalURI();

//      assertEquals("http://127.0.0.1:1234/services/uri:Test", url);
      assertEquals("http://localhost:1234/services/uri:Test", url);
      assertEquals("http://localhost:1234/services/uri:Test", origUrl);

      locator = new InvokerLocator("http://localhost/services/uri:Test");

      url = locator.getLocatorURI();
      origUrl = locator.getOriginalURI();

//      assertEquals("http://127.0.0.1/services/uri:Test", url);
      assertEquals("http://localhost/services/uri:Test", url);
      assertEquals("http://localhost/services/uri:Test", origUrl);

      locator = new InvokerLocator("socket://localhost:1234");

      url = locator.getLocatorURI();
      origUrl = locator.getOriginalURI();

//      assertEquals("socket://127.0.0.1:1234/", url);
      assertEquals("socket://localhost:1234/", url);
      assertEquals("socket://localhost:1234", origUrl);

      locator = new InvokerLocator("socket://localhost:1234/some/path");

      url = locator.getLocatorURI();
      origUrl = locator.getOriginalURI();

//      assertEquals("socket://127.0.0.1:1234/some/path", url);
      assertEquals("socket://localhost:1234/some/path", url);
      assertEquals("socket://localhost:1234/some/path", origUrl);

      locator = new InvokerLocator("socket://myhost:1234");

      url = locator.getLocatorURI();
      origUrl = locator.getOriginalURI();

      assertEquals("socket://myhost:1234/", url);
      assertEquals("socket://myhost:1234", origUrl);

      locator = new InvokerLocator("socket://myhost");

      url = locator.getLocatorURI();
      origUrl = locator.getOriginalURI();

      assertEquals("socket://myhost/", url);
      assertEquals("socket://myhost", origUrl);

      locator = new InvokerLocator("socket://myhost");

      url = locator.getLocatorURI();
      origUrl = locator.getOriginalURI();

      assertEquals("socket://myhost/", url);
      assertEquals("socket://myhost", origUrl);

   }
   
   public void testNullHost()  throws Exception
   {
      InvokerLocator locator = new InvokerLocator("socket://:7777");

      String bindByHost = System.getProperty(InvokerLocator.BIND_BY_HOST, "True");
      boolean byHost = true;
      String host = null;

      try
      {
         byHost = Boolean.getBoolean(bindByHost);
      }
      catch(Exception e)
      {
      }
      if(byHost)
      {
         host = InetAddress.getLocalHost().getHostName();
      }
      else
      {
         host = InetAddress.getLocalHost().getHostAddress();
      }

      assertEquals(host, locator.getHost());
   }

   /**
    * For JBREM-1110.
    */
   public void testEmptyParameters() throws Exception
   {
      InvokerLocator locator = new InvokerLocator("socket://:7777");
      assertNotNull(locator.getParameters());
   }
}