/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2009, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.test.remoting.marshall.config;

import java.io.IOException;
import java.io.OutputStream;

import org.apache.log4j.Logger;
import org.jboss.remoting.marshal.Marshaller;
import org.jboss.remoting.marshal.serializable.SerializableMarshaller;

/**
 * @author <a href="ron.sigal@jboss.com">Ron Sigal</a>
 * @version 
 * <p>
 * Copyright Mar 24, 2009
 * </p>
 */
public class ConfigTestMarshaller extends SerializableMarshaller
{
   protected static Logger log = Logger.getLogger(ConfigTestMarshaller.class);
   private static final long serialVersionUID = 1L;
   public static int cloned;
   public static boolean wrote;

   public void write(Object dataObject, OutputStream output, int version) throws IOException
   {
      log.info(this + "writing Wrapper");
      super.write(new Wrapper(dataObject), output, version);
      wrote = true;
   }
   
   public Marshaller cloneMarshaller() throws CloneNotSupportedException
   {
      cloned++;
//      log.info("cloned ConfigTestMarshaller", new Exception());
//      log.info("cloned ConfigTestMarshaller", new Exception());
      return new ConfigTestMarshaller();
   }
   
   public static boolean ok(boolean b, int count)
   {
      log.info("wrote: " + wrote + ", cloned: " + cloned);
      return wrote == b && cloned == count;
   }
   
   public static void reset()
   {
      cloned = 0;
      wrote = false;
      log.info("reset: wrote: " + wrote + ", cloned: " + cloned);
   }
}

