/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.test.remoting.shutdown;

import java.net.InetAddress;
import java.util.HashMap;

import javax.management.MBeanServer;

import org.jboss.jrunit.extensions.ServerTestCase;
import org.jboss.remoting.Client;
import org.jboss.remoting.ConnectionListener;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.ServerInvocationHandler;
import org.jboss.remoting.ServerInvoker;
import org.jboss.remoting.callback.Callback;
import org.jboss.remoting.callback.HandleCallbackException;
import org.jboss.remoting.callback.InvokerCallbackHandler;
import org.jboss.remoting.transport.Connector;

/** 
 * This is the server half of a unit test designed to verify that a Remoting application
 * will shut down without any stray threads hanging it up.  To exercise as many
 * Remoting threads as possible, the server enables leasing and registers a
 * connection listener.
 * 
 * @author <a href="ron.sigal@jboss.com">Ron Sigal</a>
 * @version $Revision: 1961 $
 * <p>
 * Copyright Jan 19, 2007
 * </p>
 */
public class ShutdownTestServer extends ServerTestCase
{
   public static int port = 9876;
   private Connector connector;
   private String transport;
   
   
   public ShutdownTestServer(String transport)
   {
      this.transport = transport;
   }
   
   
   public void setUp() throws Exception
   {
      String host = InetAddress.getLocalHost().getHostAddress();
      String locatorURI = transport + "://" + host + ":" + port;
      InvokerLocator locator = new InvokerLocator(locatorURI);
      HashMap serverConfig = new HashMap();
      connector = new Connector(locator, serverConfig);
      connector.create();
      connector.setLeasePeriod(1000);
      connector.addInvocationHandler("test", new TestHandler());
      connector.addConnectionListener(new TestListener());
      connector.start();
      System.out.println("server started at: " + locatorURI);
   }
   
   
   public void tearDown()
   {
      if (connector != null)
      {
         connector.stop();
         System.out.println("server shut down");
      }
   }
   
   
   public static void main(String[] args)
   {
      if (args.length == 0)
         throw new RuntimeException();
      
      String transport = args[0];
      ShutdownTestServer server = new ShutdownTestServer(transport);
      try
      {
         server.setUp();
         Thread.sleep(4000);
         server.tearDown();
      }
      catch(Exception e)
      {
         e.printStackTrace();
      }
   }

   
   public class TestHandler implements ServerInvocationHandler
   {
      public void setMBeanServer(MBeanServer server) {}
      public void setInvoker(ServerInvoker invoker) {}

      public Object invoke(InvocationRequest invocation) throws Throwable
      {
         Integer i = (Integer) invocation.getParameter();
         return new Integer(i.intValue() + 1);
      }

      public void addListener(InvokerCallbackHandler callbackHandler)
      {
         try
         {
            System.out.println("sending callback");
            callbackHandler.handleCallback(new Callback("callback"));
            System.out.println("sent callback");
         }
         catch (HandleCallbackException e)
         {
            System.out.println("error handling callback");
            e.printStackTrace();
         }
      }
      
      public void removeListener(InvokerCallbackHandler callbackHandler) {}
   }
   
   
   public static class TestListener implements ConnectionListener
   {
      public void handleConnectionException(Throwable throwable, Client client)
      {
         System.out.println("got connection exception: " + throwable);
      }
   }
}
