/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/

/*
 * Created on Feb 26, 2006
 */
package org.jboss.test.remoting.transport.multiplex;

import junit.framework.TestCase;

import org.jboss.logging.Logger;
import org.jboss.remoting.Client;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.transport.Connector;
import org.jboss.remoting.transporter.TransporterClient;


/**
 * @author <a href="mailto:r.sigal@computer.org">Ron Sigal</a>
 * @version $Revision: 1977 $
 * <p>
 * Copyright (c) 2005
 * </p>
 */

public class MultiplexInvokerShutdownTestClient extends TestCase
{
   private static final Logger log = Logger.getLogger(MultiplexInvokerShutdownTestClient.class);
   private static EventRegistry eventRegistry;
   
   
   public MultiplexInvokerShutdownTestClient()
   {
   }
   
   public void setUp() throws Exception
   {
      if (eventRegistry == null)
      {
         Object o = TransporterClient.createTransporterClient(EventRegistry_Impl.eventRegistryLocatorUriString, EventRegistry.class);
         eventRegistry = (EventRegistry) o;
      }
   }
   
   
   public void tearDown()
   {
      if (eventRegistry == null)
         TransporterClient.destroyTransporterClient(eventRegistry);
   }
   
   
   public void testInvokerShutdown()
   {
      try
      {
         // Start callback server.
         InvokerLocator connectLocator = new InvokerLocator(MultiplexInvokerShutdownTestServer.locatorString);
         String callbackURI = "multiplex://localhost:5282" +
         	"/?serverMultiplexId=testMultiplexId" +
         	"&multiplexConnectHost=" + connectLocator.getHost() +
         	"&multiplexConnectPort=" + connectLocator.getPort();
         Connector connector = new Connector();
         connector.setInvokerLocator(callbackURI);
         connector.start();

         // Start client,
         Client client = new Client(connectLocator);
         client.connect();
         client.invoke("test 1");
         client.invoke("test 2");
         
         // Post created event.
         eventRegistry.postEvent(MultiplexInvokerShutdownTestServer.CREATED_EVENT);
         
         // Wait for consent to shut down.
         eventRegistry.waitOnEvent(MultiplexInvokerShutdownTestServer.SHUTDOWN_CONSENT_EVENT);
         
         // Shut down client and callback server.
         connector.stop();
         client.disconnect();
         
         // Post shutdown event.
         eventRegistry.postEvent(MultiplexInvokerShutdownTestServer.CLIENT_SHUTDOWN_EVENT);
         
         // Wait for server to shut down, so TestDriver doesn't it it down from above..
         eventRegistry.waitOnEvent(MultiplexInvokerShutdownTestServer.SERVER_SHUTDOWN_EVENT);
      }
      catch (Throwable e)
      {
         log.error(e);
         e.printStackTrace();
         fail();
      }
   }
}

