/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.snmp;

import org.opennms.protocols.snmp.asn1.AsnEncoder;
import org.opennms.protocols.snmp.asn1.BerEncoder;

public class SnmpParameters
implements Cloneable {
    private String m_readCommunity;
    private String m_writeCommunity;
    private int m_version;
    private AsnEncoder m_encoder;
    public static final String defaultCommunity = "public";
    public static final AsnEncoder defaultEncoder = new BerEncoder();
    public static final int defaultVersion = 0;

    public SnmpParameters() {
        this.m_readCommunity = defaultCommunity;
        this.m_writeCommunity = null;
        this.m_version = 0;
        this.m_encoder = defaultEncoder;
    }

    public SnmpParameters(SnmpParameters second) {
        this.m_readCommunity = second.m_readCommunity;
        this.m_writeCommunity = second.m_writeCommunity;
        this.m_version = second.m_version;
        this.m_encoder = second.m_encoder;
    }

    public SnmpParameters(int version) {
        this();
        this.m_version = version;
    }

    public SnmpParameters(String read) {
        this();
        this.m_readCommunity = read;
    }

    public SnmpParameters(String read, String write) {
        this();
        this.m_readCommunity = read;
        this.m_writeCommunity = write;
    }

    public String getReadCommunity() {
        return this.m_readCommunity;
    }

    public void setReadCommunity(String rd) {
        this.m_readCommunity = rd;
    }

    public String getWriteCommunity() {
        return this.m_writeCommunity;
    }

    public void setWriteCommunity(String wr) {
        this.m_writeCommunity = wr;
    }

    public int getVersion() {
        return this.m_version;
    }

    public void setVersion(int ver) {
        this.m_version = ver;
    }

    public AsnEncoder getEncoder() {
        return this.m_encoder;
    }

    public void setEncoder(AsnEncoder encoder) {
        this.m_encoder = encoder;
    }

    public Object clone() {
        return new SnmpParameters(this);
    }
}

