/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.hibernate.cache.Cache;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.TransactionAwareCache;
import org.jboss.cache.Fqn;
import org.jboss.cache.lock.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeCache
implements Cache,
TransactionAwareCache {
    private static final Logger log = LoggerFactory.getLogger((Class)TreeCache.class);
    private static final String ITEM = "item";
    private org.jboss.cache.TreeCache cache;
    private final String regionName;
    private final Fqn regionFqn;
    private final TransactionManager transactionManager;

    public TreeCache(org.jboss.cache.TreeCache cache, String regionName, TransactionManager transactionManager) throws CacheException {
        this.cache = cache;
        this.regionName = regionName;
        this.regionFqn = Fqn.fromString((String)regionName.replace('.', '/'));
        this.transactionManager = transactionManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object key) throws CacheException {
        Transaction tx = this.suspend();
        try {
            Object object = this.read(key);
            return object;
        }
        finally {
            this.resume(tx);
        }
    }

    public Object read(Object key) throws CacheException {
        try {
            return this.cache.get(new Fqn(this.regionFqn, key), (Object)ITEM);
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    public void update(Object key, Object value) throws CacheException {
        try {
            this.cache.put(new Fqn(this.regionFqn, key), (Object)ITEM, value);
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    public void put(Object key, Object value) throws CacheException {
        Transaction tx = this.suspend();
        try {
            this.cache.putFailFast(new Fqn(this.regionFqn, key), (Object)ITEM, value, 0L);
        }
        catch (TimeoutException te) {
            log.debug("ignoring write lock acquisition failure");
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
        finally {
            this.resume(tx);
        }
    }

    private void resume(Transaction tx) {
        try {
            if (tx != null) {
                this.transactionManager.resume(tx);
            }
        }
        catch (Exception e) {
            throw new CacheException("Could not resume transaction", (Throwable)e);
        }
    }

    private Transaction suspend() {
        Transaction tx = null;
        try {
            if (this.transactionManager != null) {
                tx = this.transactionManager.suspend();
            }
        }
        catch (SystemException se) {
            throw new CacheException("Could not suspend transaction", (Throwable)se);
        }
        return tx;
    }

    public void remove(Object key) throws CacheException {
        try {
            this.cache.remove(new Fqn(this.regionFqn, key));
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    public void clear() throws CacheException {
        try {
            this.cache.remove(this.regionFqn);
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    public void destroy() throws CacheException {
        try {
            this.cache.evict(this.regionFqn);
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    public void lock(Object key) throws CacheException {
        throw new UnsupportedOperationException("TreeCache is a fully transactional cache" + this.regionName);
    }

    public void unlock(Object key) throws CacheException {
        throw new UnsupportedOperationException("TreeCache is a fully transactional cache: " + this.regionName);
    }

    public long nextTimestamp() {
        return System.currentTimeMillis() / 100L;
    }

    public int getTimeout() {
        return 600;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public long getSizeInMemory() {
        return -1L;
    }

    public long getElementCountInMemory() {
        try {
            Set children = this.cache.getChildrenNames(this.regionFqn);
            return children == null ? 0L : (long)children.size();
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    public long getElementCountOnDisk() {
        return 0L;
    }

    public Map toMap() {
        try {
            HashMap result = new HashMap();
            Set childrenNames = this.cache.getChildrenNames(this.regionFqn);
            if (childrenNames != null) {
                Iterator iter = childrenNames.iterator();
                while (iter.hasNext()) {
                    Object key = iter.next();
                    result.put(key, this.cache.get(new Fqn(this.regionFqn, key), (Object)ITEM));
                }
            }
            return result;
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    public String toString() {
        return "TreeCache(" + this.regionName + ')';
    }
}

