/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment;

import java.io.IOException;
import java.lang.reflect.AnnotatedElement;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.helpers.AbstractDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.deployment.AnnotatedClassFilter;
import org.jboss.metadata.annotation.creator.client.ApplicationClient5MetaDataCreator;
import org.jboss.metadata.annotation.creator.ejb.EjbJar30Creator;
import org.jboss.metadata.annotation.creator.web.Web25MetaDataCreator;
import org.jboss.metadata.annotation.finder.AnnotationFinder;
import org.jboss.metadata.annotation.finder.DefaultAnnotationFinder;
import org.jboss.metadata.client.spec.ApplicationClient5MetaData;
import org.jboss.metadata.client.spec.ApplicationClientMetaData;
import org.jboss.metadata.ejb.spec.EjbJar30MetaData;
import org.jboss.metadata.ejb.spec.EjbJar3xMetaData;
import org.jboss.metadata.ejb.spec.EjbJarMetaData;
import org.jboss.metadata.web.spec.Web25MetaData;
import org.jboss.metadata.web.spec.WebMetaData;
import org.jboss.virtual.VFSUtils;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.VirtualFileVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationMetaDataDeployer
extends AbstractDeployer {
    public static final String EJB_ANNOTATED_ATTACHMENT_NAME = "annotated." + EjbJarMetaData.class.getName();
    public static final String CLIENT_ANNOTATED_ATTACHMENT_NAME = "annotated." + ApplicationClientMetaData.class.getName();
    public static final String WEB_ANNOTATED_ATTACHMENT_NAME = "annotated." + WebMetaData.class.getName();
    private boolean metaDataCompleteIsDefault = false;

    public AnnotationMetaDataDeployer() {
        this.setStage(DeploymentStages.POST_CLASSLOADER);
        this.addInput(EjbJarMetaData.class);
        this.addInput(WebMetaData.class);
        this.addInput(ApplicationClientMetaData.class);
        this.addOutput(EJB_ANNOTATED_ATTACHMENT_NAME);
        this.addOutput(CLIENT_ANNOTATED_ATTACHMENT_NAME);
        this.addOutput(WEB_ANNOTATED_ATTACHMENT_NAME);
    }

    public boolean isMetaDataCompleteIsDefault() {
        return this.metaDataCompleteIsDefault;
    }

    public void setMetaDataCompleteIsDefault(boolean metaDataCompleteIsDefault) {
        this.metaDataCompleteIsDefault = metaDataCompleteIsDefault;
    }

    public void deploy(DeploymentUnit unit) throws DeploymentException {
        if (!(unit instanceof VFSDeploymentUnit)) {
            return;
        }
        VFSDeploymentUnit vfsDeploymentUnit = (VFSDeploymentUnit)unit;
        this.deploy(vfsDeploymentUnit);
    }

    public void undeploy(DeploymentUnit unit) {
        if (!(unit instanceof VFSDeploymentUnit)) {
            return;
        }
        VFSDeploymentUnit vfsDeploymentUnit = (VFSDeploymentUnit)unit;
        this.undeploy(vfsDeploymentUnit);
    }

    protected void deploy(VFSDeploymentUnit unit) throws DeploymentException {
        boolean isComplete = this.isMetaDataCompleteIsDefault();
        EjbJarMetaData ejbJarMetaData = (EjbJarMetaData)unit.getAttachment(EjbJarMetaData.class);
        if (ejbJarMetaData != null && ejbJarMetaData instanceof EjbJar3xMetaData) {
            isComplete |= ((EjbJar3xMetaData)ejbJarMetaData).isMetadataComplete();
        } else if (ejbJarMetaData != null) {
            isComplete = true;
        }
        WebMetaData webMetaData = (WebMetaData)unit.getAttachment(WebMetaData.class);
        if (webMetaData != null && webMetaData instanceof Web25MetaData) {
            isComplete |= ((Web25MetaData)webMetaData).isMetadataComplete();
        } else if (webMetaData != null) {
            isComplete = true;
        }
        ApplicationClientMetaData clientMetaData = (ApplicationClientMetaData)unit.getAttachment(ApplicationClientMetaData.class);
        if (clientMetaData != null) {
            isComplete |= clientMetaData.isMetadataComplete();
        }
        if (isComplete) {
            this.log.debug((Object)("Deployment is metadata-complete, skipping annotation processing, ejbJarMetaData=" + ejbJarMetaData + ", jbossWebMetaData=" + webMetaData + ", jbossClientMetaData=" + clientMetaData + ", metaDataCompleteIsDefault=" + this.metaDataCompleteIsDefault));
            return;
        }
        VirtualFile root = unit.getRoot();
        boolean isLeaf = true;
        try {
            isLeaf = root.isLeaf();
        }
        catch (IOException ignore) {
            // empty catch block
        }
        if (isLeaf) {
            return;
        }
        List classpath = unit.getClassPath();
        if (classpath == null || classpath.isEmpty()) {
            return;
        }
        boolean trace = this.log.isTraceEnabled();
        if (trace) {
            this.log.trace((Object)("Deploying annotations for unit: " + unit + ", classpath: " + classpath));
        }
        try {
            String mainClassName = this.getMainClassName(unit);
            Collection<Class<?>> classes = this.getClasses(unit, mainClassName, classpath);
            if (classes.size() > 0) {
                DefaultAnnotationFinder finder = new DefaultAnnotationFinder();
                if (webMetaData != null) {
                    this.processJBossWebMetaData(unit, (AnnotationFinder<AnnotatedElement>)finder, classes);
                } else if (clientMetaData != null || mainClassName != null) {
                    this.processJBossClientMetaData(unit, (AnnotationFinder<AnnotatedElement>)finder, classes);
                } else {
                    this.processJBossMetaData(unit, (AnnotationFinder<AnnotatedElement>)finder, classes);
                }
            }
        }
        catch (IOException e) {
            throw new DeploymentException((Throwable)e);
        }
    }

    protected Collection<Class<?>> getClasses(VFSDeploymentUnit unit, String mainClassName, List<VirtualFile> classpath) throws IOException {
        HashMap classpathClasses = new HashMap();
        for (VirtualFile path : classpath) {
            AnnotatedClassFilter classVisitor = new AnnotatedClassFilter(unit, unit.getClassLoader(), path, mainClassName);
            path.visit((VirtualFileVisitor)classVisitor);
            Map<VirtualFile, Class<?>> classes = classVisitor.getAnnotatedClasses();
            if (classes == null || classes.size() <= 0) continue;
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Annotated classes: " + classes));
            }
            classpathClasses.putAll(classes);
        }
        return classpathClasses.values();
    }

    protected void undeploy(VFSDeploymentUnit unit) {
    }

    protected void processJBossMetaData(VFSDeploymentUnit unit, AnnotationFinder<AnnotatedElement> finder, Collection<Class<?>> classes) {
        EjbJar30Creator creator = new EjbJar30Creator(finder);
        EjbJar30MetaData annotationMetaData = creator.create(classes);
        if (annotationMetaData != null) {
            unit.addAttachment(EJB_ANNOTATED_ATTACHMENT_NAME, (Object)annotationMetaData, EjbJarMetaData.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getMainClassName(VFSDeploymentUnit unit) throws IOException {
        VirtualFile file = unit.getMetaDataFile("MANIFEST.MF");
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("parsing " + file));
        }
        if (file == null) {
            return null;
        }
        try {
            Manifest mf = VFSUtils.readManifest((VirtualFile)file);
            Attributes attrs = mf.getMainAttributes();
            String string = attrs.getValue(Attributes.Name.MAIN_CLASS);
            return string;
        }
        finally {
            file.close();
        }
    }

    protected void processJBossWebMetaData(VFSDeploymentUnit unit, AnnotationFinder<AnnotatedElement> finder, Collection<Class<?>> classes) {
        Web25MetaDataCreator creator = new Web25MetaDataCreator(finder);
        Web25MetaData annotationMetaData = creator.create(classes);
        if (annotationMetaData != null) {
            unit.addAttachment(WEB_ANNOTATED_ATTACHMENT_NAME, (Object)annotationMetaData, WebMetaData.class);
        }
    }

    protected void processJBossClientMetaData(VFSDeploymentUnit unit, AnnotationFinder<AnnotatedElement> finder, Collection<Class<?>> classes) {
        ApplicationClient5MetaDataCreator creator = new ApplicationClient5MetaDataCreator(finder);
        ApplicationClient5MetaData annotationMetaData = creator.create(classes);
        if (annotationMetaData != null) {
            unit.addAttachment(CLIENT_ANNOTATED_ATTACHMENT_NAME, (Object)annotationMetaData, ApplicationClientMetaData.class);
        }
    }
}

